/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt;

import br.com.anteros.persistence.apt.AbstractDslProcessor;
import br.com.anteros.persistence.apt.DefaultConfiguration;
import br.com.anteros.persistence.apt.QueryTypeImpl;
import br.com.anteros.persistence.apt.TypeUtils;
import br.com.anteros.persistence.apt.VisitorConfig;
import br.com.anteros.persistence.apt.codegen.Keywords;
import br.com.anteros.persistence.dsl.osql.annotations.PropertyType;
import br.com.anteros.persistence.dsl.osql.annotations.QueryEntities;
import br.com.anteros.persistence.dsl.osql.util.Annotations;
import br.com.anteros.persistence.metadata.annotation.Column;
import br.com.anteros.persistence.metadata.annotation.CompositeId;
import br.com.anteros.persistence.metadata.annotation.Enumerated;
import br.com.anteros.persistence.metadata.annotation.Fetch;
import br.com.anteros.persistence.metadata.annotation.ForeignKey;
import br.com.anteros.persistence.metadata.annotation.GeneratedValue;
import br.com.anteros.persistence.metadata.annotation.Id;
import br.com.anteros.persistence.metadata.annotation.Index;
import br.com.anteros.persistence.metadata.annotation.JoinColumn;
import br.com.anteros.persistence.metadata.annotation.MapKeyEnumerated;
import br.com.anteros.persistence.metadata.annotation.Temporal;
import br.com.anteros.persistence.metadata.annotation.Version;
import br.com.anteros.persistence.metadata.annotation.type.FetchMode;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class AnterosAptConfiguration
extends DefaultConfiguration {
    private final List<Class<? extends Annotation>> annotations = this.getAnnotations();
    private final Types types = AbstractDslProcessor.TYPES;

    public AnterosAptConfiguration(RoundEnvironment roundEnv, Map<String, String> options, Class<? extends Annotation> entityAnn, Class<? extends Annotation> superTypeAnn, Class<? extends Annotation> embeddableAnn, Class<? extends Annotation> embeddedAnn, Class<? extends Annotation> skipAnn) {
        super(roundEnv, options, Keywords.JPA, QueryEntities.class, entityAnn, superTypeAnn, embeddableAnn, embeddedAnn, skipAnn);
    }

    protected List<Class<? extends Annotation>> getAnnotations() {
        return ImmutableList.of(Column.class, Enumerated.class, GeneratedValue.class, Id.class, CompositeId.class, JoinColumn.class, Fetch.class, MapKeyEnumerated.class, ForeignKey.class, Temporal.class, Version.class, Index.class, (Object[])new Class[0]);
    }

    @Override
    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        boolean fields = false;
        boolean methods = false;
        for (Element element : elements) {
            if (!this.hasRelevantAnnotation(element)) continue;
            fields |= element.getKind().equals((Object)ElementKind.FIELD);
            methods |= element.getKind().equals((Object)ElementKind.METHOD);
        }
        return VisitorConfig.get(fields, methods);
    }

    @Override
    public TypeMirror getRealType(ExecutableElement method) {
        return this.getRealElementType(method);
    }

    @Override
    public TypeMirror getRealType(VariableElement field) {
        return this.getRealElementType(field);
    }

    private TypeMirror getRealElementType(Element element) {
        AnnotationMirror mirror = this.getFetchAnnotationMirror(element, FetchMode.ONE_TO_MANY);
        if (mirror == null) {
            mirror = this.getFetchAnnotationMirror(element, FetchMode.MANY_TO_MANY);
        }
        if (mirror != null) {
            TypeMirror typeArg = TypeUtils.getAnnotationValueAsTypeMirror(mirror, "targetEntity");
            TypeMirror erasure = this.types.erasure(element.asType());
            TypeElement typeElement = (TypeElement)this.types.asElement(erasure);
            if (typeElement != null && typeArg != null) {
                if (typeElement.getTypeParameters().size() == 1) {
                    return this.types.getDeclaredType(typeElement, typeArg);
                }
                if (typeElement.getTypeParameters().size() == 2 && element.asType() instanceof DeclaredType) {
                    TypeMirror first = ((DeclaredType)element.asType()).getTypeArguments().get(0);
                    return this.types.getDeclaredType(typeElement, first, typeArg);
                }
            }
        }
        return null;
    }

    protected AnnotationMirror getFetchAnnotationMirror(Element element, FetchMode mode) {
        Fetch fetch = element.getAnnotation(Fetch.class);
        if (fetch == null) {
            return null;
        }
        if (fetch.mode() == mode) {
            return TypeUtils.getAnnotationMirrorOfType(element, Fetch.class);
        }
        return null;
    }

    @Override
    public void inspect(Element element, Annotations annotations) {
        Temporal temporal = element.getAnnotation(Temporal.class);
        Fetch fetch = element.getAnnotation(Fetch.class);
        boolean isElementCollection = false;
        if (fetch != null) {
            boolean bl = isElementCollection = fetch.mode() == FetchMode.ELEMENT_COLLECTION;
        }
        if (temporal != null && !isElementCollection) {
            PropertyType propertyType = null;
            switch (temporal.value()) {
                case DATE: {
                    propertyType = PropertyType.DATE;
                    break;
                }
                case TIME: {
                    propertyType = PropertyType.TIME;
                    break;
                }
                case DATE_TIME: {
                    propertyType = PropertyType.DATETIME;
                }
            }
            annotations.addAnnotation((Annotation)((Object)new QueryTypeImpl(propertyType)));
        }
    }

    private boolean hasRelevantAnnotation(Element element) {
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (element.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }
}

