/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen.model;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public enum TypeCategory {
    SIMPLE(null, new String[0]),
    MAP(null, new String[0]),
    COLLECTION(null, new String[0]),
    LIST(COLLECTION, new String[0]),
    SET(COLLECTION, new String[0]),
    ARRAY(null, new String[0]),
    COMPARABLE(SIMPLE, new String[0]),
    BOOLEAN(COMPARABLE, Boolean.class.getName()),
    DATE(COMPARABLE, java.sql.Date.class.getName(), "org.joda.time.LocalDate", "java.time.LocalDate"),
    DATETIME(COMPARABLE, Calendar.class.getName(), Date.class.getName(), Timestamp.class.getName(), "org.joda.time.LocalDateTime", "org.joda.time.Instant", "org.joda.time.DateTime", "org.joda.time.DateMidnight", "java.time.Instant", "java.time.LocalDateTime", "java.time.OffsetDateTime", "java.time.ZonedDateTime"),
    ENUM(COMPARABLE, new String[0]),
    CUSTOM(null, new String[0]),
    ENTITY(null, new String[0]),
    NUMERIC(COMPARABLE, new String[0]),
    STRING(COMPARABLE, String.class.getName()),
    TIME(COMPARABLE, Time.class.getName(), "org.joda.time.LocalTime", "java.time.LocalTime", "java.time.OffsetTime"),
    INDEX(null, new String[0]);

    private final TypeCategory superType;
    private final Set<String> types;

    private TypeCategory(TypeCategory superType, String ... types) {
        this.superType = superType;
        this.types = new HashSet<String>(types.length);
        String[] stringArray = types;
        int n2 = types.length;
        int n3 = 0;
        while (n3 < n2) {
            String type = stringArray[n3];
            this.types.add(type);
            ++n3;
        }
    }

    public TypeCategory getSuperType() {
        return this.superType;
    }

    public boolean supports(Class<?> cl) {
        return this.supports(cl.getName());
    }

    public boolean supports(String className) {
        return this.types.contains(className);
    }

    public boolean isSubCategoryOf(TypeCategory ancestor) {
        if (this == ancestor) {
            return true;
        }
        if (this.superType == null) {
            return false;
        }
        return this.superType == ancestor || this.superType.isSubCategoryOf(ancestor);
    }

    public static TypeCategory get(String className) {
        TypeCategory[] typeCategoryArray = TypeCategory.values();
        int n = typeCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeCategory category = typeCategoryArray[n2];
            if (category.supports(className)) {
                return category;
            }
            ++n2;
        }
        return SIMPLE;
    }
}

