/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.EntityType;
import br.com.anteros.persistence.apt.codegen.ParameterizedTypeImpl;
import br.com.anteros.persistence.apt.codegen.Property;
import br.com.anteros.persistence.apt.codegen.model.ClassType;
import br.com.anteros.persistence.apt.codegen.model.SimpleType;
import br.com.anteros.persistence.apt.codegen.model.Type;
import br.com.anteros.persistence.apt.codegen.model.TypeCategory;
import br.com.anteros.persistence.apt.codegen.model.TypeExtends;
import br.com.anteros.persistence.apt.codegen.model.TypeSuper;
import br.com.anteros.persistence.apt.codegen.model.Types;
import br.com.anteros.persistence.dsl.osql.util.ReflectionUtils;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TypeFactory {
    private static final Type ANY = new TypeExtends(Types.OBJECT);
    private final Map<List<java.lang.reflect.Type>, Type> cache = new HashMap<List<java.lang.reflect.Type>, Type>();
    private final List<Class<? extends Annotation>> entityAnnotations;
    private final Set<Class<?>> embeddableTypes = new HashSet();
    private boolean unknownAsEntity = false;

    public TypeFactory() {
        this(Lists.newArrayList());
    }

    public TypeFactory(List<Class<? extends Annotation>> entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public EntityType getEntityType(Class<?> cl) {
        java.lang.reflect.Type generic = cl;
        if (cl.getTypeParameters().length > 0) {
            generic = new ParameterizedTypeImpl(cl, cl.getTypeParameters());
        }
        return (EntityType)this.get(true, cl, generic);
    }

    public Type get(Class<?> cl) {
        return this.get(this.isEntityClass(cl), cl, cl);
    }

    public Type get(Class<?> cl, java.lang.reflect.Type genericType) {
        return this.get(this.isEntityClass(cl), cl, genericType);
    }

    public Type get(boolean entity, Class<?> cl, java.lang.reflect.Type genericType) {
        List<java.lang.reflect.Type> key = Arrays.asList(cl, genericType);
        if (this.cache.containsKey(key)) {
            Type value = this.cache.get(key);
            if (entity && !(value instanceof EntityType)) {
                value = new EntityType(value);
                this.cache.put(key, value);
            }
            return value;
        }
        Type value = this.create(entity, cl, genericType, key);
        this.cache.put(key, value);
        return value;
    }

    private Type create(boolean entity, Class<?> cl, java.lang.reflect.Type genericType, List<java.lang.reflect.Type> key) {
        Type value;
        if (cl.isPrimitive()) {
            cl = Primitives.wrap(cl);
        }
        Type[] tempParams = (Type[])Array.newInstance(Type.class, ReflectionUtils.getTypeParameterCount((java.lang.reflect.Type)genericType));
        this.cache.put(key, new ClassType(cl, tempParams));
        Type[] parameters = this.getParameters(cl, genericType);
        if (cl.isArray()) {
            Type componentType = this.get(cl.getComponentType());
            if (cl.getComponentType().isPrimitive()) {
                componentType = Types.PRIMITIVES.get(componentType);
            }
            value = componentType.asArrayType();
        } else {
            value = cl.isEnum() ? new ClassType(TypeCategory.ENUM, cl, new Type[0]) : (Number.class.isAssignableFrom(cl) && Comparable.class.isAssignableFrom(cl) ? new ClassType(TypeCategory.NUMERIC, cl, parameters) : (entity ? this.createOther(cl, entity, parameters) : (Map.class.isAssignableFrom(cl) ? new SimpleType((Type)Types.MAP, parameters[0], this.asGeneric(parameters[1])) : (List.class.isAssignableFrom(cl) ? new SimpleType((Type)Types.LIST, this.asGeneric(parameters[0])) : (Set.class.isAssignableFrom(cl) ? new SimpleType((Type)Types.SET, this.asGeneric(parameters[0])) : (Collection.class.isAssignableFrom(cl) ? new SimpleType((Type)Types.COLLECTION, this.asGeneric(parameters[0])) : this.createOther(cl, entity, parameters)))))));
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)genericType;
            value = tv.getBounds().length == 1 && tv.getBounds()[0].equals(Object.class) ? new TypeSuper(tv.getName(), value) : new TypeExtends(tv.getName(), value);
        }
        if (entity && !(value instanceof EntityType)) {
            value = new EntityType(value);
        }
        return value;
    }

    private Type asGeneric(Type type) {
        int count;
        if (type.getParameters().size() == 0 && (count = type.getJavaClass().getTypeParameters().length) > 0) {
            return new SimpleType(type, new Type[count]);
        }
        return type;
    }

    private Type createOther(Class<?> cl, boolean entity, Type[] parameters) {
        TypeCategory typeCategory = TypeCategory.get(cl.getName());
        if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && Comparable.class.isAssignableFrom(cl) && !cl.equals(Comparable.class)) {
            typeCategory = TypeCategory.COMPARABLE;
        } else if (this.embeddableTypes.contains(cl)) {
            typeCategory = TypeCategory.CUSTOM;
        } else if (typeCategory == TypeCategory.SIMPLE && entity) {
            typeCategory = TypeCategory.ENTITY;
        } else if (this.unknownAsEntity && typeCategory == TypeCategory.SIMPLE && !cl.getName().startsWith("java")) {
            typeCategory = TypeCategory.CUSTOM;
        }
        return new ClassType(typeCategory, cl, parameters);
    }

    private Type[] getParameters(Class<?> cl, java.lang.reflect.Type genericType) {
        int parameterCount = ReflectionUtils.getTypeParameterCount((java.lang.reflect.Type)genericType);
        if (parameterCount > 0) {
            return this.getGenericParameters(cl, genericType, parameterCount);
        }
        if (Map.class.isAssignableFrom(cl)) {
            return new Type[]{Types.OBJECT, Types.OBJECT};
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return new Type[]{Types.OBJECT};
        }
        return new Type[0];
    }

    private Type[] getGenericParameters(Class<?> cl, java.lang.reflect.Type genericType, int parameterCount) {
        Type[] types = new Type[parameterCount];
        int i = 0;
        while (i < types.length) {
            types[i] = this.getGenericParameter(cl, genericType, i);
            ++i;
        }
        return types;
    }

    private Type getGenericParameter(Class<?> cl, java.lang.reflect.Type genericType, int i) {
        java.lang.reflect.Type parameter = ReflectionUtils.getTypeParameter((java.lang.reflect.Type)genericType, (int)i);
        if (parameter instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)parameter;
            Type rv = this.get(ReflectionUtils.getTypeParameterAsClass((java.lang.reflect.Type)genericType, (int)i), parameter);
            return new TypeExtends(variable.getName(), rv);
        }
        if (parameter instanceof WildcardType && ((WildcardType)parameter).getUpperBounds()[0].equals(Object.class) && ((WildcardType)parameter).getLowerBounds().length == 0) {
            return ANY;
        }
        Type rv = this.get(ReflectionUtils.getTypeParameterAsClass((java.lang.reflect.Type)genericType, (int)i), parameter);
        if (parameter instanceof WildcardType) {
            rv = new TypeExtends(rv);
        }
        return rv;
    }

    private boolean isEntityClass(Class<?> cl) {
        for (Class<? extends Annotation> clazz : this.entityAnnotations) {
            if (cl.getAnnotation(clazz) == null) continue;
            return true;
        }
        return this.embeddableTypes.contains(cl);
    }

    public void extendTypes() {
        for (Map.Entry<List<java.lang.reflect.Type>, Type> entry : this.cache.entrySet()) {
            EntityType entityType;
            if (!(entry.getValue() instanceof EntityType) || !(entityType = (EntityType)entry.getValue()).getProperties().isEmpty()) continue;
            for (Type type : this.cache.values()) {
                if (!type.getFullName().equals(entityType.getFullName()) || !(type instanceof EntityType)) continue;
                EntityType base = (EntityType)type;
                for (Property property : base.getProperties()) {
                    entityType.addProperty(property);
                }
            }
        }
    }

    public void setUnknownAsEntity(boolean unknownAsEntity) {
        this.unknownAsEntity = unknownAsEntity;
    }

    public void addEmbeddableType(Class<?> cl) {
        this.embeddableTypes.add(cl);
    }
}

