/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.CodeWriter;
import br.com.anteros.persistence.apt.codegen.EntityType;
import br.com.anteros.persistence.apt.codegen.Serializer;
import br.com.anteros.persistence.apt.codegen.SerializerConfig;
import br.com.anteros.persistence.apt.codegen.TypeMappings;
import br.com.anteros.persistence.apt.codegen.model.ClassType;
import br.com.anteros.persistence.apt.codegen.model.Constructor;
import br.com.anteros.persistence.apt.codegen.model.Parameter;
import br.com.anteros.persistence.apt.codegen.model.Type;
import br.com.anteros.persistence.apt.codegen.model.TypeCategory;
import br.com.anteros.persistence.apt.codegen.model.TypeExtends;
import br.com.anteros.persistence.apt.codegen.model.Types;
import br.com.anteros.persistence.dsl.osql.types.ConstructorExpression;
import br.com.anteros.persistence.dsl.osql.types.Expression;
import br.com.anteros.persistence.dsl.osql.types.expr.NumberExpression;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import javax.annotation.Generated;
import javax.inject.Inject;

public final class ProjectionSerializer
implements Serializer {
    private final TypeMappings typeMappings;

    @Inject
    public ProjectionSerializer(TypeMappings typeMappings) {
        this.typeMappings = typeMappings;
    }

    protected void intro(EntityType model, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        Type queryType = this.typeMappings.getPathType(model, model, false);
        if (!queryType.getPackageName().isEmpty()) {
            writer.packageDecl(queryType.getPackageName());
        }
        writer.imports(NumberExpression.class.getPackage());
        writer.imports(Expression.class, ConstructorExpression.class, Generated.class);
        writer.javadoc(queryType + " is a Projection type for " + simpleName);
        writer.line("@Generated(\"", this.getClass().getName(), "\")");
        ClassType superType = new ClassType(TypeCategory.SIMPLE, ConstructorExpression.class, model);
        writer.beginClass(queryType, superType, new Type[0]);
        writer.privateStaticFinal(Types.LONG_P, "serialVersionUID", String.valueOf(model.hashCode()) + "L");
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.end();
    }

    @Override
    public void serialize(final EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        this.intro(model, writer);
        String localName = writer.getRawName(model);
        HashSet sizes = Sets.newHashSet();
        for (Constructor c : model.getConstructors()) {
            final boolean asExpr = sizes.add(c.getParameters().size());
            writer.beginConstructor(c.getParameters(), new Function<Parameter, Parameter>(){

                public Parameter apply(Parameter p) {
                    Type type = !asExpr ? ProjectionSerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true) : (p.getType().isFinal() ? new ClassType(Expression.class, p.getType()) : new ClassType(Expression.class, new TypeExtends(p.getType())));
                    return new Parameter(p.getName(), type);
                }
            });
            writer.beginLine("super(" + writer.getClassConstant(localName));
            writer.append(", new Class[]{");
            boolean first = true;
            for (Parameter p : c.getParameters()) {
                if (!first) {
                    writer.append(", ");
                }
                if (Types.PRIMITIVES.containsKey(p.getType())) {
                    Type primitive = Types.PRIMITIVES.get(p.getType());
                    writer.append(writer.getClassConstant(primitive.getFullName()));
                } else {
                    writer.append(writer.getClassConstant(writer.getRawName(p.getType())));
                }
                first = false;
            }
            writer.append("}");
            for (Parameter p : c.getParameters()) {
                writer.append(", " + p.getName());
            }
            writer.append(");\n");
            writer.end();
        }
        this.outro(model, writer);
    }
}

