/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.AbstractCodeWriter;
import br.com.anteros.persistence.apt.codegen.CodegenException;
import br.com.anteros.persistence.apt.codegen.StringUtils;
import br.com.anteros.persistence.apt.codegen.model.Parameter;
import br.com.anteros.persistence.apt.codegen.model.Type;
import com.google.common.base.Function;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public final class JavaWriter
extends AbstractCodeWriter<JavaWriter> {
    private static final String EXTENDS = " extends ";
    private static final String IMPLEMENTS = " implements ";
    private static final String IMPORT = "import ";
    private static final String IMPORT_STATIC = "import static ";
    private static final String PACKAGE = "package ";
    private static final String PRIVATE = "private ";
    private static final String PRIVATE_FINAL = "private final ";
    private static final String PRIVATE_STATIC_FINAL = "private static final ";
    private static final String PROTECTED = "protected ";
    private static final String PROTECTED_FINAL = "protected final ";
    private static final String PUBLIC = "public ";
    private static final String PUBLIC_CLASS = "public class ";
    private static final String PUBLIC_FINAL = "public final ";
    private static final String PUBLIC_INTERFACE = "public interface ";
    private static final String PUBLIC_STATIC = "public static ";
    private static final String PUBLIC_STATIC_FINAL = "public static final ";
    private final Set<String> classes = new HashSet<String>();
    private final Set<String> packages = new HashSet<String>();
    private final Stack<Type> types = new Stack();

    public JavaWriter(Appendable appendable) {
        super(appendable, 4);
        this.packages.add("java.lang");
    }

    @Override
    public JavaWriter annotation(Annotation annotation) throws IOException {
        ((JavaWriter)((JavaWriter)this.beginLine(new String[0])).append("@")).appendType(annotation.annotationType());
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        if (methods.length == 1 && methods[0].getName().equals("value")) {
            try {
                Object value = methods[0].invoke((Object)annotation, new Object[0]);
                this.append("(");
                this.annotationConstant(value);
                this.append(")");
            }
            catch (IllegalArgumentException e) {
                throw new CodegenException(e);
            }
            catch (IllegalAccessException e) {
                throw new CodegenException(e);
            }
            catch (InvocationTargetException e) {
                throw new CodegenException(e);
            }
        }
        boolean first = true;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                Method method = methodArray[n2];
                try {
                    Object value = method.invoke((Object)annotation, new Object[0]);
                    if (value == null || value.equals(method.getDefaultValue()) || value.getClass().isArray() && Arrays.equals((Object[])value, (Object[])method.getDefaultValue())) break block13;
                    if (!first) {
                        this.append(", ");
                    } else {
                        this.append("(");
                    }
                    this.append(String.valueOf(method.getName()) + "=");
                    this.annotationConstant(value);
                }
                catch (IllegalArgumentException e) {
                    throw new CodegenException(e);
                }
                catch (IllegalAccessException e) {
                    throw new CodegenException(e);
                }
                catch (InvocationTargetException e) {
                    throw new CodegenException(e);
                }
                first = false;
            }
            ++n2;
        }
        if (!first) {
            this.append(")");
        }
        return (JavaWriter)this.nl();
    }

    @Override
    public JavaWriter annotation(Class<? extends Annotation> annotation) throws IOException {
        return (JavaWriter)((JavaWriter)((JavaWriter)this.beginLine(new String[0])).append("@")).appendType(annotation).nl();
    }

    private void annotationConstant(Object value) throws IOException {
        if (value.getClass().isArray()) {
            this.append("{");
            boolean first = true;
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (!first) {
                    this.append(", ");
                }
                this.annotationConstant(o);
                first = false;
                ++n2;
            }
            this.append("}");
        } else if (value instanceof Class) {
            this.appendType((Class)value).append(".class");
        } else if (value instanceof Number || value instanceof Boolean) {
            this.append(value.toString());
        } else if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            if (this.classes.contains(enumValue.getClass().getName()) || this.packages.contains(enumValue.getClass().getPackage().getName())) {
                this.append(enumValue.name());
            } else {
                this.append(String.valueOf(enumValue.getDeclaringClass().getName()) + "." + enumValue.name());
            }
        } else if (value instanceof String) {
            String escaped = StringUtils.escapeJava(value.toString());
            this.append("\"" + escaped.replace("\\/", "/") + "\"");
        } else {
            throw new IllegalArgumentException("Unsupported annotation value : " + value);
        }
    }

    private JavaWriter appendType(Class<?> type) throws IOException {
        if (this.classes.contains(type.getName()) || this.packages.contains(type.getPackage().getName())) {
            this.append(type.getSimpleName());
        } else {
            this.append(type.getName());
        }
        return this;
    }

    @Override
    public JavaWriter beginClass(Type type) throws IOException {
        return this.beginClass(type, null, new Type[0]);
    }

    @Override
    public JavaWriter beginClass(Type type, Type superClass, Type ... interfaces) throws IOException {
        this.packages.add(type.getPackageName());
        this.beginLine(PUBLIC_CLASS + type.getGenericName(false, this.packages, this.classes));
        if (superClass != null) {
            this.append(EXTENDS + superClass.getGenericName(false, this.packages, this.classes));
        }
        if (interfaces.length > 0) {
            this.append(IMPLEMENTS);
            int i = 0;
            while (i < interfaces.length) {
                if (i > 0) {
                    this.append(", ");
                }
                this.append(interfaces[i].getGenericName(false, this.packages, this.classes));
                ++i;
            }
        }
        ((JavaWriter)((JavaWriter)this.append(" {")).nl()).nl();
        this.goIn();
        this.types.push(type);
        return this;
    }

    @Override
    public <T> JavaWriter beginConstructor(Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        this.types.push(this.types.peek());
        ((JavaWriter)((JavaWriter)this.beginLine(PUBLIC + this.types.peek().getSimpleName())).params(parameters, transformer).append(" {")).nl();
        return (JavaWriter)this.goIn();
    }

    @Override
    public JavaWriter beginConstructor(Parameter ... parameters) throws IOException {
        this.types.push(this.types.peek());
        ((JavaWriter)((JavaWriter)this.beginLine(PUBLIC + this.types.peek().getSimpleName())).params(parameters).append(" {")).nl();
        return (JavaWriter)this.goIn();
    }

    @Override
    public JavaWriter beginInterface(Type type, Type ... interfaces) throws IOException {
        this.packages.add(type.getPackageName());
        this.beginLine(PUBLIC_INTERFACE + type.getGenericName(false, this.packages, this.classes));
        if (interfaces.length > 0) {
            this.append(EXTENDS);
            int i = 0;
            while (i < interfaces.length) {
                if (i > 0) {
                    this.append(", ");
                }
                this.append(interfaces[i].getGenericName(false, this.packages, this.classes));
                ++i;
            }
        }
        ((JavaWriter)((JavaWriter)this.append(" {")).nl()).nl();
        this.goIn();
        this.types.push(type);
        return this;
    }

    private JavaWriter beginMethod(String modifiers, Type returnType, String methodName, Parameter ... args) throws IOException {
        this.types.push(this.types.peek());
        ((JavaWriter)((JavaWriter)this.beginLine(String.valueOf(modifiers) + returnType.getGenericName(true, this.packages, this.classes) + " " + methodName)).params(args).append(" {")).nl();
        return (JavaWriter)this.goIn();
    }

    @Override
    public <T> JavaWriter beginPublicMethod(Type returnType, String methodName, Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        return this.beginMethod(PUBLIC, returnType, methodName, this.transform(parameters, transformer));
    }

    @Override
    public JavaWriter beginPublicMethod(Type returnType, String methodName, Parameter ... args) throws IOException {
        return this.beginMethod(PUBLIC, returnType, methodName, args);
    }

    @Override
    public <T> JavaWriter beginStaticMethod(Type returnType, String methodName, Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        return this.beginMethod(PUBLIC_STATIC, returnType, methodName, this.transform(parameters, transformer));
    }

    @Override
    public JavaWriter beginStaticMethod(Type returnType, String methodName, Parameter ... args) throws IOException {
        return this.beginMethod(PUBLIC_STATIC, returnType, methodName, args);
    }

    @Override
    public JavaWriter end() throws IOException {
        this.types.pop();
        this.goOut();
        return (JavaWriter)((JavaWriter)this.line("}")).nl();
    }

    @Override
    public JavaWriter field(Type type, String name) throws IOException {
        return (JavaWriter)((JavaWriter)this.line(String.valueOf(type.getGenericName(true, this.packages, this.classes)) + " " + name + ";")).nl();
    }

    private JavaWriter field(String modifier, Type type, String name) throws IOException {
        return (JavaWriter)((JavaWriter)this.line(String.valueOf(modifier) + type.getGenericName(true, this.packages, this.classes) + " " + name + ";")).nl();
    }

    private JavaWriter field(String modifier, Type type, String name, String value) throws IOException {
        return (JavaWriter)((JavaWriter)this.line(String.valueOf(modifier) + type.getGenericName(true, this.packages, this.classes) + " " + name + " = " + value + ";")).nl();
    }

    @Override
    public String getClassConstant(String className) {
        return String.valueOf(className) + ".class";
    }

    @Override
    public String getGenericName(boolean asArgType, Type type) {
        return type.getGenericName(asArgType, this.packages, this.classes);
    }

    @Override
    public String getRawName(Type type) {
        return type.getRawName(this.packages, this.classes);
    }

    @Override
    public JavaWriter imports(Class<?> ... imports) throws IOException {
        Class<?>[] classArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            this.classes.add(cl.getName());
            this.line(IMPORT + cl.getName() + ";");
            ++n2;
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter imports(Package ... imports) throws IOException {
        Package[] packageArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            Package p = packageArray[n2];
            this.packages.add(p.getName());
            this.line(IMPORT + p.getName() + ".*;");
            ++n2;
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter importClasses(String ... imports) throws IOException {
        String[] stringArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            String cl = stringArray[n2];
            this.classes.add(cl);
            this.line(IMPORT + cl + ";");
            ++n2;
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter importPackages(String ... imports) throws IOException {
        String[] stringArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            this.packages.add(p);
            this.line(IMPORT + p + ".*;");
            ++n2;
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter javadoc(String ... lines) throws IOException {
        this.line("/**");
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.line(" * " + line);
            ++n2;
        }
        return (JavaWriter)this.line(" */");
    }

    @Override
    public JavaWriter packageDecl(String packageName) throws IOException {
        this.packages.add(packageName);
        return (JavaWriter)((JavaWriter)this.line(PACKAGE + packageName + ";")).nl();
    }

    private <T> JavaWriter params(Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        this.append("(");
        boolean first = true;
        for (T param : parameters) {
            if (!first) {
                this.append(", ");
            }
            this.param((Parameter)transformer.apply(param));
            first = false;
        }
        this.append(")");
        return this;
    }

    private JavaWriter params(Parameter ... params) throws IOException {
        this.append("(");
        int i = 0;
        while (i < params.length) {
            if (i > 0) {
                this.append(", ");
            }
            this.param(params[i]);
            ++i;
        }
        this.append(")");
        return this;
    }

    private JavaWriter param(Parameter parameter) throws IOException {
        this.append(parameter.getType().getGenericName(true, this.packages, this.classes));
        this.append(" ");
        this.append(parameter.getName());
        return this;
    }

    @Override
    public JavaWriter privateField(Type type, String name) throws IOException {
        return this.field(PRIVATE, type, name);
    }

    @Override
    public JavaWriter privateFinal(Type type, String name) throws IOException {
        return this.field(PRIVATE_FINAL, type, name);
    }

    @Override
    public JavaWriter privateFinal(Type type, String name, String value) throws IOException {
        return this.field(PRIVATE_FINAL, type, name, value);
    }

    @Override
    public JavaWriter privateStaticFinal(Type type, String name, String value) throws IOException {
        return this.field(PRIVATE_STATIC_FINAL, type, name, value);
    }

    @Override
    public JavaWriter protectedField(Type type, String name) throws IOException {
        return this.field(PROTECTED, type, name);
    }

    @Override
    public JavaWriter protectedFinal(Type type, String name) throws IOException {
        return this.field(PROTECTED_FINAL, type, name);
    }

    @Override
    public JavaWriter protectedFinal(Type type, String name, String value) throws IOException {
        return this.field(PROTECTED_FINAL, type, name, value);
    }

    @Override
    public JavaWriter publicField(Type type, String name) throws IOException {
        return this.field(PUBLIC, type, name);
    }

    @Override
    public JavaWriter publicField(Type type, String name, String value) throws IOException {
        return this.field(PUBLIC, type, name, value);
    }

    @Override
    public JavaWriter publicFinal(Type type, String name) throws IOException {
        return this.field(PUBLIC_FINAL, type, name);
    }

    @Override
    public JavaWriter publicFinal(Type type, String name, String value) throws IOException {
        return this.field(PUBLIC_FINAL, type, name, value);
    }

    @Override
    public JavaWriter publicStaticFinal(Type type, String name, String value) throws IOException {
        return this.field(PUBLIC_STATIC_FINAL, type, name, value);
    }

    @Override
    public JavaWriter staticimports(Class<?> ... imports) throws IOException {
        Class<?>[] classArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            this.line(IMPORT_STATIC + cl.getName() + ".*;");
            ++n2;
        }
        return this;
    }

    @Override
    public JavaWriter suppressWarnings(String type) throws IOException {
        return (JavaWriter)this.line("@SuppressWarnings(\"" + type + "\")");
    }

    private <T> Parameter[] transform(Collection<T> parameters, Function<T, Parameter> transformer) {
        Parameter[] rv = new Parameter[parameters.size()];
        int i = 0;
        for (T value : parameters) {
            rv[i++] = (Parameter)transformer.apply(value);
        }
        return rv;
    }
}

