/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.AbstractCodeWriter;
import br.com.anteros.persistence.apt.codegen.CodegenModule;
import br.com.anteros.persistence.apt.codegen.EmbeddableSerializer;
import br.com.anteros.persistence.apt.codegen.EntitySerializer;
import br.com.anteros.persistence.apt.codegen.EntityType;
import br.com.anteros.persistence.apt.codegen.JavaWriter;
import br.com.anteros.persistence.apt.codegen.ProjectionSerializer;
import br.com.anteros.persistence.apt.codegen.Property;
import br.com.anteros.persistence.apt.codegen.QueryTypeFactory;
import br.com.anteros.persistence.apt.codegen.ScalaWriter;
import br.com.anteros.persistence.apt.codegen.Serializer;
import br.com.anteros.persistence.apt.codegen.SerializerConfig;
import br.com.anteros.persistence.apt.codegen.SimpleSerializerConfig;
import br.com.anteros.persistence.apt.codegen.Supertype;
import br.com.anteros.persistence.apt.codegen.SupertypeSerializer;
import br.com.anteros.persistence.apt.codegen.TypeFactory;
import br.com.anteros.persistence.apt.codegen.TypeMappings;
import br.com.anteros.persistence.apt.codegen.model.Constructor;
import br.com.anteros.persistence.apt.codegen.model.Parameter;
import br.com.anteros.persistence.apt.codegen.model.Type;
import br.com.anteros.persistence.apt.codegen.model.TypeCategory;
import br.com.anteros.persistence.apt.codegen.support.ClassUtils;
import br.com.anteros.persistence.dsl.osql.QueryException;
import br.com.anteros.persistence.dsl.osql.annotations.Config;
import br.com.anteros.persistence.dsl.osql.annotations.PropertyType;
import br.com.anteros.persistence.dsl.osql.annotations.QueryEmbeddable;
import br.com.anteros.persistence.dsl.osql.annotations.QueryEmbedded;
import br.com.anteros.persistence.dsl.osql.annotations.QueryEntity;
import br.com.anteros.persistence.dsl.osql.annotations.QueryExclude;
import br.com.anteros.persistence.dsl.osql.annotations.QueryInit;
import br.com.anteros.persistence.dsl.osql.annotations.QueryProjection;
import br.com.anteros.persistence.dsl.osql.annotations.QuerySupertype;
import br.com.anteros.persistence.dsl.osql.annotations.QueryTransient;
import br.com.anteros.persistence.dsl.osql.annotations.QueryType;
import br.com.anteros.persistence.dsl.osql.util.BeanUtils;
import br.com.anteros.persistence.dsl.osql.util.ClassPathUtils;
import br.com.anteros.persistence.dsl.osql.util.ReflectionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericExporter {
    private Class<? extends Annotation> entityAnnotation = QueryEntity.class;
    private Class<? extends Annotation> supertypeAnnotation = QuerySupertype.class;
    private Class<? extends Annotation> embeddableAnnotation = QueryEmbeddable.class;
    private Class<? extends Annotation> embeddedAnnotation = QueryEmbedded.class;
    private Class<? extends Annotation> skipAnnotation = QueryTransient.class;
    private boolean createScalaSources = false;
    private final Set<Class<?>> stopClasses = Sets.newHashSet();
    private final Map<String, EntityType> allTypes = Maps.newHashMap();
    private final Map<Class<?>, EntityType> entityTypes = Maps.newHashMap();
    private final Map<Class<?>, EntityType> superTypes = Maps.newHashMap();
    private final Map<Class<?>, EntityType> embeddableTypes = Maps.newHashMap();
    private final Map<Class<?>, EntityType> projectionTypes = Maps.newHashMap();
    private final CodegenModule codegenModule = new CodegenModule();
    private final SerializerConfig serializerConfig = SimpleSerializerConfig.DEFAULT;
    private boolean handleFields = true;
    private boolean handleMethods = true;
    private File targetFolder;
    private TypeFactory typeFactory;
    private TypeMappings typeMappings;
    private QueryTypeFactory queryTypeFactory;
    private Class<? extends Serializer> serializerClass;
    private final Charset charset;
    private final ClassLoader classLoader;
    private Set<File> generatedFiles = new HashSet<File>();

    public GenericExporter(ClassLoader classLoader, Charset charset) {
        this.classLoader = classLoader;
        this.charset = charset;
        this.stopClasses.add(Object.class);
        this.stopClasses.add(Enum.class);
    }

    public GenericExporter(ClassLoader classLoader) {
        this(classLoader, Charset.defaultCharset());
    }

    public GenericExporter(Charset charset) {
        this(Thread.currentThread().getContextClassLoader(), charset);
    }

    public GenericExporter() {
        this(Thread.currentThread().getContextClassLoader(), Charset.defaultCharset());
    }

    public void export(Package ... packages) {
        String[] pkgs = new String[packages.length];
        int i = 0;
        while (i < packages.length) {
            pkgs[i] = packages[i].getName();
            ++i;
        }
        this.export(pkgs);
    }

    public void export(String ... packages) {
        this.scanPackages(packages);
        this.innerExport();
    }

    public void export(Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            this.handleClass(cl);
            ++n2;
        }
        this.innerExport();
    }

    private void innerExport() {
        this.typeMappings = this.codegenModule.get(TypeMappings.class);
        this.queryTypeFactory = this.codegenModule.get(QueryTypeFactory.class);
        this.typeFactory = new TypeFactory((List<Class<? extends Annotation>>)ImmutableList.of(this.entityAnnotation, this.supertypeAnnotation, this.embeddableAnnotation));
        for (Class<?> cl : this.superTypes.keySet()) {
            this.createEntityType(cl, this.superTypes);
        }
        for (Class<?> cl : this.embeddableTypes.keySet()) {
            this.createEntityType(cl, this.embeddableTypes);
        }
        for (Class<?> cl : this.entityTypes.keySet()) {
            this.createEntityType(cl, this.entityTypes);
        }
        for (Class<?> cl : this.projectionTypes.keySet()) {
            this.createEntityType(cl, this.projectionTypes);
        }
        for (Map entries : Arrays.asList(this.superTypes, this.embeddableTypes, this.entityTypes, this.projectionTypes)) {
            for (Iterator<EntityType> entry : Sets.newHashSet(entries.entrySet())) {
                this.addConstructors((Class)entry.getKey(), (EntityType)entry.getValue());
                this.addProperties((Class)entry.getKey(), (EntityType)entry.getValue());
            }
        }
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType type : this.superTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.entityTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.embeddableTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        this.typeFactory.extendTypes();
        try {
            Serializer projectionSerializer;
            Serializer embeddableSerializer;
            Serializer entitySerializer;
            Serializer supertypeSerializer;
            if (this.serializerClass != null) {
                Serializer serializer;
                supertypeSerializer = serializer = this.codegenModule.get(this.serializerClass);
                entitySerializer = serializer;
                embeddableSerializer = serializer;
                projectionSerializer = serializer;
            } else {
                supertypeSerializer = this.codegenModule.get(SupertypeSerializer.class);
                entitySerializer = this.codegenModule.get(EntitySerializer.class);
                embeddableSerializer = this.codegenModule.get(EmbeddableSerializer.class);
                projectionSerializer = this.codegenModule.get(ProjectionSerializer.class);
            }
            this.serialize(supertypeSerializer, this.superTypes);
            this.serialize(entitySerializer, this.entityTypes);
            this.serialize(embeddableSerializer, this.embeddableTypes);
            this.serialize(projectionSerializer, this.projectionTypes);
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
    }

    private void addSupertypeFields(EntityType model, Map<String, EntityType> superTypes, Set<EntityType> handled) {
        if (handled.add(model)) {
            for (Supertype supertype : model.getSuperTypes()) {
                EntityType entityType = superTypes.get(supertype.getType().getFullName());
                if (entityType == null) {
                    if (supertype.getType().getPackageName().startsWith("java.")) continue;
                    Class<?> cl = supertype.getType().getJavaClass();
                    this.typeFactory.addEmbeddableType(cl);
                    entityType = this.createEntityType(cl, new HashMap());
                    this.addProperties(cl, entityType);
                }
                this.addSupertypeFields(entityType, superTypes, handled);
                supertype.setEntityType(entityType);
                model.include(supertype);
            }
        }
    }

    private EntityType createEntityType(Class<?> cl, Map<Class<?>, EntityType> types) {
        if (types.get(cl) != null) {
            return types.get(cl);
        }
        EntityType type = this.allTypes.get(ClassUtils.getFullName(cl));
        if (type == null) {
            type = this.typeFactory.getEntityType(cl);
        }
        types.put(cl, type);
        String fullName = ClassUtils.getFullName(cl);
        if (!this.allTypes.containsKey(fullName)) {
            this.allTypes.put(fullName, type);
        }
        this.typeMappings.register(type, this.queryTypeFactory.create(type));
        if (cl.getSuperclass() != null && !this.stopClasses.contains(cl.getSuperclass()) && !cl.getSuperclass().isAnnotationPresent(QueryExclude.class)) {
            type.addSupertype(new Supertype(this.typeFactory.get(cl.getSuperclass(), cl.getGenericSuperclass())));
        }
        if (cl.isInterface()) {
            Class<?>[] classArray = cl.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                if (!this.stopClasses.contains(iface) && !iface.isAnnotationPresent(QueryExclude.class)) {
                    type.addSupertype(new Supertype(this.typeFactory.get(iface)));
                }
                ++n2;
            }
        }
        return type;
    }

    private void addConstructors(Class<?> cl, EntityType type) {
        java.lang.reflect.Constructor<?>[] constructorArray = cl.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.reflect.Constructor<?> constructor = constructorArray[n2];
            if (constructor.getAnnotation(QueryProjection.class) != null) {
                ArrayList parameters = Lists.newArrayList();
                int i = 0;
                while (i < constructor.getParameterTypes().length) {
                    Type parameterType = this.typeFactory.get(constructor.getParameterTypes()[i], constructor.getGenericParameterTypes()[i]);
                    Annotation[] annotationArray = constructor.getParameterAnnotations()[i];
                    int n3 = annotationArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation annotation = annotationArray[n4];
                        if (annotation.annotationType().equals(QueryType.class)) {
                            QueryType queryType = (QueryType)annotation;
                            parameterType = parameterType.as(TypeCategory.valueOf(queryType.value().name()));
                        }
                        ++n4;
                    }
                    parameters.add(new Parameter("param" + i, parameterType));
                    ++i;
                }
                type.addConstructor(new Constructor(parameters));
            }
            ++n2;
        }
    }

    private void addProperties(Class<?> cl, EntityType type) {
        Property property;
        Type propertyType;
        int n;
        int n2;
        AccessibleObject[] accessibleObjectArray;
        HashSet<String> handled = new HashSet<String>();
        if (this.handleFields) {
            accessibleObjectArray = cl.getDeclaredFields();
            n2 = accessibleObjectArray.length;
            n = 0;
            while (n < n2) {
                AccessibleObject field = accessibleObjectArray[n];
                if (!(Modifier.isStatic(((Field)field).getModifiers()) || Modifier.isTransient(((Field)field).getModifiers()) && !field.isAnnotationPresent(QueryType.class))) {
                    AnnotatedElement annotated = ReflectionUtils.getAnnotatedElement(cl, (String)((Field)field).getName(), ((Field)field).getType());
                    Method method = ReflectionUtils.getGetterOrNull(cl, (String)((Field)field).getName(), ((Field)field).getType());
                    propertyType = null;
                    propertyType = method != null ? this.getPropertyType(cl, annotated, method.getReturnType(), method.getGenericReturnType()) : this.getPropertyType(cl, annotated, ((Field)field).getType(), ((Field)field).getGenericType());
                    property = this.createProperty(type, ((Field)field).getName(), propertyType, field);
                    if (property != null) {
                        type.addProperty(property);
                    }
                    handled.add(((Field)field).getName());
                }
                ++n;
            }
        }
        if (this.handleMethods) {
            accessibleObjectArray = cl.getDeclaredMethods();
            n2 = accessibleObjectArray.length;
            n = 0;
            while (n < n2) {
                String propertyName;
                AccessibleObject method = accessibleObjectArray[n];
                String name = ((Method)method).getName();
                if (((Method)method).getParameterTypes().length == 0 && (name.startsWith("get") && name.length() > 3 || name.startsWith("is") && name.length() > 2) && !handled.contains(propertyName = name.startsWith("get") ? BeanUtils.uncapitalize((String)name.substring(3)) : BeanUtils.uncapitalize((String)name.substring(2))) && (property = this.createProperty(type, propertyName, propertyType = this.getPropertyType(cl, method, ((Method)method).getReturnType(), ((Method)method).getGenericReturnType()), method)) != null) {
                    type.addProperty(property);
                }
                ++n;
            }
        }
    }

    private Type getPropertyType(Class<?> cl, AnnotatedElement annotated, Class<?> type, java.lang.reflect.Type genericType) {
        String fullName;
        Type propertyType = null;
        if (annotated.isAnnotationPresent(this.embeddedAnnotation)) {
            Class embeddableType = type;
            if (Collection.class.isAssignableFrom(type)) {
                embeddableType = ReflectionUtils.getTypeParameterAsClass((java.lang.reflect.Type)genericType, (int)0);
            } else if (Map.class.isAssignableFrom(type)) {
                embeddableType = ReflectionUtils.getTypeParameterAsClass((java.lang.reflect.Type)genericType, (int)1);
            }
            if (!embeddableType.getName().startsWith("java.")) {
                this.typeFactory.addEmbeddableType(embeddableType);
                if (!(this.embeddableTypes.containsKey(embeddableType) || this.entityTypes.containsKey(embeddableType) || this.superTypes.containsKey(embeddableType))) {
                    EntityType entityType = this.createEntityType(embeddableType, this.embeddableTypes);
                    this.addProperties(embeddableType, entityType);
                    if (embeddableType == type) {
                        propertyType = entityType;
                    }
                }
            }
        }
        if (propertyType == null && (propertyType = this.typeFactory.get(type, genericType)) instanceof EntityType && !this.allTypes.containsKey(ClassUtils.getFullName(type)) && !this.allTypes.containsKey(fullName = ClassUtils.getFullName(type))) {
            this.allTypes.put(fullName, (EntityType)propertyType);
        }
        return propertyType;
    }

    private Property createProperty(EntityType entityType, String propertyName, Type propertyType, AnnotatedElement annotated) {
        ImmutableList inits = Collections.emptyList();
        if (annotated.isAnnotationPresent(this.skipAnnotation) && !annotated.isAnnotationPresent(QueryType.class)) {
            return null;
        }
        if (annotated.isAnnotationPresent(QueryInit.class)) {
            inits = ImmutableList.copyOf((Object[])annotated.getAnnotation(QueryInit.class).value());
        }
        if (annotated.isAnnotationPresent(QueryType.class)) {
            QueryType queryType = annotated.getAnnotation(QueryType.class);
            if (queryType.value().equals((Object)PropertyType.NONE)) {
                return null;
            }
            propertyType = propertyType.as(TypeCategory.valueOf(queryType.value().name()));
        }
        return new Property(entityType, propertyName, propertyType, (List<String>)inits);
    }

    private void scanPackages(String ... packages) {
        if (packages == null) {
            return;
        }
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            try {
                for (Class cl : ClassPathUtils.scanPackage((ClassLoader)this.classLoader, (String)pkg)) {
                    this.handleClass(cl);
                }
            }
            catch (IOException e) {
                throw new QueryException((Throwable)e);
            }
            ++n2;
        }
    }

    private void handleClass(Class<?> cl) {
        if (this.stopClasses.contains(cl) || cl.isAnnotationPresent(QueryExclude.class)) {
            return;
        }
        if (cl.getAnnotation(this.entityAnnotation) != null) {
            this.entityTypes.put(cl, null);
        } else if (cl.getAnnotation(this.embeddableAnnotation) != null) {
            this.embeddableTypes.put(cl, null);
        } else if (cl.getAnnotation(this.supertypeAnnotation) != null) {
            this.superTypes.put(cl, null);
        } else {
            java.lang.reflect.Constructor<?>[] constructorArray = cl.getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                java.lang.reflect.Constructor<?> constructor = constructorArray[n2];
                if (constructor.getAnnotation(QueryProjection.class) != null) {
                    this.projectionTypes.put(cl, null);
                    break;
                }
                ++n2;
            }
        }
    }

    private void serialize(Serializer serializer, Map<Class<?>, EntityType> types) throws IOException {
        for (Map.Entry<Class<?>, EntityType> entityType : types.entrySet()) {
            Type type = this.typeMappings.getPathType(entityType.getValue(), entityType.getValue(), true);
            String packageName = type.getPackageName();
            String className = packageName.length() > 0 ? String.valueOf(packageName) + "." + type.getSimpleName() : type.getSimpleName();
            SerializerConfig config = this.serializerConfig;
            if (entityType.getKey().isAnnotationPresent(Config.class)) {
                config = SimpleSerializerConfig.getConfig(entityType.getKey().getAnnotation(Config.class));
            }
            String fileSuffix = this.createScalaSources ? ".scala" : ".java";
            this.write(serializer, String.valueOf(className.replace('.', '/')) + fileSuffix, config, entityType.getValue());
        }
    }

    private void write(Serializer serializer, String path, SerializerConfig serializerConfig, EntityType type) throws IOException {
        File targetFile = new File(this.targetFolder, path);
        this.generatedFiles.add(targetFile);
        Writer w = this.writerFor(targetFile);
        try {
            AbstractCodeWriter writer = this.createScalaSources ? new ScalaWriter(w) : new JavaWriter(w);
            serializer.serialize(type, serializerConfig, writer);
        }
        finally {
            w.close();
        }
    }

    private Writer writerFor(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            System.err.println("Folder " + file.getParent() + " could not be created");
        }
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Set<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public void setEntityAnnotation(Class<? extends Annotation> entityAnnotation) {
        this.entityAnnotation = entityAnnotation;
    }

    public void setSupertypeAnnotation(Class<? extends Annotation> supertypeAnnotation) {
        this.supertypeAnnotation = supertypeAnnotation;
    }

    public void setEmbeddableAnnotation(Class<? extends Annotation> embeddableAnnotation) {
        this.embeddableAnnotation = embeddableAnnotation;
    }

    public void setEmbeddedAnnotation(Class<? extends Annotation> embeddedAnnotation) {
        this.embeddedAnnotation = embeddedAnnotation;
    }

    public void setSkipAnnotation(Class<? extends Annotation> skipAnnotation) {
        this.skipAnnotation = skipAnnotation;
    }

    public void setTargetFolder(File targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setSerializerClass(Class<? extends Serializer> serializerClass) {
        this.codegenModule.bind(serializerClass);
        this.serializerClass = serializerClass;
    }

    public void setTypeMappingsClass(Class<? extends TypeMappings> typeMappingsClass) {
        this.codegenModule.bind(TypeMappings.class, typeMappingsClass);
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setKeywords(Collection<String> keywords) {
        this.codegenModule.bind("keywords", keywords);
    }

    public void setNamePrefix(String prefix) {
        this.codegenModule.bind("prefix", prefix);
    }

    public void setNameSuffix(String suffix) {
        this.codegenModule.bind("suffix", suffix);
    }

    public void setPackageSuffix(String suffix) {
        this.codegenModule.bind("packageSuffix", suffix);
    }

    public void setHandleFields(boolean b) {
        this.handleFields = b;
    }

    public void setHandleMethods(boolean b) {
        this.handleMethods = b;
    }

    public void addStopClass(Class<?> cl) {
        this.stopClasses.add(cl);
    }
}

