/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.CodeWriter;
import br.com.anteros.persistence.apt.codegen.Delegate;
import br.com.anteros.persistence.apt.codegen.EntityType;
import br.com.anteros.persistence.apt.codegen.Property;
import br.com.anteros.persistence.apt.codegen.Serializer;
import br.com.anteros.persistence.apt.codegen.SerializerConfig;
import br.com.anteros.persistence.apt.codegen.Supertype;
import br.com.anteros.persistence.apt.codegen.TypeMappings;
import br.com.anteros.persistence.apt.codegen.model.ClassType;
import br.com.anteros.persistence.apt.codegen.model.Constructor;
import br.com.anteros.persistence.apt.codegen.model.IndexClassType;
import br.com.anteros.persistence.apt.codegen.model.Parameter;
import br.com.anteros.persistence.apt.codegen.model.SimpleType;
import br.com.anteros.persistence.apt.codegen.model.Type;
import br.com.anteros.persistence.apt.codegen.model.TypeCategory;
import br.com.anteros.persistence.apt.codegen.model.TypeExtends;
import br.com.anteros.persistence.apt.codegen.model.Types;
import br.com.anteros.persistence.dsl.osql.types.ConstructorExpression;
import br.com.anteros.persistence.dsl.osql.types.Expression;
import br.com.anteros.persistence.dsl.osql.types.Path;
import br.com.anteros.persistence.dsl.osql.types.PathMetadata;
import br.com.anteros.persistence.dsl.osql.types.PathMetadataFactory;
import br.com.anteros.persistence.dsl.osql.types.expr.ComparableExpression;
import br.com.anteros.persistence.dsl.osql.types.expr.SimpleExpression;
import br.com.anteros.persistence.dsl.osql.types.path.ArrayPath;
import br.com.anteros.persistence.dsl.osql.types.path.BooleanPath;
import br.com.anteros.persistence.dsl.osql.types.path.CollectionPath;
import br.com.anteros.persistence.dsl.osql.types.path.ComparablePath;
import br.com.anteros.persistence.dsl.osql.types.path.DatePath;
import br.com.anteros.persistence.dsl.osql.types.path.DateTimePath;
import br.com.anteros.persistence.dsl.osql.types.path.EntityPathBase;
import br.com.anteros.persistence.dsl.osql.types.path.EnumPath;
import br.com.anteros.persistence.dsl.osql.types.path.ListPath;
import br.com.anteros.persistence.dsl.osql.types.path.MapPath;
import br.com.anteros.persistence.dsl.osql.types.path.NumberPath;
import br.com.anteros.persistence.dsl.osql.types.path.PathInits;
import br.com.anteros.persistence.dsl.osql.types.path.SetPath;
import br.com.anteros.persistence.dsl.osql.types.path.SimplePath;
import br.com.anteros.persistence.dsl.osql.types.path.StringPath;
import br.com.anteros.persistence.dsl.osql.types.path.TimePath;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Generated;
import javax.inject.Inject;
import javax.inject.Named;

public class EntitySerializer
implements Serializer {
    private static final Joiner JOINER = Joiner.on((String)"\", \"");
    private static final Parameter PATH_METADATA = new Parameter("metadata", new ClassType(PathMetadata.class, new Type[]{null}));
    private static final Parameter PATH_INITS = new Parameter("inits", new ClassType(PathInits.class, new Type[0]));
    private static final ClassType PATH_INITS_TYPE = new ClassType(PathInits.class, new Type[0]);
    protected final TypeMappings typeMappings;
    protected final Collection<String> keywords;

    @Inject
    public EntitySerializer(TypeMappings mappings, @Named(value="keywords") Collection<String> keywords) {
        this.typeMappings = mappings;
        this.keywords = keywords;
    }

    protected void constructors(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        ClassType type;
        String localName = writer.getRawName(model);
        String genericName = writer.getGenericName(true, model);
        boolean hasEntityFields = model.hasEntityFields();
        boolean stringOrBoolean = model.getOriginalCategory() == TypeCategory.STRING || model.getOriginalCategory() == TypeCategory.BOOLEAN;
        String thisOrSuper = hasEntityFields ? "this" : "super";
        String additionalParams = this.getAdditionalConstructorParameter(model);
        String classCast = localName.equals(genericName) ? "" : "(Class)";
        this.constructorsForVariables(writer, model, config);
        if (!localName.equals(genericName)) {
            writer.suppressWarnings("all");
        }
        SimpleType simpleModel = new SimpleType((Type)model, new Type[0]);
        if (model.isFinal()) {
            type = new ClassType(Path.class, simpleModel);
            writer.beginConstructor(new Parameter("path", type));
        } else {
            type = new ClassType(Path.class, new TypeExtends(simpleModel));
            writer.beginConstructor(new Parameter("path", type));
        }
        if (!hasEntityFields) {
            if (stringOrBoolean) {
                writer.line("super(path.getMetadata());");
            } else {
                writer.line("super(", classCast, "path.getType(), path.getMetadata()" + additionalParams + ");");
            }
            this.initIndexFields(writer, config, model);
            this.constructorContent(writer, model);
        } else {
            writer.line("this(", classCast, "path.getType(), path.getMetadata(), path.getMetadata().isRoot() ? INITS : PathInits.DEFAULT);");
        }
        writer.end();
        if (hasEntityFields) {
            writer.beginConstructor(PATH_METADATA);
            writer.line("this(metadata, metadata.isRoot() ? INITS : PathInits.DEFAULT);");
            writer.end();
        } else {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("all");
            }
            writer.beginConstructor(PATH_METADATA);
            if (stringOrBoolean) {
                writer.line("super(metadata);");
            } else {
                writer.line("super(", classCast, String.valueOf(writer.getClassConstant(localName)) + ", " + "metadata" + additionalParams + ");");
            }
            this.initIndexFields(writer, config, model);
            this.constructorContent(writer, model);
            writer.end();
        }
        if (hasEntityFields) {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("all");
            }
            writer.beginConstructor(PATH_METADATA, PATH_INITS);
            writer.line(thisOrSuper, "(", classCast, String.valueOf(writer.getClassConstant(localName)) + ", " + "metadata, inits" + additionalParams + ");");
            if (!hasEntityFields) {
                this.initIndexFields(writer, config, model);
                this.constructorContent(writer, model);
            }
            writer.end();
        }
        if (hasEntityFields) {
            type = new ClassType(Class.class, new TypeExtends(model));
            writer.beginConstructor(new Parameter("type", type), PATH_METADATA, PATH_INITS);
            writer.line("super(type, metadata, inits" + additionalParams + ");");
            this.initEntityFields(writer, config, model);
            this.initIndexFields(writer, config, model);
            this.constructorContent(writer, model);
            writer.end();
        }
    }

    protected void constructorContent(CodeWriter writer, EntityType model) throws IOException {
    }

    protected String getAdditionalConstructorParameter(EntityType model) {
        return "";
    }

    protected void constructorsForVariables(CodeWriter writer, EntityType model, SerializerConfig config) throws IOException {
        String additionalParams;
        String localName = writer.getRawName(model);
        String genericName = writer.getGenericName(true, model);
        boolean stringOrBoolean = model.getOriginalCategory() == TypeCategory.STRING || model.getOriginalCategory() == TypeCategory.BOOLEAN;
        boolean hasEntityFields = model.hasEntityFields();
        String thisOrSuper = hasEntityFields ? "this" : "super";
        String string = additionalParams = hasEntityFields ? "" : this.getAdditionalConstructorParameter(model);
        if (!localName.equals(genericName)) {
            writer.suppressWarnings("all");
        }
        writer.beginConstructor(new Parameter("variable", Types.STRING));
        if (stringOrBoolean) {
            writer.line(thisOrSuper, "(forVariable(variable)", additionalParams, ");");
        } else {
            writer.line(thisOrSuper, "(", localName.equals(genericName) ? "" : "(Class)", String.valueOf(writer.getClassConstant(localName)) + ", " + "forVariable(variable)", hasEntityFields ? ", INITS" : "", additionalParams, ");");
        }
        if (!hasEntityFields) {
            this.initIndexFields(writer, config, model);
            this.constructorContent(writer, model);
        }
        writer.end();
    }

    protected void entityAccessor(EntityType model, Property field, CodeWriter writer) throws IOException {
        Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
        writer.beginPublicMethod(queryType, field.getEscapedName(), new Parameter[0]);
        writer.line("if (", field.getEscapedName(), " == null) {");
        writer.line("    ", field.getEscapedName(), " = new ", writer.getRawName(queryType), "(forProperty(\"", field.getName(), "\"));");
        writer.line("}");
        writer.line("return ", field.getEscapedName(), ";");
        writer.end();
    }

    protected void entityField(EntityType model, Property field, SerializerConfig config, CodeWriter writer) throws IOException {
        Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
        if (field.isInherited()) {
            writer.line("// inherited");
        }
        if (config.useEntityAccessors()) {
            writer.protectedField(queryType, field.getEscapedName());
        } else {
            writer.publicFinal(queryType, field.getEscapedName());
        }
    }

    protected void indexField(EntityType model, Property field, SerializerConfig config, CodeWriter writer) throws IOException {
        writer.publicFinal(field.getType(), field.getEscapedName());
    }

    protected boolean hasOwnEntityProperties(EntityType model) {
        if (model.hasEntityFields()) {
            for (Property property : model.getProperties()) {
                if (property.isInherited() || property.getType().getCategory() != TypeCategory.ENTITY) continue;
                return true;
            }
        }
        return false;
    }

    protected void initEntityFields(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        Supertype superType = model.getSuperType();
        if (superType != null && superType.getEntityType() == null) {
            throw new IllegalStateException("No entity type for " + superType.getType().getFullName());
        }
        if (superType != null && superType.getEntityType().hasEntityFields()) {
            Type superQueryType = this.typeMappings.getPathType(superType.getEntityType(), model, false);
            writer.line("this._super = new " + writer.getRawName(superQueryType) + "(type, metadata, inits);");
        }
        for (Property field : model.getProperties()) {
            if (field.getType().getCategory() == TypeCategory.INDEX) continue;
            if (field.getType().getCategory() == TypeCategory.ENTITY) {
                this.initEntityField(writer, config, model, field);
                continue;
            }
            if (!field.isInherited() || superType == null || !superType.getEntityType().hasEntityFields()) continue;
            writer.line("this.", field.getEscapedName(), " = _super.", field.getEscapedName(), ";");
        }
    }

    protected void initIndexFields(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        Supertype superType = model.getSuperType();
        if (superType != null && superType.getEntityType() == null) {
            throw new IllegalStateException("No entity type for " + superType.getType().getFullName());
        }
        for (Property field : model.getProperties()) {
            if (field.getType().getCategory() != TypeCategory.INDEX) continue;
            if (field.isInherited() && superType != null) {
                writer.line("this.", field.getEscapedName(), " = _super.", field.getEscapedName(), ";");
                continue;
            }
            this.initIndexField(writer, config, model, field);
        }
    }

    protected void initEntityField(CodeWriter writer, SerializerConfig config, EntityType model, Property field) throws IOException {
        Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
        if (!field.isInherited()) {
            boolean hasEntityFields = field.getType() instanceof EntityType && ((EntityType)field.getType()).hasEntityFields();
            writer.line("this." + field.getEscapedName() + " = ", "inits.isInitialized(\"" + field.getName() + "\") ? ", "new " + writer.getRawName(queryType) + "(forProperty(\"" + field.getName() + "\")", hasEntityFields ? ", inits.get(\"" + field.getName() + "\")" : "", ") : null;");
        } else if (!config.useEntityAccessors()) {
            writer.line("this.", field.getEscapedName(), " = ", "_super.", field.getEscapedName(), ";");
        }
    }

    protected void initIndexField(CodeWriter writer, SerializerConfig config, EntityType model, Property field) throws IOException {
        IndexClassType type = (IndexClassType)field.getType();
        writer.line("this." + field.getName() + " = new br.com.anteros.persistence.dsl.osql.types.IndexHint(this,\"" + type.getIndexName() + "\");");
    }

    protected void intro(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        this.introPackage(writer, model);
        this.introImports(writer, config, model);
        writer.nl();
        this.introJavadoc(writer, model);
        this.introClassHeader(writer, model);
        this.introFactoryMethods(writer, model);
        this.introInits(writer, model);
        if (config.createDefaultVariable()) {
            this.introDefaultInstance(writer, model, config.defaultVariableName());
        }
        if (model.getSuperType() != null && model.getSuperType().getEntityType() != null) {
            this.introSuper(writer, model);
        }
    }

    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Class<EntityPathBase> pathType;
        Type queryType = this.typeMappings.getPathType(model, model, true);
        TypeCategory category = model.getOriginalCategory();
        if (model.getProperties().isEmpty()) {
            switch (category) {
                case COMPARABLE: {
                    pathType = ComparablePath.class;
                    break;
                }
                case ENUM: {
                    pathType = EnumPath.class;
                    break;
                }
                case DATE: {
                    pathType = DatePath.class;
                    break;
                }
                case DATETIME: {
                    pathType = DateTimePath.class;
                    break;
                }
                case TIME: {
                    pathType = TimePath.class;
                    break;
                }
                case NUMERIC: {
                    pathType = NumberPath.class;
                    break;
                }
                case STRING: {
                    pathType = StringPath.class;
                    break;
                }
                case BOOLEAN: {
                    pathType = BooleanPath.class;
                    break;
                }
                default: {
                    pathType = EntityPathBase.class;
                    break;
                }
            }
        } else {
            pathType = EntityPathBase.class;
        }
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.line("@Generated(\"", this.getClass().getName(), "\")");
        if (category == TypeCategory.BOOLEAN || category == TypeCategory.STRING) {
            writer.beginClass(queryType, new ClassType(pathType, new Type[0]), new Type[0]);
        } else {
            writer.beginClass(queryType, new ClassType(category, pathType, model), new Type[0]);
        }
        long serialVersionUID = model.getFullName().hashCode();
        writer.privateStaticFinal(Types.LONG_P, "serialVersionUID", String.valueOf(serialVersionUID) + "L");
    }

    protected void introDefaultInstance(CodeWriter writer, EntityType model, String defaultName) throws IOException {
        String simpleName = !defaultName.isEmpty() ? defaultName : model.getUncapSimpleName();
        Type queryType = this.typeMappings.getPathType(model, model, true);
        String alias = simpleName;
        if (this.keywords.contains(simpleName.toUpperCase())) {
            alias = String.valueOf(alias) + "1";
        }
        writer.publicStaticFinal(queryType, simpleName, "new " + queryType.getSimpleName() + "(\"" + alias + "\")");
    }

    protected void introFactoryMethods(CodeWriter writer, final EntityType model) throws IOException {
        String localName = writer.getRawName(model);
        String genericName = writer.getGenericName(true, model);
        HashSet sizes = Sets.newHashSet();
        for (Constructor c : model.getConstructors()) {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("unchecked");
            }
            ClassType returnType = new ClassType(ConstructorExpression.class, model);
            final boolean asExpr = sizes.add(c.getParameters().size());
            writer.beginStaticMethod((Type)returnType, "create", c.getParameters(), new Function<Parameter, Parameter>(){

                public Parameter apply(Parameter p) {
                    Type type = !asExpr ? EntitySerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true) : (p.getType().isFinal() ? new ClassType(Expression.class, p.getType()) : new ClassType(Expression.class, new TypeExtends(p.getType())));
                    return new Parameter(p.getName(), type);
                }
            });
            writer.beginLine("return new ConstructorExpression<" + genericName + ">(");
            if (!localName.equals(genericName)) {
                writer.append("(Class)");
            }
            writer.append(writer.getClassConstant(localName));
            writer.append(", new Class[]{");
            boolean first = true;
            for (Parameter p : c.getParameters()) {
                if (!first) {
                    writer.append(", ");
                }
                if (Types.PRIMITIVES.containsKey(p.getType())) {
                    Type primitive = Types.PRIMITIVES.get(p.getType());
                    writer.append(writer.getClassConstant(primitive.getFullName()));
                } else {
                    writer.append(writer.getClassConstant(writer.getRawName(p.getType())));
                }
                first = false;
            }
            writer.append("}");
            for (Parameter p : c.getParameters()) {
                writer.append(", " + p.getName());
            }
            writer.append(");\n");
            writer.end();
        }
    }

    protected void introImports(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        writer.staticimports(PathMetadataFactory.class);
        Type queryType = this.typeMappings.getPathType(model, model, true);
        if (!(model.getPackageName().isEmpty() || queryType.getPackageName().equals(model.getPackageName()) || queryType.getSimpleName().equals(model.getSimpleName()))) {
            String packageName;
            String fullName = model.getFullName();
            if (fullName.substring((packageName = model.getPackageName()).length() + 1).contains(".")) {
                fullName = fullName.substring(0, fullName.lastIndexOf(46));
            }
            writer.importClasses(fullName);
        }
        this.introDelegatePackages(writer, model);
        ArrayList packages = Lists.newArrayList();
        packages.add(SimplePath.class.getPackage());
        if (!model.getConstructors().isEmpty()) {
            packages.add(SimpleExpression.class.getPackage());
        }
        if (this.isImportExprPackage(model)) {
            packages.add(ComparableExpression.class.getPackage());
        }
        writer.imports(packages.toArray(new Package[packages.size()]));
        ArrayList classes = Lists.newArrayList((Object[])new Class[]{PathMetadata.class, Generated.class});
        if (!this.getUsedClassNames(model).contains("Path")) {
            classes.add(Path.class);
        }
        if (!model.getConstructors().isEmpty()) {
            classes.add(ConstructorExpression.class);
            classes.add(Expression.class);
        }
        boolean inits = false;
        if (model.hasEntityFields() || model.hasInits()) {
            inits = true;
        } else {
            HashSet collections = Sets.newHashSet((Object[])new TypeCategory[]{TypeCategory.COLLECTION, TypeCategory.LIST, TypeCategory.SET});
            for (Property property : model.getProperties()) {
                if (property.isInherited() || !collections.contains((Object)property.getType().getCategory())) continue;
                inits = true;
                break;
            }
        }
        if (inits) {
            classes.add(PathInits.class);
        }
        writer.imports(classes.toArray(new Class[classes.size()]));
    }

    private Set<String> getUsedClassNames(EntityType model) {
        HashSet result = Sets.newHashSet();
        result.add(model.getSimpleName());
        for (Property property : model.getProperties()) {
            result.add(property.getType().getSimpleName());
            for (Type type : property.getType().getParameters()) {
                if (type == null) continue;
                result.add(type.getSimpleName());
            }
        }
        return result;
    }

    protected boolean isImportExprPackage(EntityType model) {
        if (!model.getConstructors().isEmpty() || !model.getDelegates().isEmpty()) {
            boolean importExprPackage = false;
            for (Constructor c : model.getConstructors()) {
                for (Parameter cp : c.getParameters()) {
                    importExprPackage |= cp.getType().getPackageName().equals(ComparableExpression.class.getPackage().getName());
                }
            }
            for (Delegate d : model.getDelegates()) {
                for (Parameter dp : d.getParameters()) {
                    importExprPackage |= dp.getType().getPackageName().equals(ComparableExpression.class.getPackage().getName());
                }
            }
            return importExprPackage;
        }
        return false;
    }

    protected void introDelegatePackages(CodeWriter writer, EntityType model) throws IOException {
        HashSet<String> packages = new HashSet<String>();
        for (Delegate delegate : model.getDelegates()) {
            if (delegate.getDelegateType().getPackageName().equals(model.getPackageName())) continue;
            packages.add(delegate.getDelegateType().getPackageName());
        }
        writer.importPackages(packages.toArray(new String[packages.size()]));
    }

    protected void introInits(CodeWriter writer, EntityType model) throws IOException {
        ArrayList<String> inits = new ArrayList<String>();
        for (Property property : model.getProperties()) {
            for (String init : property.getInits()) {
                inits.add(String.valueOf(property.getEscapedName()) + "." + init);
            }
        }
        if (!inits.isEmpty()) {
            inits.add(0, "*");
            String initsAsString = "\"" + JOINER.join(inits) + "\"";
            writer.privateStaticFinal(PATH_INITS_TYPE, "INITS", "new PathInits(" + initsAsString + ")");
        } else if (model.hasEntityFields()) {
            writer.privateStaticFinal(PATH_INITS_TYPE, "INITS", "PathInits.DIRECT2");
        }
    }

    protected void introJavadoc(CodeWriter writer, EntityType model) throws IOException {
        Type queryType = this.typeMappings.getPathType(model, model, true);
        writer.javadoc(String.valueOf(queryType.getSimpleName()) + " is a query type for " + model.getSimpleName());
    }

    protected void introPackage(CodeWriter writer, EntityType model) throws IOException {
        Type queryType = this.typeMappings.getPathType(model, model, false);
        if (!queryType.getPackageName().isEmpty()) {
            writer.packageDecl(queryType.getPackageName());
        }
    }

    protected void introSuper(CodeWriter writer, EntityType model) throws IOException {
        EntityType superType = model.getSuperType().getEntityType();
        Type superQueryType = this.typeMappings.getPathType(superType, model, false);
        if (!superType.hasEntityFields()) {
            writer.publicFinal(superQueryType, "_super", "new " + writer.getRawName(superQueryType) + "(this)");
        } else {
            writer.publicFinal(superQueryType, "_super");
        }
    }

    protected void listAccessor(EntityType model, Property field, CodeWriter writer) throws IOException {
        String escapedName = field.getEscapedName();
        Type queryType = this.typeMappings.getPathType(field.getParameter(0), model, false);
        writer.beginPublicMethod(queryType, escapedName, new Parameter("index", Types.INT));
        writer.line("return " + escapedName + ".get(index);").end();
        writer.beginPublicMethod(queryType, escapedName, new Parameter("index", new ClassType(Expression.class, Types.INTEGER)));
        writer.line("return " + escapedName + ".get(index);").end();
    }

    protected void mapAccessor(EntityType model, Property field, CodeWriter writer) throws IOException {
        String escapedName = field.getEscapedName();
        Type queryType = this.typeMappings.getPathType(field.getParameter(1), model, false);
        writer.beginPublicMethod(queryType, escapedName, new Parameter("key", field.getParameter(0)));
        writer.line("return " + escapedName + ".get(key);").end();
        writer.beginPublicMethod(queryType, escapedName, new Parameter("key", new ClassType(Expression.class, field.getParameter(0))));
        writer.line("return " + escapedName + ".get(key);").end();
    }

    private void delegate(EntityType model, Delegate delegate, SerializerConfig config, CodeWriter writer) throws IOException {
        Parameter[] params = delegate.getParameters().toArray(new Parameter[delegate.getParameters().size()]);
        writer.beginPublicMethod(delegate.getReturnType(), delegate.getName(), params);
        writer.beginLine("return " + delegate.getDelegateType().getSimpleName() + "." + delegate.getName() + "(");
        writer.append("this");
        if (!model.equals(delegate.getDeclaringType())) {
            int counter = 0;
            EntityType type = model;
            while (type != null && !type.equals(delegate.getDeclaringType())) {
                type = type.getSuperType() != null ? type.getSuperType().getEntityType() : null;
                ++counter;
            }
            int i = 0;
            while (i < counter) {
                writer.append("._super");
                ++i;
            }
        }
        for (Parameter parameter : delegate.getParameters()) {
            writer.append(", " + parameter.getName());
        }
        writer.append(");\n");
        writer.end();
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.end();
    }

    @Override
    public void serialize(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        this.intro(model, config, writer);
        this.serializeProperties(model, config, writer);
        this.constructors(model, config, writer);
        for (Delegate delegate : model.getDelegates()) {
            this.delegate(model, delegate, config, writer);
        }
        for (Property property : model.getProperties()) {
            TypeCategory category = property.getType().getCategory();
            if (category == TypeCategory.MAP && config.useMapAccessors()) {
                this.mapAccessor(model, property, writer);
                continue;
            }
            if (category == TypeCategory.LIST && config.useListAccessors()) {
                this.listAccessor(model, property, writer);
                continue;
            }
            if (category != TypeCategory.ENTITY || !config.useEntityAccessors()) continue;
            this.entityAccessor(model, property, writer);
        }
        this.serializeMethodAll(model, config, writer);
        this.outro(model, writer);
    }

    protected void serializeMethodAll(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder("");
        boolean appendDelimiter = false;
        for (Property property : model.getProperties()) {
            if (property.getType().getCategory() == TypeCategory.ARRAY || property.getType().getCategory() == TypeCategory.COLLECTION || property.getType().getCategory() == TypeCategory.LIST || property.getType().getCategory() == TypeCategory.MAP || property.getType().getCategory() == TypeCategory.SET || property.getType().getClass() == IndexClassType.class) continue;
            if (appendDelimiter) {
                sb.append(",");
            }
            sb.append(property.getName());
            appendDelimiter = true;
        }
        if (!sb.toString().equals("")) {
            writer.line("public Path<?>[] all() {");
            writer.line("\treturn new Path[]{" + sb.toString() + "};");
            writer.line("}");
        }
    }

    protected void serialize(EntityType model, Property field, Type type, CodeWriter writer, String factoryMethod, String ... args) throws IOException {
        Supertype superType = model.getSuperType();
        StringBuilder value = new StringBuilder();
        if (field.isInherited() && superType != null) {
            if (!superType.getEntityType().hasEntityFields()) {
                value.append("_super." + field.getEscapedName());
            }
        } else {
            value.append(String.valueOf(factoryMethod) + "(\"" + field.getName() + "\"");
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                value.append(", " + arg);
                ++n2;
            }
            value.append(")");
        }
        if (field.isInherited()) {
            writer.line("//inherited");
        }
        if (value.length() > 0) {
            writer.publicFinal(type, field.getEscapedName(), value.toString());
        } else {
            writer.publicFinal(type, field.getEscapedName());
        }
    }

    protected void customField(EntityType model, Property field, SerializerConfig config, CodeWriter writer) throws IOException {
        Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
        writer.line("// custom");
        if (field.isInherited()) {
            writer.line("// inherited");
            Supertype superType = model.getSuperType();
            if (!superType.getEntityType().hasEntityFields()) {
                writer.publicFinal(queryType, field.getEscapedName(), "_super." + field.getEscapedName());
            } else {
                writer.publicFinal(queryType, field.getEscapedName());
            }
        } else {
            String value = "new " + writer.getRawName(queryType) + "(forProperty(\"" + field.getName() + "\"))";
            writer.publicFinal(queryType, field.getEscapedName(), value);
        }
    }

    private Type wrap(Type type) {
        if (type.equals(Types.BOOLEAN_P)) {
            return Types.BOOLEAN;
        }
        if (type.equals(Types.BYTE_P)) {
            return Types.BYTE;
        }
        if (type.equals(Types.CHAR)) {
            return Types.CHARACTER;
        }
        if (type.equals(Types.DOUBLE_P)) {
            return Types.DOUBLE;
        }
        if (type.equals(Types.FLOAT_P)) {
            return Types.FLOAT;
        }
        if (type.equals(Types.INT)) {
            return Types.INTEGER;
        }
        if (type.equals(Types.LONG_P)) {
            return Types.LONG;
        }
        if (type.equals(Types.SHORT_P)) {
            return Types.SHORT;
        }
        return type;
    }

    protected void serializeProperties(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        for (Property property : model.getProperties()) {
            if (this.typeMappings.isRegistered(property.getType()) && property.getType().getCategory() != TypeCategory.CUSTOM && property.getType().getCategory() != TypeCategory.ENTITY) {
                this.customField(model, property, config, writer);
                continue;
            }
            SimpleType propertyType = new SimpleType(property.getType(), property.getType().getParameters());
            Type queryType = null;
            if (!property.getType().getCategory().equals((Object)TypeCategory.INDEX)) {
                queryType = this.typeMappings.getPathType(propertyType, model, false);
            }
            Type genericQueryType = null;
            String localRawName = writer.getRawName(property.getType());
            String inits = this.getInits(property);
            switch (property.getType().getCategory()) {
                case STRING: {
                    this.serialize(model, property, queryType, writer, "createString", new String[0]);
                    break;
                }
                case BOOLEAN: {
                    this.serialize(model, property, queryType, writer, "createBoolean", new String[0]);
                    break;
                }
                case SIMPLE: {
                    this.serialize(model, property, queryType, writer, "createSimple", writer.getClassConstant(localRawName));
                    break;
                }
                case COMPARABLE: {
                    this.serialize(model, property, queryType, writer, "createComparable", writer.getClassConstant(localRawName));
                    break;
                }
                case ENUM: {
                    this.serialize(model, property, queryType, writer, "createEnum", writer.getClassConstant(localRawName));
                    break;
                }
                case DATE: {
                    this.serialize(model, property, queryType, writer, "createDate", writer.getClassConstant(localRawName));
                    break;
                }
                case DATETIME: {
                    this.serialize(model, property, queryType, writer, "createDateTime", writer.getClassConstant(localRawName));
                    break;
                }
                case TIME: {
                    this.serialize(model, property, queryType, writer, "createTime", writer.getClassConstant(localRawName));
                    break;
                }
                case NUMERIC: {
                    this.serialize(model, property, queryType, writer, "createNumber", writer.getClassConstant(localRawName));
                    break;
                }
                case INDEX: {
                    this.serializeIndex(model, property, propertyType, writer);
                    break;
                }
                case CUSTOM: {
                    this.customField(model, property, config, writer);
                    break;
                }
                case ARRAY: {
                    this.serialize(model, property, new ClassType(ArrayPath.class, property.getType(), this.wrap(property.getType().getComponentType())), writer, "createArray", writer.getClassConstant(localRawName));
                    break;
                }
                case COLLECTION: {
                    genericQueryType = this.typeMappings.getPathType(this.getRaw(property.getParameter(0)), model, false);
                    String genericKey = writer.getGenericName(true, property.getParameter(0));
                    localRawName = writer.getRawName(property.getParameter(0));
                    queryType = this.typeMappings.getPathType(property.getParameter(0), model, true);
                    this.serialize(model, property, new ClassType(CollectionPath.class, this.getRaw(property.getParameter(0)), genericQueryType), writer, "this.<" + genericKey + ", " + writer.getGenericName(true, genericQueryType) + ">createCollection", writer.getClassConstant(localRawName), writer.getClassConstant(writer.getRawName(queryType)), inits);
                    break;
                }
                case SET: {
                    genericQueryType = this.typeMappings.getPathType(this.getRaw(property.getParameter(0)), model, false);
                    String genericKey = writer.getGenericName(true, property.getParameter(0));
                    localRawName = writer.getRawName(property.getParameter(0));
                    queryType = this.typeMappings.getPathType(property.getParameter(0), model, true);
                    this.serialize(model, property, new ClassType(SetPath.class, this.getRaw(property.getParameter(0)), genericQueryType), writer, "this.<" + genericKey + ", " + writer.getGenericName(true, genericQueryType) + ">createSet", writer.getClassConstant(localRawName), writer.getClassConstant(writer.getRawName(queryType)), inits);
                    break;
                }
                case LIST: {
                    genericQueryType = this.typeMappings.getPathType(this.getRaw(property.getParameter(0)), model, false);
                    String genericKey = writer.getGenericName(true, property.getParameter(0));
                    localRawName = writer.getRawName(property.getParameter(0));
                    queryType = this.typeMappings.getPathType(property.getParameter(0), model, true);
                    this.serialize(model, property, new ClassType(ListPath.class, this.getRaw(property.getParameter(0)), genericQueryType), writer, "this.<" + genericKey + ", " + writer.getGenericName(true, genericQueryType) + ">createList", writer.getClassConstant(localRawName), writer.getClassConstant(writer.getRawName(queryType)), inits);
                    break;
                }
                case MAP: {
                    String genericKey = writer.getGenericName(true, property.getParameter(0));
                    String genericValue = writer.getGenericName(true, property.getParameter(1));
                    genericQueryType = this.typeMappings.getPathType(this.getRaw(property.getParameter(1)), model, false);
                    String keyType = writer.getRawName(property.getParameter(0));
                    String valueType = writer.getRawName(property.getParameter(1));
                    queryType = this.typeMappings.getPathType(property.getParameter(1), model, true);
                    this.serialize(model, property, new ClassType(MapPath.class, this.getRaw(property.getParameter(0)), this.getRaw(property.getParameter(1)), genericQueryType), writer, "this.<" + genericKey + ", " + genericValue + ", " + writer.getGenericName(true, genericQueryType) + ">createMap", writer.getClassConstant(keyType), writer.getClassConstant(valueType), writer.getClassConstant(writer.getRawName(queryType)));
                    break;
                }
                case ENTITY: {
                    this.entityField(model, property, config, writer);
                }
            }
        }
    }

    private void serializeIndex(EntityType model, Property field, Type propertyType, CodeWriter writer) throws IOException {
        writer.publicFinal(propertyType, field.getEscapedName());
    }

    private String getInits(Property property) {
        if (!property.getInits().isEmpty()) {
            return "INITS.get(\"" + property.getName() + "\")";
        }
        return "PathInits.DIRECT2";
    }

    private Type getRaw(Type type) {
        if (type instanceof EntityType && type.getPackageName().startsWith("ext.java")) {
            return type;
        }
        return new SimpleType(type, type.getParameters());
    }
}

