/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.CodeWriter;
import br.com.anteros.persistence.apt.codegen.EntitySerializer;
import br.com.anteros.persistence.apt.codegen.EntityType;
import br.com.anteros.persistence.apt.codegen.TypeMappings;
import br.com.anteros.persistence.apt.codegen.model.ClassType;
import br.com.anteros.persistence.apt.codegen.model.Type;
import br.com.anteros.persistence.apt.codegen.model.TypeCategory;
import br.com.anteros.persistence.apt.codegen.model.Types;
import br.com.anteros.persistence.dsl.osql.types.path.BeanPath;
import br.com.anteros.persistence.dsl.osql.types.path.BooleanPath;
import br.com.anteros.persistence.dsl.osql.types.path.ComparablePath;
import br.com.anteros.persistence.dsl.osql.types.path.DatePath;
import br.com.anteros.persistence.dsl.osql.types.path.DateTimePath;
import br.com.anteros.persistence.dsl.osql.types.path.EnumPath;
import br.com.anteros.persistence.dsl.osql.types.path.NumberPath;
import br.com.anteros.persistence.dsl.osql.types.path.StringPath;
import br.com.anteros.persistence.dsl.osql.types.path.TimePath;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;

public final class EmbeddableSerializer
extends EntitySerializer {
    @Inject
    public EmbeddableSerializer(TypeMappings typeMappings, @Named(value="keywords") Collection<String> keywords) {
        super(typeMappings, keywords);
    }

    @Override
    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Class<BeanPath> pathType;
        Type queryType = this.typeMappings.getPathType(model, model, true);
        TypeCategory category = model.getOriginalCategory();
        if (model.getProperties().isEmpty()) {
            switch (category) {
                case COMPARABLE: {
                    pathType = ComparablePath.class;
                    break;
                }
                case ENUM: {
                    pathType = EnumPath.class;
                    break;
                }
                case DATE: {
                    pathType = DatePath.class;
                    break;
                }
                case DATETIME: {
                    pathType = DateTimePath.class;
                    break;
                }
                case TIME: {
                    pathType = TimePath.class;
                    break;
                }
                case NUMERIC: {
                    pathType = NumberPath.class;
                    break;
                }
                case STRING: {
                    pathType = StringPath.class;
                    break;
                }
                case BOOLEAN: {
                    pathType = BooleanPath.class;
                    break;
                }
                default: {
                    pathType = BeanPath.class;
                    break;
                }
            }
        } else {
            pathType = BeanPath.class;
        }
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.line("@Generated(\"", this.getClass().getName(), "\")");
        if (category == TypeCategory.BOOLEAN || category == TypeCategory.STRING) {
            writer.beginClass(queryType, new ClassType(pathType, new Type[0]), new Type[0]);
        } else {
            writer.beginClass(queryType, new ClassType(category, pathType, model), new Type[0]);
        }
        writer.privateStaticFinal(Types.LONG_P, "serialVersionUID", String.valueOf(model.hashCode()) + "L");
    }

    @Override
    protected void introFactoryMethods(CodeWriter writer, EntityType model) throws IOException {
    }
}

