/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.CodeWriter;
import br.com.anteros.persistence.apt.codegen.EntityType;
import br.com.anteros.persistence.apt.codegen.Property;
import br.com.anteros.persistence.apt.codegen.Serializer;
import br.com.anteros.persistence.apt.codegen.SerializerConfig;
import br.com.anteros.persistence.apt.codegen.model.ClassType;
import br.com.anteros.persistence.apt.codegen.model.Parameter;
import br.com.anteros.persistence.apt.codegen.model.Type;
import br.com.anteros.persistence.apt.codegen.model.TypeCategory;
import br.com.anteros.persistence.apt.codegen.model.Types;
import br.com.anteros.persistence.dsl.osql.util.BeanUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;

public class BeanSerializer
implements Serializer {
    private static final Function<Property, Parameter> propertyToParameter = new Function<Property, Parameter>(){

        public Parameter apply(Property input) {
            return new Parameter(input.getName(), input.getType());
        }
    };
    private final boolean propertyAnnotations;
    private final List<Type> interfaces = Lists.newArrayList();
    private final String javadocSuffix;
    private boolean addToString;
    private boolean addFullConstructor;
    private boolean printSupertype = false;

    public BeanSerializer() {
        this(true, " is a bean type");
    }

    public BeanSerializer(String javadocSuffix) {
        this(true, javadocSuffix);
    }

    public BeanSerializer(boolean propertyAnnotations) {
        this(propertyAnnotations, " is a bean type");
    }

    public BeanSerializer(boolean propertyAnnotations, String javadocSuffix) {
        this.propertyAnnotations = propertyAnnotations;
        this.javadocSuffix = javadocSuffix;
    }

    @Override
    public void serialize(EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        if (!model.getPackageName().isEmpty()) {
            writer.packageDecl(model.getPackageName());
        }
        Set<String> importedClasses = this.getAnnotationTypes(model);
        for (Type iface : this.interfaces) {
            importedClasses.add(iface.getFullName());
        }
        importedClasses.add(Generated.class.getName());
        if (model.hasLists()) {
            importedClasses.add(List.class.getName());
        }
        if (model.hasCollections()) {
            importedClasses.add(Collection.class.getName());
        }
        if (model.hasSets()) {
            importedClasses.add(Set.class.getName());
        }
        if (model.hasMaps()) {
            importedClasses.add(Map.class.getName());
        }
        if (this.addToString && model.hasArrays()) {
            importedClasses.add(Arrays.class.getName());
        }
        writer.importClasses(importedClasses.toArray(new String[importedClasses.size()]));
        writer.javadoc(String.valueOf(simpleName) + this.javadocSuffix);
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.line("@Generated(\"", this.getClass().getName(), "\")");
        if (!this.interfaces.isEmpty()) {
            Type superType = null;
            if (this.printSupertype && model.getSuperType() != null) {
                superType = model.getSuperType().getType();
            }
            Type[] ifaces = this.interfaces.toArray(new Type[this.interfaces.size()]);
            writer.beginClass(model, superType, ifaces);
        } else if (this.printSupertype && model.getSuperType() != null) {
            writer.beginClass(model, model.getSuperType().getType(), new Type[0]);
        } else {
            writer.beginClass(model);
        }
        this.bodyStart(model, writer);
        if (this.addFullConstructor) {
            this.addFullConstructor(model, writer);
        }
        for (Property property : model.getProperties()) {
            if (this.propertyAnnotations) {
                for (Annotation annotation : property.getAnnotations()) {
                    writer.annotation(annotation);
                }
            }
            writer.privateField(property.getType(), property.getEscapedName());
        }
        for (Property property : model.getProperties()) {
            String propertyName = property.getEscapedName();
            writer.beginPublicMethod(property.getType(), "get" + BeanUtils.capitalize((String)propertyName), new Parameter[0]);
            writer.line("return ", propertyName, ";");
            writer.end();
            Parameter parameter = new Parameter(propertyName, property.getType());
            writer.beginPublicMethod((Type)Types.VOID, "set" + BeanUtils.capitalize((String)propertyName), parameter);
            writer.line("this.", propertyName, " = ", propertyName, ";");
            writer.end();
        }
        if (this.addToString) {
            this.addToString(model, writer);
        }
        this.bodyEnd(model, writer);
        writer.end();
    }

    protected void addFullConstructor(EntityType model, CodeWriter writer) throws IOException {
        writer.beginConstructor(new Parameter[0]);
        writer.end();
        writer.beginConstructor(model.getProperties(), propertyToParameter);
        for (Property property : model.getProperties()) {
            writer.line("this.", property.getEscapedName(), " = ", property.getEscapedName(), ";");
        }
        writer.end();
    }

    protected void addToString(EntityType model, CodeWriter writer) throws IOException {
        writer.beginPublicMethod((Type)Types.STRING, "toString", new Parameter[0]);
        StringBuilder builder = new StringBuilder();
        for (Property property : model.getProperties()) {
            String propertyName = property.getEscapedName();
            if (builder.length() > 0) {
                builder.append(" + \", ");
            } else {
                builder.append("\"");
            }
            builder.append(String.valueOf(propertyName) + " = \" + ");
            if (property.getType().getCategory() == TypeCategory.ARRAY) {
                builder.append("Arrays.toString(" + propertyName + ")");
                continue;
            }
            builder.append(propertyName);
        }
        writer.line(" return ", builder.toString(), ";");
        writer.end();
    }

    protected void bodyStart(EntityType model, CodeWriter writer) throws IOException {
    }

    protected void bodyEnd(EntityType model, CodeWriter writer) throws IOException {
    }

    private Set<String> getAnnotationTypes(EntityType model) {
        HashSet<String> imports = new HashSet<String>();
        for (Annotation annotation : model.getAnnotations()) {
            imports.add(annotation.annotationType().getName());
        }
        if (this.propertyAnnotations) {
            for (Property property : model.getProperties()) {
                for (Annotation annotation : property.getAnnotations()) {
                    imports.add(annotation.annotationType().getName());
                }
            }
        }
        return imports;
    }

    public void addInterface(Class<?> iface) {
        this.interfaces.add(new ClassType(iface, new Type[0]));
    }

    public void addInterface(Type type) {
        this.interfaces.add(type);
    }

    public void setAddToString(boolean addToString) {
        this.addToString = addToString;
    }

    public void setAddFullConstructor(boolean addFullConstructor) {
        this.addFullConstructor = addFullConstructor;
    }

    public void setPrintSupertype(boolean printSupertype) {
        this.printSupertype = printSupertype;
    }
}

