/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.CodegenException;
import br.com.anteros.persistence.apt.codegen.Evaluator;
import br.com.anteros.persistence.apt.codegen.EvaluatorFactory;
import br.com.anteros.persistence.apt.codegen.JavaWriter;
import br.com.anteros.persistence.apt.codegen.MethodEvaluator;
import br.com.anteros.persistence.apt.codegen.model.ClassType;
import br.com.anteros.persistence.apt.codegen.model.Parameter;
import br.com.anteros.persistence.apt.codegen.model.SimpleType;
import br.com.anteros.persistence.apt.codegen.model.Type;
import br.com.anteros.persistence.apt.codegen.model.TypeCategory;
import br.com.anteros.persistence.apt.codegen.support.ClassUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class AbstractEvaluatorFactory
implements EvaluatorFactory {
    private final Map<String, Method> cache = new WeakHashMap<String, Method>();
    protected ClassLoader loader;

    protected abstract void compile(String var1, ClassType var2, String[] var3, Type[] var4, String var5, Map<String, Object> var6) throws IOException;

    protected String createSource(String source, ClassType projectionType, String[] names, Type[] types, String id, Map<String, Object> constants) throws IOException {
        StringWriter writer = new StringWriter();
        JavaWriter javaw = new JavaWriter(writer);
        SimpleType idType = new SimpleType(id, "", id, new Type[0]);
        javaw.beginClass(idType, null, new Type[0]);
        Parameter[] params = new Parameter[names.length + constants.size()];
        int i = 0;
        while (i < names.length) {
            params[i] = new Parameter(names[i], types[i]);
            ++i;
        }
        i = names.length;
        for (Map.Entry<String, Object> entry : constants.entrySet()) {
            ClassType type = new ClassType(TypeCategory.SIMPLE, ClassUtils.normalize(entry.getValue().getClass()), new Type[0]);
            params[i++] = new Parameter(entry.getKey(), type);
        }
        javaw.beginStaticMethod((Type)projectionType, "eval", params);
        javaw.append(source);
        javaw.end();
        javaw.end();
        return writer.toString();
    }

    @Override
    public <T> Evaluator<T> createEvaluator(String source, Class<? extends T> projectionType, String[] names, Class<?>[] classes, Map<String, Object> constants) {
        Type[] types = new Type[classes.length];
        int i = 0;
        while (i < types.length) {
            types[i] = new ClassType(TypeCategory.SIMPLE, classes[i], new Type[0]);
            ++i;
        }
        return this.createEvaluator(source, new ClassType(TypeCategory.SIMPLE, projectionType, new Type[0]), names, types, classes, constants);
    }

    @Override
    public <T> Evaluator<T> createEvaluator(String source, ClassType projection, String[] names, Type[] types, Class<?>[] classes, Map<String, Object> constants) {
        try {
            String id = this.toId(source, projection.getJavaClass(), types, constants.values());
            Method method = this.cache.get(id);
            if (method == null) {
                Class<?> clazz;
                try {
                    clazz = this.loader.loadClass(id);
                }
                catch (ClassNotFoundException e) {
                    this.compile(source, projection, names, types, id, constants);
                    clazz = this.loader.loadClass(id);
                }
                method = this.findEvalMethod(clazz);
                this.cache.put(id, method);
            }
            return new MethodEvaluator(method, constants, projection.getJavaClass());
        }
        catch (ClassNotFoundException e) {
            throw new CodegenException(e);
        }
        catch (SecurityException e) {
            throw new CodegenException(e);
        }
        catch (IOException e) {
            throw new CodegenException(e);
        }
    }

    protected Method findEvalMethod(Class<?> clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if ("eval".equals(method.getName())) {
                return method;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Couldn't find eval method!");
    }

    protected String toId(String source, Class<?> returnType, Type[] types, Collection<Object> constants) {
        StringBuilder b = new StringBuilder(128);
        b.append("T");
        b.append("_").append(source.hashCode());
        b.append("_").append(returnType.getName().hashCode());
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            b.append("_").append(type.getFullName().hashCode());
            ++n2;
        }
        for (Object constant : constants) {
            b.append("_").append(constant.getClass().getName().hashCode());
        }
        return b.toString().replace('-', '0');
    }
}

