/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.CodeWriter;
import com.google.common.base.Strings;
import java.io.IOException;

public abstract class AbstractCodeWriter<T extends AbstractCodeWriter<T>>
implements Appendable,
CodeWriter {
    private final Appendable appendable;
    private final int spaces;
    private final String spacesString;
    private String indent = "";
    private final T self = this;

    public AbstractCodeWriter(Appendable appendable, int spaces) {
        if (appendable == null) {
            throw new IllegalArgumentException("appendable is null");
        }
        this.appendable = appendable;
        this.spaces = spaces;
        this.spacesString = Strings.repeat((String)" ", (int)spaces);
    }

    public T append(char c) throws IOException {
        this.appendable.append(c);
        return this.self;
    }

    public T append(CharSequence csq) throws IOException {
        this.appendable.append(csq);
        return this.self;
    }

    public T append(CharSequence csq, int start, int end) throws IOException {
        this.appendable.append(csq, start, end);
        return this.self;
    }

    public T beginLine(String ... segments) throws IOException {
        this.append(this.indent);
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            this.append(segment);
            ++n2;
        }
        return this.self;
    }

    protected T goIn() {
        this.indent = String.valueOf(this.indent) + this.spacesString;
        return this.self;
    }

    protected T goOut() {
        if (this.indent.length() >= this.spaces) {
            this.indent = this.indent.substring(0, this.indent.length() - this.spaces);
        }
        return this.self;
    }

    public T line(String ... segments) throws IOException {
        this.append(this.indent);
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            this.append(segment);
            ++n2;
        }
        return (T)this.nl();
    }

    public T nl() throws IOException {
        return (T)this.append("\n");
    }
}

