/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt;

import br.com.anteros.persistence.apt.Configuration;
import br.com.anteros.persistence.apt.VisitorConfig;
import br.com.anteros.persistence.apt.codegen.CodegenModule;
import br.com.anteros.persistence.apt.codegen.EmbeddableSerializer;
import br.com.anteros.persistence.apt.codegen.EntitySerializer;
import br.com.anteros.persistence.apt.codegen.EntityType;
import br.com.anteros.persistence.apt.codegen.ProjectionSerializer;
import br.com.anteros.persistence.apt.codegen.QueryTypeFactory;
import br.com.anteros.persistence.apt.codegen.Serializer;
import br.com.anteros.persistence.apt.codegen.SerializerConfig;
import br.com.anteros.persistence.apt.codegen.SimpleSerializerConfig;
import br.com.anteros.persistence.apt.codegen.SupertypeSerializer;
import br.com.anteros.persistence.apt.codegen.TypeMappings;
import br.com.anteros.persistence.apt.codegen.model.ClassType;
import br.com.anteros.persistence.apt.codegen.model.Type;
import br.com.anteros.persistence.dsl.osql.annotations.Config;
import br.com.anteros.persistence.dsl.osql.annotations.QueryProjection;
import br.com.anteros.persistence.dsl.osql.annotations.QueryType;
import br.com.anteros.persistence.dsl.osql.types.Expression;
import br.com.anteros.persistence.dsl.osql.util.Annotations;
import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class DefaultConfiguration
implements Configuration {
    private static final String DEFAULT_SEPARATOR = ",";
    private boolean unknownAsEmbedded;
    private final CodegenModule module = new CodegenModule();
    private final SerializerConfig defaultSerializerConfig;
    private final Map<String, SerializerConfig> packageToConfig = new HashMap<String, SerializerConfig>();
    protected final Class<? extends Annotation> entityAnn;
    private final Set<String> excludedPackages;
    private final Set<String> excludedClasses;
    private final Set<String> includedPackages;
    private final Set<String> includedClasses;
    protected final Class<? extends Annotation> entitiesAnn;
    protected final Class<? extends Annotation> superTypeAnn;
    protected final Class<? extends Annotation> embeddedAnn;
    protected final Class<? extends Annotation> embeddableAnn;
    protected final Class<? extends Annotation> skipAnn;
    protected Class<? extends Annotation> altEntityAnn;
    private final Set<Class<? extends Annotation>> entityAnnotations = new HashSet<Class<? extends Annotation>>();
    private final Map<String, SerializerConfig> typeToConfig = new HashMap<String, SerializerConfig>();
    private boolean useFields = true;
    private boolean useGetters = true;

    public DefaultConfiguration(RoundEnvironment roundEnv, Map<String, String> options, Collection<String> keywords, Class<? extends Annotation> entitiesAnn, Class<? extends Annotation> entityAnn, Class<? extends Annotation> superTypeAnn, Class<? extends Annotation> embeddableAnn, Class<? extends Annotation> embeddedAnn, Class<? extends Annotation> skipAnn) {
        String className;
        String classString;
        String packageName;
        int n;
        int n2;
        String[] stringArray;
        String packageString;
        boolean bl;
        this.excludedClasses = new HashSet<String>();
        this.excludedPackages = new HashSet<String>();
        this.includedClasses = new HashSet<String>();
        this.includedPackages = new HashSet<String>();
        this.module.bind(RoundEnvironment.class, roundEnv);
        this.module.bind("keywords", keywords);
        this.entitiesAnn = entitiesAnn;
        this.entityAnn = entityAnn;
        this.superTypeAnn = superTypeAnn;
        this.embeddableAnn = embeddableAnn;
        this.embeddedAnn = embeddedAnn;
        this.skipAnn = skipAnn;
        this.entityAnnotations.add(entityAnn);
        if (superTypeAnn != null) {
            this.entityAnnotations.add(superTypeAnn);
        }
        if (embeddableAnn != null) {
            this.entityAnnotations.add(embeddableAnn);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Config.class)) {
            Config dslConfig = element.getAnnotation(Config.class);
            SerializerConfig config = SimpleSerializerConfig.getConfig(dslConfig);
            if (element instanceof PackageElement) {
                PackageElement packageElement = (PackageElement)element;
                this.packageToConfig.put(packageElement.getQualifiedName().toString(), config);
                continue;
            }
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            this.typeToConfig.put(typeElement.getQualifiedName().toString(), config);
        }
        boolean bl2 = false;
        boolean listAccessors = false;
        boolean mapAccessors = false;
        boolean createDefaultVariable = true;
        if (options.containsKey("dsl.entityAccessors")) {
            bl = Boolean.valueOf(options.get("dsl.entityAccessors"));
        }
        if (options.containsKey("dsl.listAccessors")) {
            listAccessors = Boolean.valueOf(options.get("dsl.listAccessors"));
        }
        if (options.containsKey("dsl.mapAccessors")) {
            mapAccessors = Boolean.valueOf(options.get("dsl.mapAccessors"));
        }
        if (options.containsKey("dsl.createDefaultVariable")) {
            createDefaultVariable = Boolean.valueOf(options.get("dsl.createDefaultVariable"));
        }
        if (options.containsKey("dsl.packageSuffix")) {
            this.module.bind("packageSuffix", Strings.nullToEmpty((String)options.get("dsl.packageSuffix")));
        }
        if (options.containsKey("dsl.prefix")) {
            this.module.bind("prefix", Strings.nullToEmpty((String)options.get("dsl.prefix")));
        }
        if (options.containsKey("dsl.suffix")) {
            this.module.bind("suffix", Strings.nullToEmpty((String)options.get("dsl.suffix")));
        }
        if (options.containsKey("dsl.unknownAsEmbeddable")) {
            this.unknownAsEmbedded = Boolean.valueOf(options.get("dsl.unknownAsEmbeddable"));
        }
        if (options.containsKey("dsl.excludedPackages") && !Strings.isNullOrEmpty((String)(packageString = options.get("dsl.excludedPackages")))) {
            stringArray = packageString.split(DEFAULT_SEPARATOR);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                packageName = stringArray[n];
                this.excludedPackages.add(packageName);
                ++n;
            }
        }
        if (options.containsKey("dsl.excludedClasses") && !Strings.isNullOrEmpty((String)(classString = options.get("dsl.excludedClasses")))) {
            stringArray = classString.split(DEFAULT_SEPARATOR);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                className = stringArray[n];
                this.excludedClasses.add(className);
                ++n;
            }
        }
        if (options.containsKey("dsl.includedPackages") && !Strings.isNullOrEmpty((String)(packageString = options.get("dsl.includedPackages")))) {
            stringArray = packageString.split(DEFAULT_SEPARATOR);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                packageName = stringArray[n];
                this.includedPackages.add(packageName);
                ++n;
            }
        }
        if (options.containsKey("dsl.includedClasses") && !Strings.isNullOrEmpty((String)(classString = options.get("dsl.includedClasses")))) {
            stringArray = classString.split(DEFAULT_SEPARATOR);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                className = stringArray[n];
                this.includedClasses.add(className);
                ++n;
            }
        }
        this.defaultSerializerConfig = new SimpleSerializerConfig(bl, listAccessors, mapAccessors, createDefaultVariable, "");
    }

    @Override
    public void addExcludedClass(String className) {
        this.excludedClasses.add(className);
    }

    @Override
    public void addExcludedPackage(String packageName) {
        this.excludedPackages.add(packageName);
    }

    @Override
    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        if (this.useFields) {
            if (this.useGetters) {
                return VisitorConfig.ALL;
            }
            return VisitorConfig.FIELDS_ONLY;
        }
        if (this.useGetters) {
            return VisitorConfig.METHODS_ONLY;
        }
        return VisitorConfig.NONE;
    }

    @Override
    public Serializer getDTOSerializer() {
        return this.module.get(ProjectionSerializer.class);
    }

    @Override
    public Class<? extends Annotation> getEntitiesAnnotation() {
        return this.entitiesAnn;
    }

    @Override
    public Class<? extends Annotation> getEmbeddableAnnotation() {
        return this.embeddableAnn;
    }

    @Override
    public Serializer getEmbeddableSerializer() {
        return this.module.get(EmbeddableSerializer.class);
    }

    @Override
    public Class<? extends Annotation> getEntityAnnotation() {
        return this.entityAnn;
    }

    @Override
    public Class<? extends Annotation> getAlternativeEntityAnnotation() {
        return this.altEntityAnn;
    }

    public void setAlternativeEntityAnnotation(Class<? extends Annotation> ann) {
        this.altEntityAnn = ann;
        this.entityAnnotations.add(ann);
    }

    @Override
    public Class<? extends Annotation> getEmbeddedAnnotation() {
        return this.embeddedAnn;
    }

    @Override
    public Set<Class<? extends Annotation>> getEntityAnnotations() {
        return this.entityAnnotations;
    }

    @Override
    public Serializer getEntitySerializer() {
        return this.module.get(EntitySerializer.class);
    }

    @Override
    public String getNamePrefix() {
        return this.module.get(String.class, "prefix");
    }

    @Override
    public SerializerConfig getSerializerConfig(EntityType entityType) {
        if (this.typeToConfig.containsKey(entityType.getFullName())) {
            return this.typeToConfig.get(entityType.getFullName());
        }
        if (this.packageToConfig.containsKey(entityType.getPackageName())) {
            return this.packageToConfig.get(entityType.getPackageName());
        }
        return this.defaultSerializerConfig;
    }

    @Override
    public Class<? extends Annotation> getSkipAnnotation() {
        return this.skipAnn;
    }

    @Override
    public Class<? extends Annotation> getSuperTypeAnnotation() {
        return this.superTypeAnn;
    }

    @Override
    public Serializer getSupertypeSerializer() {
        return this.module.get(SupertypeSerializer.class);
    }

    @Override
    public void inspect(Element element, Annotations annotations) {
    }

    @Override
    public boolean isBlockedField(VariableElement field) {
        if (field.getAnnotation(QueryType.class) != null) {
            return false;
        }
        return field.getAnnotation(this.skipAnn) != null || field.getModifiers().contains((Object)Modifier.TRANSIENT) || field.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isBlockedGetter(ExecutableElement getter) {
        if (getter.getAnnotation(QueryType.class) != null) {
            return false;
        }
        return getter.getAnnotation(this.skipAnn) != null || getter.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isUseFields() {
        return this.useFields;
    }

    @Override
    public boolean isUseGetters() {
        return this.useGetters;
    }

    @Override
    public boolean isValidConstructor(ExecutableElement constructor) {
        return constructor.getModifiers().contains((Object)Modifier.PUBLIC) && constructor.getAnnotation(QueryProjection.class) != null && !constructor.getParameters().isEmpty();
    }

    @Override
    public boolean isValidField(VariableElement field) {
        if (field.getAnnotation(QueryType.class) != null) {
            return true;
        }
        return field.getAnnotation(this.skipAnn) == null && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && !field.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isValidGetter(ExecutableElement getter) {
        if (getter.getAnnotation(QueryType.class) != null) {
            return true;
        }
        return getter.getAnnotation(this.skipAnn) == null && !getter.getModifiers().contains((Object)Modifier.STATIC);
    }

    public void setNamePrefix(String namePrefix) {
        this.module.bind("prefix", namePrefix);
    }

    public void setUseFields(boolean b) {
        this.useFields = b;
    }

    public void setUseGetters(boolean b) {
        this.useGetters = b;
    }

    @Override
    public TypeMappings getTypeMappings() {
        return this.module.get(TypeMappings.class);
    }

    @Override
    public Collection<String> getKeywords() {
        return this.module.get(Collection.class, "keywords");
    }

    @Override
    public String getNameSuffix() {
        return this.module.get(String.class, "suffix");
    }

    public void setNameSuffix(String nameSuffix) {
        this.module.bind("suffix", nameSuffix);
    }

    public <T> void addCustomType(Class<T> type, Class<? extends Expression<T>> queryType) {
        this.module.get(TypeMappings.class).register(new ClassType(type, new Type[0]), new ClassType(queryType, new Type[0]));
    }

    @Override
    public QueryTypeFactory getQueryTypeFactory() {
        return this.module.get(QueryTypeFactory.class);
    }

    @Override
    public boolean isExcludedPackage(String packageName) {
        if (!this.includedPackages.isEmpty()) {
            boolean included = false;
            for (String includedPackage : this.includedPackages) {
                if (!packageName.startsWith(includedPackage)) continue;
                included = true;
                break;
            }
            if (!included) {
                return true;
            }
        }
        if (!this.excludedPackages.isEmpty()) {
            for (String excludedPackage : this.excludedPackages) {
                if (!packageName.startsWith(excludedPackage)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isExcludedClass(String className) {
        if (!this.includedClasses.isEmpty() && !this.includedClasses.contains(className)) {
            return true;
        }
        return this.excludedClasses.contains(className);
    }

    @Override
    public TypeMirror getRealType(ExecutableElement method) {
        return null;
    }

    @Override
    public TypeMirror getRealType(VariableElement field) {
        return null;
    }

    @Override
    public boolean isUnknownAsEmbedded() {
        return this.unknownAsEmbedded;
    }

    public void setUnknownAsEmbedded(boolean unknownAsEmbedded) {
        this.unknownAsEmbedded = unknownAsEmbedded;
    }
}

