/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nosql.spring.transaction;

import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.nosql.persistence.client.NoSQLDataSource;
import br.com.anteros.nosql.persistence.dialect.NoSQLDialect;
import br.com.anteros.nosql.persistence.metadata.configuration.NoSQLPersistenceModelConfiguration;
import br.com.anteros.nosql.persistence.session.NoSQLSessionException;
import br.com.anteros.nosql.persistence.session.NoSQLSessionFactory;
import br.com.anteros.nosql.persistence.session.configuration.impl.AnterosNoSQLPersistenceConfiguration;
import br.com.anteros.nosql.spring.transaction.SpringNoSQLSessionFactoryImpl;

public class SpringNoSQLConfiguration
extends AnterosNoSQLPersistenceConfiguration {
    public SpringNoSQLConfiguration() {
    }

    public SpringNoSQLConfiguration(NoSQLDataSource dataSource) {
        super(dataSource);
    }

    public SpringNoSQLConfiguration(NoSQLPersistenceModelConfiguration modelConfiguration) {
        super(modelConfiguration);
    }

    public SpringNoSQLConfiguration(NoSQLDataSource dataSource, NoSQLPersistenceModelConfiguration modelConfiguration) {
        super(dataSource, modelConfiguration);
    }

    public NoSQLSessionFactory buildSessionFactory() throws Exception {
        this.prepareClassesToLoad();
        if (this.getSessionFactoryConfiguration().getProperty("dialect") == null) {
            throw new NoSQLSessionException("Dialeto n\u00e3o definido. N\u00e3o foi poss\u00edvel instanciar NoSQLSessionFactory.");
        }
        String dialectProperty = this.getSessionFactoryConfiguration().getProperty("dialect");
        Class<?> dialectClass = Class.forName(dialectProperty);
        if (!ReflectionUtils.isExtendsClass(NoSQLDialect.class, dialectClass)) {
            throw new NoSQLSessionException("A classe " + dialectClass.getName() + " n\u00e3o implementa a classe " + NoSQLDialect.class.getName() + ".");
        }
        this.dialect = (NoSQLDialect)dialectClass.newInstance();
        this.buildDataSource();
        SpringNoSQLSessionFactoryImpl sessionFactory = new SpringNoSQLSessionFactoryImpl(this.descriptionEntityManager, this.dataSource, this.getSessionFactoryConfiguration());
        this.loadEntities(sessionFactory.getDialect());
        return sessionFactory;
    }
}

