/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nosql.spring.transaction;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.nosql.persistence.session.NoSQLSession;
import br.com.anteros.nosql.persistence.session.NoSQLSessionFactory;
import br.com.anteros.nosql.spring.transaction.AnterosNoSQLSessionHolder;
import br.com.anteros.nosql.spring.transaction.SessionSynchronization;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class NoSQLSessionFactoryUtils {
    private static Logger LOG = LoggerProvider.getInstance().getLogger(NoSQLSessionFactoryUtils.class);

    public static NoSQLSession getSession(NoSQLSessionFactory sessionFactory) {
        return NoSQLSessionFactoryUtils.doGetSession(null, sessionFactory, SessionSynchronization.ON_ACTUAL_TRANSACTION);
    }

    public static NoSQLSession getSession(NoSQLSessionFactory sessionFactory, SessionSynchronization sessionSynchronization) {
        return NoSQLSessionFactoryUtils.doGetSession(null, sessionFactory, sessionSynchronization);
    }

    private static NoSQLSession doGetSession(String dbName, NoSQLSessionFactory sessionFactory, SessionSynchronization sessionSynchronization) {
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null!");
        return NoSQLSessionFactoryUtils.doGetSession(sessionFactory, sessionSynchronization);
    }

    private static NoSQLSession doGetSession(NoSQLSessionFactory sessionFactory, SessionSynchronization sessionSynchronization) {
        AnterosNoSQLSessionHolder sessionHolder = (AnterosNoSQLSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null && (sessionHolder.hasSession() || sessionHolder.isSynchronizedWithTransaction())) {
            if (!sessionHolder.hasSession()) {
                sessionHolder.setSession(sessionFactory.openSession());
            }
            return sessionHolder.getSession();
        }
        if (SessionSynchronization.ON_ACTUAL_TRANSACTION.equals((Object)sessionSynchronization)) {
            sessionHolder = new AnterosNoSQLSessionHolder(sessionFactory.openSession());
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
            return sessionHolder.getSession();
        }
        sessionHolder = new AnterosNoSQLSessionHolder(sessionFactory.openSession());
        sessionHolder.getSession().getTransaction().begin();
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new NoSQLSessionSynchronization(sessionHolder, sessionFactory));
        sessionHolder.setSynchronizedWithTransaction(true);
        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
        return sessionHolder.getSession();
    }

    public static void closeSession(NoSQLSession session) {
        if (session != null) {
            LOG.debug((Object)"Closing Anteros NoSQLSession");
            try {
                session.close();
            }
            catch (Throwable ex) {
                LOG.debug((Object)"Unexpected exception on closing Anteros NoSQLSession", ex);
            }
        }
    }

    private static class NoSQLSessionSynchronization
    extends ResourceHolderSynchronization<AnterosNoSQLSessionHolder, Object> {
        private final AnterosNoSQLSessionHolder resourceHolder;

        NoSQLSessionSynchronization(AnterosNoSQLSessionHolder resourceHolder, NoSQLSessionFactory sessionFactory) {
            super((ResourceHolder)resourceHolder, (Object)sessionFactory);
            this.resourceHolder = resourceHolder;
        }

        protected boolean shouldReleaseBeforeCompletion() {
            return false;
        }

        protected void processResourceAfterCommit(AnterosNoSQLSessionHolder resourceHolder) {
            if (this.isTransactionActive(resourceHolder)) {
                resourceHolder.getSession().commitTransaction();
            }
        }

        public void afterCompletion(int status) {
            if (status == 1 && this.isTransactionActive(this.resourceHolder)) {
                this.resourceHolder.getSession().abortTransaction();
            }
            super.afterCompletion(status);
        }

        protected void releaseResource(AnterosNoSQLSessionHolder resourceHolder, Object resourceKey) {
            if (resourceHolder.getSession().getTransaction().isActive()) {
                resourceHolder.getSession().getTransaction().close();
            }
        }

        private boolean isTransactionActive(AnterosNoSQLSessionHolder resourceHolder) {
            if (!resourceHolder.hasSession()) {
                return false;
            }
            return resourceHolder.getSession().getTransaction().isActive();
        }
    }
}

