/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nosql.spring.transaction;

import br.com.anteros.nosql.persistence.session.NoSQLSession;
import br.com.anteros.nosql.persistence.session.NoSQLSessionFactory;
import br.com.anteros.nosql.persistence.session.transaction.NoSQLTransaction;
import br.com.anteros.nosql.persistence.session.transaction.NoSQLTransactionException;
import br.com.anteros.nosql.persistence.session.transaction.NoSQLTransactionOptions;
import br.com.anteros.nosql.spring.transaction.AnterosNoSQLSessionHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationUtils;
import org.springframework.util.Assert;

public class AnterosNoSQLTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private static final long serialVersionUID = 1L;
    private NoSQLSessionFactory sessionFactory;
    private NoSQLTransactionOptions options;

    public AnterosNoSQLTransactionManager() {
    }

    public AnterosNoSQLTransactionManager(NoSQLSessionFactory sessionFactory) {
        this(sessionFactory, null);
    }

    public AnterosNoSQLTransactionManager(NoSQLSessionFactory sessionFactory, NoSQLTransactionOptions options) {
        Assert.notNull((Object)sessionFactory, (String)"NoSQLSessionFactory must not be null!");
        this.sessionFactory = sessionFactory;
        this.options = options;
    }

    protected Object doGetTransaction() throws TransactionException {
        AnterosNoSQLSessionHolder sessionHolder = (AnterosNoSQLSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
        if (sessionHolder != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found thread-bound Session [" + sessionHolder.getSession() + "] for NoSQL transaction"));
        }
        return new NoSQLTransactionObject(sessionHolder);
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        NoSQLTransactionObject txObject = AnterosNoSQLTransactionManager.extractNoSQLTransaction(transaction);
        return txObject.hasResourceHolder() && txObject.isTransactionActive();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws NoSQLTransactionException {
        NoSQLSession session;
        NoSQLTransactionObject txObject = AnterosNoSQLTransactionManager.extractNoSQLTransaction(transaction);
        if (txObject.getSessionHolder() == null || txObject.getSessionHolder().isSynchronizedWithTransaction()) {
            session = this.sessionFactory.openSession();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Opened new Session [" + session + "] for NoSQL transaction"));
            }
            txObject.setSessionHolder(new AnterosNoSQLSessionHolder(session));
        }
        session = txObject.getSessionHolder().getSession();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("About to start NoSQL transaction for session %s.", session.getTransaction().debugString()));
        }
        try {
            txObject.startTransaction(this.options);
        }
        catch (Exception ex) {
            throw new TransactionSystemException(String.format("Could not start NoSQL transaction for session %s.", txObject.getTransaction().debugString()), (Throwable)ex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Started transaction for session %s.", session.getTransaction().debugString()));
        }
        txObject.getSessionHolder().setSynchronizedWithTransaction(true);
        TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)txObject.getSessionHolder()));
    }

    protected Object doSuspend(Object transaction) throws TransactionException {
        NoSQLTransactionObject txObject = AnterosNoSQLTransactionManager.extractNoSQLTransaction(transaction);
        txObject.setSessionHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)suspendedResources);
    }

    protected void doCommit(DefaultTransactionStatus status) throws NoSQLTransactionException {
        NoSQLTransactionObject txObject = AnterosNoSQLTransactionManager.extractNoSQLTransaction(status);
        if (txObject != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("About to commit transaction for session %s.", txObject.getTransaction().debugString()));
            }
            try {
                txObject.commitTransaction();
            }
            catch (Exception ex) {
                throw new TransactionSystemException(String.format("Could not commit NoSQL transaction for session %s.", txObject.getTransaction().debugString()), (Throwable)ex);
            }
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        NoSQLTransactionObject txObject = AnterosNoSQLTransactionManager.extractNoSQLTransaction(status);
        if (txObject != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("About to abort transaction for session %s.", txObject.getTransaction().debugString()));
            }
            try {
                txObject.abortTransaction();
            }
            catch (Exception ex) {
                throw new TransactionSystemException(String.format("Could not abort NoSQL transaction for session %s.", txObject.getTransaction().debugString()), (Throwable)ex);
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        NoSQLTransactionObject txObject = AnterosNoSQLTransactionManager.extractNoSQLTransaction(status);
        txObject.getRequiredSessionHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        Assert.isInstanceOf(NoSQLTransactionObject.class, (Object)transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", NoSQLTransactionObject.class, transaction.getClass()));
        NoSQLTransactionObject txObject = (NoSQLTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        txObject.getRequiredSessionHolder().clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("About to release Session %s after transaction.", txObject.getTransaction().debugString()));
        }
        txObject.close();
    }

    public void setSessionFactory(NoSQLSessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null!");
        this.sessionFactory = sessionFactory;
    }

    public void setOptions(NoSQLTransactionOptions options) {
        this.options = options;
    }

    public void afterPropertiesSet() {
        this.getSessionFactory();
    }

    private NoSQLSessionFactory getSessionFactory() {
        Assert.state((this.sessionFactory != null ? 1 : 0) != 0, (String)"AnterosNoSQLTransactionManager operates upon a NoSQLSession. Did you forget to provide one? It's required.");
        return this.sessionFactory;
    }

    private static NoSQLTransactionObject extractNoSQLTransaction(Object transaction) {
        Assert.isInstanceOf(NoSQLTransactionObject.class, (Object)transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", NoSQLTransactionObject.class, transaction.getClass()));
        return (NoSQLTransactionObject)transaction;
    }

    private static NoSQLTransactionObject extractNoSQLTransaction(DefaultTransactionStatus status) {
        Assert.isInstanceOf(NoSQLTransactionObject.class, (Object)status.getTransaction(), () -> String.format("Expected to find a %s but it turned out to be %s.", NoSQLTransactionObject.class, status.getTransaction().getClass()));
        return (NoSQLTransactionObject)status.getTransaction();
    }

    public Object getResourceFactory() {
        return this.getSessionFactory();
    }

    static class NoSQLTransactionObject
    implements SmartTransactionObject {
        private AnterosNoSQLSessionHolder sessionHolder;

        NoSQLTransactionObject(AnterosNoSQLSessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
        }

        void setSessionHolder(AnterosNoSQLSessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
        }

        boolean hasResourceHolder() {
            return this.sessionHolder != null;
        }

        boolean isTransactionActive() {
            return this.sessionHolder.getSession().getTransaction().isActive();
        }

        void startTransaction(NoSQLTransactionOptions options) {
            NoSQLTransaction transaction = this.sessionHolder.getSession().getTransaction();
            if (options != null) {
                transaction.begin(options);
            } else {
                transaction.begin();
            }
        }

        void commitTransaction() throws Exception {
            this.getRequiredTransaction().commit();
        }

        void abortTransaction() {
            this.getRequiredTransaction().rollback();
        }

        void close() {
            NoSQLTransaction transaction = this.getRequiredTransaction();
            transaction.close();
        }

        NoSQLTransaction getTransaction() {
            return this.sessionHolder != null ? this.sessionHolder.getSession().getTransaction() : null;
        }

        AnterosNoSQLSessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        private AnterosNoSQLSessionHolder getRequiredSessionHolder() {
            Assert.state((this.sessionHolder != null ? 1 : 0) != 0, (String)"AnterosNoSQLSessionHolder is required but not present. o_O");
            return this.sessionHolder;
        }

        private NoSQLTransaction getRequiredTransaction() {
            NoSQLTransaction session = this.getTransaction();
            Assert.state((session != null ? 1 : 0) != 0, (String)"A Transaction is required but it turned out to be null.");
            return session;
        }

        public boolean isRollbackOnly() {
            return this.sessionHolder != null && this.sessionHolder.isRollbackOnly();
        }

        public void flush() {
            TransactionSynchronizationUtils.triggerFlush();
        }
    }
}

