/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nosql.spring.config;

import java.util.Properties;

public class NoSQLDataSourceConfiguration {
    private String host;
    private Integer port;
    private String username;
    private String password;
    private String databaseName;

    private NoSQLDataSourceConfiguration() {
    }

    public static NoSQLDataSourceConfiguration create() {
        return new NoSQLDataSourceConfiguration();
    }

    public static NoSQLDataSourceConfiguration of(String host, Integer port, String username, String password, String databaseName) {
        return new NoSQLDataSourceConfiguration().host(host).port(port).userName(username).password(password).databaseName(databaseName);
    }

    public String getUserName() {
        if (this.username == null) {
            return "";
        }
        return this.username;
    }

    public NoSQLDataSourceConfiguration userName(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public NoSQLDataSourceConfiguration password(String password) {
        this.password = password;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public NoSQLDataSourceConfiguration host(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public NoSQLDataSourceConfiguration port(Integer port) {
        this.port = port;
        return this;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public NoSQLDataSourceConfiguration databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public Properties getProperties() {
        Properties result = new Properties();
        result.put("host", this.getHost());
        result.put("password", this.getPassword());
        result.put("port", this.getPort() + "");
        result.put("username", this.getUserName());
        result.put("databaseName", this.getDatabaseName());
        return result;
    }
}

