/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nosql.spring.config;

import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.nosql.persistence.client.NoSQLDataSource;
import br.com.anteros.nosql.persistence.dialect.NoSQLDialect;
import br.com.anteros.nosql.persistence.session.NoSQLSessionException;
import br.com.anteros.nosql.persistence.session.NoSQLSessionFactory;
import br.com.anteros.nosql.persistence.session.ShowCommandsType;
import br.com.anteros.nosql.spring.config.NoSQLDataSourceConfiguration;
import br.com.anteros.nosql.spring.config.NoSQLSessionFactoryConfiguration;
import br.com.anteros.nosql.spring.transaction.SpringNoSQLConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement
@Configuration
public abstract class AbstractSpringSecurityNoSQLPersistenceConfiguration {
    protected NoSQLSessionFactory sessionFactory;
    protected NoSQLDataSource dataSource;

    public abstract NoSQLDataSourceConfiguration getDataSourceConfiguration();

    public abstract NoSQLSessionFactoryConfiguration getSessionFactoryConfiguration();

    @Bean
    public NoSQLSessionFactory securitySessionFactory() throws Exception {
        if (this.sessionFactory != null) {
            return this.sessionFactory;
        }
        NoSQLSessionFactoryConfiguration sessionFactoryConfiguration = this.getSessionFactoryConfiguration();
        if (sessionFactoryConfiguration != null) {
            SpringNoSQLConfiguration configuration = new SpringNoSQLConfiguration(this.dataSourceNoSQL());
            for (Class<?> sourceClass : sessionFactoryConfiguration.getEntitySourceClasses()) {
                configuration.addAnnotatedClass(sourceClass);
            }
            configuration.withoutTransactionControl(sessionFactoryConfiguration.getWithoutTransactionControl());
            configuration.getSessionFactoryConfiguration().setPackageToScanEntity(sessionFactoryConfiguration.getPackageScanEntity());
            configuration.getSessionFactoryConfiguration().setIncludeSecurityModel(sessionFactoryConfiguration.isIncludeSecurityModel());
            configuration.addProperty("dialect", sessionFactoryConfiguration.getDialect());
            configuration.addProperty("showCommands", ShowCommandsType.parse((ShowCommandsType[])sessionFactoryConfiguration.getShowCommands()));
            configuration.addProperty("formatCommands", String.valueOf(sessionFactoryConfiguration.isFormatCommands()));
            configuration.addProperty("databaseName", sessionFactoryConfiguration.getDatabaseName());
            configuration.addProperty("use-bean-validation", sessionFactoryConfiguration.getUseBeanValidation() + "");
            this.sessionFactory = configuration.buildSessionFactory();
        }
        return this.sessionFactory;
    }

    @Bean
    public NoSQLDataSource dataSourceNoSQL() throws Exception {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        NoSQLSessionFactoryConfiguration sqlSessionFactoryConfiguration = this.getSessionFactoryConfiguration();
        NoSQLDataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        if (dataSourceConfiguration != null && sqlSessionFactoryConfiguration != null) {
            String dialectProperty = sqlSessionFactoryConfiguration.getDialect();
            Class<?> dialectClass = Class.forName(dialectProperty);
            if (!ReflectionUtils.isExtendsClass(NoSQLDialect.class, dialectClass)) {
                throw new NoSQLSessionException("A classe " + dialectClass.getName() + " n\u00e3o implementa a classe " + NoSQLDialect.class.getName() + ".");
            }
            NoSQLDialect dialect = (NoSQLDialect)dialectClass.newInstance();
            this.dataSource = dialect.getDataSourceBuilder().configure(dataSourceConfiguration.getProperties()).build();
        }
        return this.dataSource;
    }
}

