/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nosql.security.domain;

import br.com.anteros.nosql.persistence.metadata.annotations.Cascade;
import br.com.anteros.nosql.persistence.metadata.annotations.Entity;
import br.com.anteros.nosql.persistence.metadata.annotations.Id;
import br.com.anteros.nosql.persistence.metadata.annotations.Index;
import br.com.anteros.nosql.persistence.metadata.annotations.IndexField;
import br.com.anteros.nosql.persistence.metadata.annotations.IndexOptions;
import br.com.anteros.nosql.persistence.metadata.annotations.Indexes;
import br.com.anteros.nosql.persistence.metadata.annotations.Property;
import br.com.anteros.nosql.persistence.metadata.annotations.Reference;
import br.com.anteros.nosql.persistence.metadata.annotations.type.CascadeType;
import br.com.anteros.nosql.security.domain.System;
import br.com.anteros.security.store.domain.IAction;
import br.com.anteros.security.store.domain.IResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Entity(value="SEGURANCARECURSO")
@Indexes(value={@Index(name="UK_SEGURANCARECURSO_NOME_RECUR", options=@IndexOptions(unique=true), fields={@IndexField(value="sistema"), @IndexField(value="nomeRecurso")})})
public class Resource
implements Serializable,
IResource {
    @Id
    private String id;
    @Property(value="nomeRecurso")
    private String nome;
    @Property(value="descricaoRecurso")
    private String descricao;
    @Reference(mappedBy="recurso", lazy=true)
    @Cascade(values={CascadeType.DELETE_ORPHAN})
    private List<IAction> acoes;
    @Reference(lazy=true, value="sistema")
    private System sistema;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResourceName() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public List<IAction> getActionList() {
        if (this.acoes == null) {
            this.acoes = new ArrayList<IAction>();
        }
        return this.acoes;
    }

    public void setAcoes(List<IAction> acoes) {
        this.acoes = acoes;
    }

    public System getSystem() {
        return this.sistema;
    }

    public void setSistema(System sistema) {
        this.sistema = sistema;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.descricao == null ? 0 : this.descricao.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.nome == null ? 0 : this.nome.hashCode());
        result = 31 * result + (this.sistema == null ? 0 : this.sistema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.descricao == null ? other.descricao != null : !this.descricao.equals(other.descricao)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.nome == null ? other.nome != null : !this.nome.equals(other.nome)) {
            return false;
        }
        return !(this.sistema == null ? other.sistema != null : !this.sistema.equals(other.sistema));
    }

    public IResource addAction(IAction action) {
        this.getActionList().add(action);
        return this;
    }

    public String getResourceId() {
        return this.id;
    }
}

