/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nosql.security.domain;

import br.com.anteros.nosql.persistence.metadata.annotations.DiscriminatorValue;
import br.com.anteros.nosql.persistence.metadata.annotations.Entity;
import br.com.anteros.nosql.persistence.metadata.annotations.Property;
import br.com.anteros.nosql.persistence.metadata.annotations.Reference;
import br.com.anteros.nosql.persistence.metadata.annotations.Transient;
import br.com.anteros.nosql.security.domain.AccessTime;
import br.com.anteros.nosql.security.domain.Group;
import br.com.anteros.nosql.security.domain.Profile;
import br.com.anteros.nosql.security.domain.Security;
import br.com.anteros.security.store.domain.IProfile;
import br.com.anteros.security.store.domain.IUser;
import java.util.List;

@Entity(value="SEGURANCA")
@DiscriminatorValue(value="USUARIO")
public class User
extends Security
implements IUser {
    @Property(value="login")
    private String login;
    @Property(value="senha")
    private String senha;
    @Property(value="alterarSenhaProximoLogin", required=true, defaultValue="false")
    private Boolean alterarSenhaProximoLogin;
    @Property(value="permiteAlterarSenha", required=true, defaultValue="false")
    private Boolean permiteAlterarSenha;
    @Property(value="permiteMultiplosLogins", required=true, defaultValue="false")
    private Boolean permiteMultiplosLogins;
    @Property(value="senhaNuncaExpira", required=true, defaultValue="false")
    private Boolean senhaNuncaExpira;
    @Property(value="contaDesativada", required=true, defaultValue="false")
    private Boolean contaDesativada = Boolean.FALSE;
    @Property(value="contaBloqueada", required=true, defaultValue="false")
    private Boolean contaBloqueada = Boolean.FALSE;
    @Property(value="boHorarioLivre", required=true, defaultValue="false")
    private Boolean boHorarioLivre;
    @Property(value="boAdministrador", required=true, defaultValue="false")
    private Boolean boAdministrador;
    @Reference(lazy=true, value="horarioAcesso")
    private AccessTime horarioAcesso;
    @Reference(lazy=true, value="grupos")
    private List<Group> grupos;
    @Reference(lazy=true, value="perfil")
    private Profile perfil;

    public Boolean getAlterarSenhaProximoLogin() {
        return this.alterarSenhaProximoLogin;
    }

    public void setAlterarSenhaProximoLogin(Boolean alterarSenhaProximoLogin) {
        this.alterarSenhaProximoLogin = alterarSenhaProximoLogin;
    }

    public Boolean getPermiteAlterarSenha() {
        return this.permiteAlterarSenha;
    }

    public void setPermiteAlterarSenha(Boolean permiteAlterarSenha) {
        this.permiteAlterarSenha = permiteAlterarSenha;
    }

    public Boolean getSenhaNuncaExpira() {
        return this.senhaNuncaExpira;
    }

    public void setSenhaNuncaExpira(Boolean senhaNuncaExpira) {
        this.senhaNuncaExpira = senhaNuncaExpira;
    }

    public boolean isInactiveAccount() {
        return this.contaDesativada;
    }

    public void setContaDesativada(Boolean contaDesativada) {
        this.contaDesativada = contaDesativada;
    }

    public boolean isBlockedAccount() {
        return this.contaBloqueada;
    }

    public void setContaBloqueada(Boolean contaBloqueada) {
        this.contaBloqueada = contaBloqueada;
    }

    public Boolean getPermiteMultiplosLogins() {
        return this.permiteMultiplosLogins;
    }

    public void setPermiteMultiplosLogins(Boolean permiteMultiplosLogins) {
        this.permiteMultiplosLogins = permiteMultiplosLogins;
    }

    public String getPassword() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public List<Group> getGrupos() {
        return this.grupos;
    }

    public void setGrupos(List<Group> grupos) {
        this.grupos = grupos;
    }

    public Profile getProfile() {
        return this.perfil;
    }

    public void setPerfil(Profile perfil) {
        this.perfil = perfil;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Transient
    public boolean isExpired() {
        return this.contaBloqueada != false || this.contaDesativada != false;
    }

    public Boolean getBoHorarioLivre() {
        return this.boHorarioLivre;
    }

    public void setBoHorarioLivre(Boolean boHorarioLivre) {
        this.boHorarioLivre = boHorarioLivre;
    }

    public boolean isAdministrator() {
        return this.boAdministrador;
    }

    public void setBoAdministrador(Boolean boAdministrador) {
        this.boAdministrador = boAdministrador;
    }

    public AccessTime getHorarioAcesso() {
        return this.horarioAcesso;
    }

    public void setHorarioAcesso(AccessTime horarioAcesso) {
        this.horarioAcesso = horarioAcesso;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.login == null ? other.login != null : !this.login.equals(other.login));
    }

    public boolean isPasswordNeverExpire() {
        return false;
    }

    public IProfile getUserProfile() {
        return null;
    }
}

