/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.webdav;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.exception.NextcloudApiException;
import br.com.anteros.nextcloud.api.webdav.AWebdavHandler;
import br.com.anteros.nextcloud.api.webdav.FolderItemDetail;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Folders
extends AWebdavHandler {
    private static final Log LOG = LogFactory.getLog(Folders.class);

    public Folders(ServerConfig serverConfig) {
        super(serverConfig);
    }

    @Deprecated
    public List<String> getFolders(String remotePath) {
        return this.listFolderContent(remotePath);
    }

    public List<String> listFolderContent(String remotePath) {
        return this.listFolderContent(remotePath, 1);
    }

    public List<String> listFolderContent(String remotePath, int depth) {
        List resources;
        String path = this.buildWebdavPath(remotePath);
        LinkedList<String> retVal = new LinkedList<String>();
        Sardine sardine = this.buildAuthSardine();
        try {
            resources = sardine.list(path, depth);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn((Object)"error in closing sardine connector", (Throwable)ex);
            }
        }
        for (DavResource res : resources) {
            if (res.getPath().endsWith(remotePath)) continue;
            retVal.add(res.getName());
        }
        Collections.sort(retVal);
        return retVal;
    }

    public boolean exists(String remotePath) {
        return this.pathExists(remotePath);
    }

    public void createFolder(String remotePath) {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        try {
            sardine.createDirectory(path);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn((Object)"error in closing sardine connector", (Throwable)ex);
            }
        }
    }

    public void deleteFolder(String remotePath) {
        this.deletePath(remotePath);
    }

    public List<String> listFolderContent(String remotePath, int depth, boolean excludeFolderNames) {
        List resources;
        String path = this.buildWebdavPath(remotePath);
        LinkedList<String> retVal = new LinkedList<String>();
        Sardine sardine = this.buildAuthSardine();
        try {
            resources = sardine.list(path, depth);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn((Object)"error in closing sardine connector", (Throwable)ex);
            }
        }
        for (DavResource res : resources) {
            if (excludeFolderNames) {
                if (res.isDirectory()) continue;
                retVal.add(res.getName());
                continue;
            }
            retVal.add(res.getName());
        }
        return retVal;
    }

    public List<FolderItemDetail> listDetailsFolderContent(String remotePath, int depth, boolean excludeFolderNames) {
        List resources;
        String path = this.buildWebdavPath(remotePath);
        LinkedList<FolderItemDetail> retVal = new LinkedList<FolderItemDetail>();
        Sardine sardine = this.buildAuthSardine();
        try {
            resources = sardine.list(path, depth);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn((Object)"error in closing sardine connector", (Throwable)ex);
            }
        }
        for (DavResource res : resources) {
            FolderItemDetail detail = new FolderItemDetail();
            detail.setContentLength(res.getContentLength());
            detail.setContentType(res.getContentType());
            detail.setCreation(res.getCreation());
            detail.setModified(res.getModified());
            detail.setDisplayName(res.getDisplayName());
            detail.setDirectory(res.isDirectory());
            detail.setPath(res.getPath());
            detail.setName(res.getName());
            if (excludeFolderNames) {
                if (res.isDirectory()) continue;
                retVal.add(detail);
                continue;
            }
            retVal.add(detail);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFolder(String remotePath, String rootDownloadDirPath) throws IOException {
        int depth = 1;
        String rootPath = this.buildWebdavPath("");
        String[] segments = remotePath.split("/");
        String folderName = segments[segments.length - 1];
        String newDownloadDir = rootDownloadDirPath + "/" + folderName;
        File nefile1 = new File(newDownloadDir);
        if (!nefile1.exists()) {
            LOG.info((Object)("Creating new download directory: " + newDownloadDir));
            nefile1.mkdir();
        }
        String rootPathNew = rootPath + remotePath;
        int count = 0;
        LinkedList<String> retVal = new LinkedList<String>();
        Sardine sardine = this.buildAuthSardine();
        try {
            List resources;
            try {
                resources = sardine.list(rootPathNew, depth);
            }
            catch (IOException e) {
                throw new NextcloudApiException(e);
            }
            for (DavResource res : resources) {
                System.out.println(res.getName());
                if (count != 0) {
                    String fileName;
                    if (res.isDirectory()) {
                        fileName = res.getName();
                        String pathtosend = remotePath + "/" + fileName;
                        this.downloadFolder(pathtosend, newDownloadDir);
                    } else {
                        fileName = res.getName();
                        String filePath = rootPathNew + "/" + fileName;
                        retVal.add(res.getName());
                        InputStream in = null;
                        if (sardine.exists(filePath)) {
                            in = sardine.get(filePath);
                            byte[] buffer = new byte[4096];
                            File targetFile = new File(newDownloadDir + "/" + fileName);
                            try (FileOutputStream outStream = new FileOutputStream(targetFile);){
                                int bytesRead;
                                while ((bytesRead = in.read(buffer)) != -1) {
                                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                                }
                                outStream.flush();
                                ((OutputStream)outStream).close();
                                in.close();
                            }
                        }
                    }
                }
                ++count;
            }
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn((Object)"error in closing sardine connector", (Throwable)ex);
            }
        }
    }
}

