/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.webdav;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.exception.NextcloudApiException;
import br.com.anteros.nextcloud.api.webdav.AWebdavHandler;
import com.github.sardine.Sardine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Files
extends AWebdavHandler {
    public Files(ServerConfig serverConfig) {
        super(serverConfig);
    }

    public boolean fileExists(String remotePath) {
        return this.pathExists(remotePath);
    }

    public void uploadFile(InputStream inputStream, String remotePath) {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        try {
            sardine.put(path, inputStream);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
    }

    public void removeFile(String remotePath) {
        this.deletePath(remotePath);
    }

    public boolean downloadFile(String remotePath, String downloadDirPath) throws IOException {
        boolean status = false;
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        File downloadFilepath = new File(downloadDirPath);
        if (!downloadFilepath.exists()) {
            downloadFilepath.mkdir();
        }
        if (this.fileExists(remotePath)) {
            String[] segments = path.split("/");
            String filename = segments[segments.length - 1];
            downloadDirPath = downloadDirPath + "/" + filename;
        }
        InputStream in = null;
        try {
            in = sardine.get(path);
            byte[] buffer = new byte[4096];
            File targetFile = new File(downloadDirPath);
            try (FileOutputStream outStream = new FileOutputStream(targetFile);){
                int bytesRead;
                while ((bytesRead = in.read(buffer)) != -1) {
                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                }
                outStream.flush();
                ((OutputStream)outStream).close();
            }
            status = true;
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            sardine.shutdown();
            if (in != null) {
                in.close();
            }
        }
        return status;
    }
}

