/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.webdav;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.exception.NextcloudApiException;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;

public abstract class AWebdavHandler {
    private static final Log LOG = LogFactory.getLog(AWebdavHandler.class);
    public static final int FILE_BUFFER_SIZE = 4096;
    private static final String WEB_DAV_BASE_PATH = "remote.php/webdav/";
    private final ServerConfig _serverConfig;

    public AWebdavHandler(ServerConfig serverConfig) {
        this._serverConfig = serverConfig;
    }

    protected String buildWebdavPath(String remotePath) {
        URIBuilder uB = new URIBuilder().setScheme(this._serverConfig.isUseHTTPS() ? "https" : "http").setHost(this._serverConfig.getServerName()).setPath(WEB_DAV_BASE_PATH + remotePath);
        if (this._serverConfig.getPort() > 0) {
            uB.setPort(this._serverConfig.getPort());
        }
        return uB.toString();
    }

    protected Sardine buildAuthSardine() {
        Sardine sardine = SardineFactory.begin();
        sardine.setCredentials(this._serverConfig.getUserName(), this._serverConfig.getPassword());
        sardine.enablePreemptiveAuthentication(this._serverConfig.getServerName());
        return sardine;
    }

    public boolean pathExists(String remotePath) {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        try {
            boolean bl = sardine.exists(path);
            return bl;
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn((Object)"error in closing sardine connector", (Throwable)ex);
            }
        }
    }

    public void deletePath(String remotePath) {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        try {
            sardine.delete(path);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn((Object)"error in closing sardine connector", (Throwable)ex);
            }
        }
    }
}

