/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.utils;

import br.com.anteros.nextcloud.api.exception.NextcloudApiException;
import br.com.anteros.nextcloud.api.exception.NextcloudOperationFailedException;
import br.com.anteros.nextcloud.api.utils.XMLAnswer;
import java.util.concurrent.CompletableFuture;

public class NextcloudResponseHelper {
    public static final int NC_OK = 100;

    private NextcloudResponseHelper() {
    }

    public static <A extends XMLAnswer> A getAndCheckStatus(CompletableFuture<A> answer) {
        XMLAnswer xmlanswer = (XMLAnswer)NextcloudResponseHelper.getAndWrapException(answer);
        if (NextcloudResponseHelper.isStatusCodeOkay(xmlanswer)) {
            return (A)xmlanswer;
        }
        throw new NextcloudOperationFailedException(xmlanswer.getStatusCode(), xmlanswer.getMessage());
    }

    public static <A extends XMLAnswer> boolean isStatusCodeOkay(CompletableFuture<A> answer) {
        return NextcloudResponseHelper.isStatusCodeOkay((XMLAnswer)NextcloudResponseHelper.getAndWrapException(answer));
    }

    public static boolean isStatusCodeOkay(XMLAnswer answer) {
        return answer.getStatusCode() == 100;
    }

    public static <A> A getAndWrapException(CompletableFuture<A> answer) {
        try {
            return answer.get();
        }
        catch (Exception e) {
            throw new NextcloudApiException(e);
        }
    }
}

