/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.utils;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.exception.NextcloudApiException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.protocol.HttpContext;

public class ConnectorCommon {
    private final ServerConfig serverConfig;

    public ConnectorCommon(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public <R> CompletableFuture<R> executeGet(String part, List<NameValuePair> queryParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part, queryParams);
            HttpGet request = new HttpGet(url.toString());
            return this.executeRequest(parser, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
    }

    public <R> CompletableFuture<R> executePost(String part, List<NameValuePair> postParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part, postParams);
            HttpPost request = new HttpPost(url.toString());
            return this.executeRequest(parser, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
    }

    public <R> CompletableFuture<R> executePut(String part1, String part2, List<NameValuePair> putParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part1 + "/" + part2, putParams);
            HttpPut request = new HttpPut(url.toString());
            return this.executeRequest(parser, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
    }

    public <R> CompletableFuture<R> executeDelete(String part1, String part2, List<NameValuePair> deleteParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part1 + "/" + part2, deleteParams);
            HttpDelete request = new HttpDelete(url.toString());
            return this.executeRequest(parser, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
    }

    private URI buildUrl(String subPath, List<NameValuePair> queryParams) {
        URIBuilder uB = new URIBuilder().setScheme(this.serverConfig.isUseHTTPS() ? "https" : "http").setHost(this.serverConfig.getServerName()).setUserInfo(this.serverConfig.getUserName(), this.serverConfig.getPassword()).setPath(subPath);
        if (queryParams != null) {
            uB.addParameters(queryParams);
        }
        try {
            return uB.build();
        }
        catch (URISyntaxException e) {
            throw new NextcloudApiException(e);
        }
    }

    private <R> CompletableFuture<R> executeRequest(ResponseParser<R> parser, HttpRequestBase request) throws IOException, ClientProtocolException {
        request.addHeader("OCS-APIRequest", "true");
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpClientContext context = this.prepareContext();
        CompletableFuture futureResponse = new CompletableFuture();
        HttpAsyncClientSingleton.HTTPC_CLIENT.execute((HttpUriRequest)request, (HttpContext)context, new ResponseCallback(parser, futureResponse));
        return futureResponse;
    }

    private HttpClientContext prepareContext() {
        HttpHost targetHost = new HttpHost(this.serverConfig.getServerName(), this.serverConfig.getPort(), this.serverConfig.isUseHTTPS() ? "https" : "http");
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(targetHost, (AuthScheme)new BasicScheme());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.serverConfig.getUserName(), this.serverConfig.getPassword());
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }

    public static interface ResponseParser<R> {
        public R parseResponse(Reader var1);
    }

    private static class HttpAsyncClientSingleton {
        private static final CloseableHttpAsyncClient HTTPC_CLIENT = HttpAsyncClients.createDefault();

        private HttpAsyncClientSingleton() {
        }

        static {
            HTTPC_CLIENT.start();
        }
    }

    private final class ResponseCallback<R>
    implements FutureCallback<HttpResponse> {
        private final ResponseParser<R> parser;
        private final CompletableFuture<R> futureResponse;

        private ResponseCallback(ResponseParser<R> parser, CompletableFuture<R> futureResponse) {
            this.parser = parser;
            this.futureResponse = futureResponse;
        }

        public void completed(HttpResponse response) {
            try {
                R result = this.handleResponse(this.parser, response);
                this.futureResponse.complete(result);
            }
            catch (Exception ex) {
                this.futureResponse.completeExceptionally(ex);
            }
        }

        private R handleResponse(ResponseParser<R> parser, HttpResponse response) throws IOException {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    Charset charset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                    InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);
                    return parser.parseResponse(reader);
                }
                throw new NextcloudApiException("Empty response received");
            }
            throw new NextcloudApiException(String.format("Request failed with %d %s", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
        }

        public void failed(Exception ex) {
            this.futureResponse.completeExceptionally(ex);
        }

        public void cancelled() {
            this.futureResponse.cancel(true);
        }
    }
}

