/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.provisioning;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.provisioning.GroupsXMLAnswer;
import br.com.anteros.nextcloud.api.provisioning.User;
import br.com.anteros.nextcloud.api.provisioning.UserData;
import br.com.anteros.nextcloud.api.provisioning.UserXMLAnswer;
import br.com.anteros.nextcloud.api.provisioning.UsersXMLAnswer;
import br.com.anteros.nextcloud.api.utils.ConnectorCommon;
import br.com.anteros.nextcloud.api.utils.ListXMLAnswer;
import br.com.anteros.nextcloud.api.utils.NextcloudResponseHelper;
import br.com.anteros.nextcloud.api.utils.XMLAnswer;
import br.com.anteros.nextcloud.api.utils.XMLAnswerParser;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ProvisionConnector {
    private static final String ROOT_PART = "ocs/v1.php/cloud/";
    private static final String USERS_PART = "ocs/v1.php/cloud/users";
    private static final String GROUPS_PART = "ocs/v1.php/cloud/groups";
    private final ConnectorCommon connectorCommon;

    public ProvisionConnector(ServerConfig serverConfig) {
        this.connectorCommon = new ConnectorCommon(serverConfig);
    }

    public boolean createUser(String userId, String password) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.createUserAsync(userId, password));
    }

    public CompletableFuture<XMLAnswer> createUserAsync(String userId, String password) {
        LinkedList<NameValuePair> postParams = new LinkedList<NameValuePair>();
        postParams.add((NameValuePair)new BasicNameValuePair("userid", userId));
        postParams.add((NameValuePair)new BasicNameValuePair("password", password));
        return this.connectorCommon.executePost(USERS_PART, postParams, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public boolean deleteUser(String userId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.deleteUserAsync(userId));
    }

    public CompletableFuture<XMLAnswer> deleteUserAsync(String userId) {
        return this.connectorCommon.executeDelete(USERS_PART, userId, null, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public List<String> getUsers() {
        return this.getUsers(null, -1, -1);
    }

    public CompletableFuture<UsersXMLAnswer> getUsersAsync() {
        return this.getUsersAsync(null, -1, -1);
    }

    public List<String> getUsers(String search, int limit, int offset) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getUsersAsync(search, limit, offset)).getUsers();
    }

    public CompletableFuture<UsersXMLAnswer> getUsersAsync(String search, int limit, int offset) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        if (limit != -1) {
            queryParams.add((NameValuePair)new BasicNameValuePair("limit", Integer.toString(limit)));
        }
        if (offset != -1) {
            queryParams.add((NameValuePair)new BasicNameValuePair("offset", Integer.toString(offset)));
        }
        if (search != null) {
            queryParams.add((NameValuePair)new BasicNameValuePair("search", search));
        }
        return this.connectorCommon.executeGet(USERS_PART, queryParams, XMLAnswerParser.getInstance(UsersXMLAnswer.class));
    }

    public User getUser(String userId) {
        return NextcloudResponseHelper.getAndWrapException(this.getUserAsync(userId)).getUser();
    }

    public CompletableFuture<UserXMLAnswer> getUserAsync(String userId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/users/" + userId, Collections.emptyList(), XMLAnswerParser.getInstance(UserXMLAnswer.class));
    }

    public boolean editUser(String userId, UserData key, String value) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.editUserAsync(userId, key, value));
    }

    public CompletableFuture<XMLAnswer> editUserAsync(String userId, UserData key, String value) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        queryParams.add((NameValuePair)new BasicNameValuePair("key", key.name().toLowerCase()));
        queryParams.add((NameValuePair)new BasicNameValuePair("value", value));
        return this.connectorCommon.executePut(USERS_PART, userId, queryParams, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public boolean enableUser(String userId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.enableUserAsync(userId));
    }

    public CompletableFuture<XMLAnswer> enableUserAsync(String userId) {
        return this.connectorCommon.executePut(USERS_PART, userId + "/enable", null, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public boolean disableUser(String userId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.disableUserAsync(userId));
    }

    public CompletableFuture<XMLAnswer> disableUserAsync(String userId) {
        return this.connectorCommon.executePut(USERS_PART, userId + "/disable", null, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public List<String> getGroupsOfUser(String userId) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getGroupsOfUserAsync(userId)).getGroups();
    }

    public CompletableFuture<GroupsXMLAnswer> getGroupsOfUserAsync(String userId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/users/" + userId + "/groups", null, XMLAnswerParser.getInstance(GroupsXMLAnswer.class));
    }

    public boolean addUserToGroup(String userId, String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.addUserToGroupAsync(userId, groupId));
    }

    public CompletableFuture<XMLAnswer> addUserToGroupAsync(String userId, String groupId) {
        List<BasicNameValuePair> queryParams = Collections.singletonList(new BasicNameValuePair("groupid", groupId));
        return this.connectorCommon.executePost("ocs/v1.php/cloud/users/" + userId + "/groups", queryParams, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public boolean removeUserFromGroup(String userId, String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.removeUserFromGroupAsync(userId, groupId));
    }

    public CompletableFuture<XMLAnswer> removeUserFromGroupAsync(String userId, String groupId) {
        List<BasicNameValuePair> queryParams = Collections.singletonList(new BasicNameValuePair("groupid", groupId));
        return this.connectorCommon.executeDelete(USERS_PART, userId + "/groups", queryParams, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public List<String> getSubadminGroupsOfUser(String userId) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getSubadminGroupsOfUserAsync(userId)).getResult();
    }

    public CompletableFuture<ListXMLAnswer> getSubadminGroupsOfUserAsync(String userId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/users/" + userId + "/subadmins", null, XMLAnswerParser.getInstance(ListXMLAnswer.class));
    }

    public boolean promoteToSubadmin(String userId, String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.promoteToSubadminAsync(userId, groupId));
    }

    public CompletableFuture<XMLAnswer> promoteToSubadminAsync(String userId, String groupId) {
        List<BasicNameValuePair> queryParams = Collections.singletonList(new BasicNameValuePair("groupid", groupId));
        return this.connectorCommon.executePost("ocs/v1.php/cloud/users/" + userId + "/subadmins", queryParams, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public boolean demoteSubadmin(String userId, String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.demoteSubadminAsync(userId, groupId));
    }

    public CompletableFuture<XMLAnswer> demoteSubadminAsync(String userId, String groupId) {
        List<BasicNameValuePair> queryParams = Collections.singletonList(new BasicNameValuePair("groupid", groupId));
        return this.connectorCommon.executeDelete(USERS_PART, userId + "/subadmins", queryParams, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public boolean sendWelcomeMail(String userId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.sendWelcomeMailAsync(userId));
    }

    public CompletableFuture<XMLAnswer> sendWelcomeMailAsync(String userId) {
        return this.connectorCommon.executePost("ocs/v1.php/cloud/users/" + userId + "/welcome", null, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public List<String> getMembersOfGroup(String groupId) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getMembersOfGroupAsync(groupId)).getUsers();
    }

    public CompletableFuture<UsersXMLAnswer> getMembersOfGroupAsync(String groupId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/groups/" + groupId, null, XMLAnswerParser.getInstance(UsersXMLAnswer.class));
    }

    public List<String> getSubadminsOfGroup(String groupId) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getSubadminsOfGroupAsync(groupId)).getResult();
    }

    public CompletableFuture<ListXMLAnswer> getSubadminsOfGroupAsync(String groupId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/groups/" + groupId + "/subadmins", null, XMLAnswerParser.getInstance(ListXMLAnswer.class));
    }

    public boolean createGroup(String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.createGroupAsync(groupId));
    }

    public CompletableFuture<XMLAnswer> createGroupAsync(String groupId) {
        LinkedList<NameValuePair> postParams = new LinkedList<NameValuePair>();
        postParams.add((NameValuePair)new BasicNameValuePair("groupid", groupId));
        return this.connectorCommon.executePost(GROUPS_PART, postParams, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public boolean deleteGroup(String groupId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.deleteGroupAsync(groupId));
    }

    public CompletableFuture<XMLAnswer> deleteGroupAsync(String groupId) {
        return this.connectorCommon.executeDelete(GROUPS_PART, groupId, null, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public List<String> getGroups() {
        return this.getGroups(null, -1, -1);
    }

    public CompletableFuture<GroupsXMLAnswer> getGroupsAsync() {
        return this.getGroupsAsync(null, -1, -1);
    }

    public List<String> getGroups(String search, int limit, int offset) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getGroupsAsync(search, limit, offset)).getGroups();
    }

    public CompletableFuture<GroupsXMLAnswer> getGroupsAsync(String search, int limit, int offset) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        if (limit != -1) {
            queryParams.add((NameValuePair)new BasicNameValuePair("limit", Integer.toString(limit)));
        }
        if (offset != -1) {
            queryParams.add((NameValuePair)new BasicNameValuePair("offset", Integer.toString(offset)));
        }
        if (search != null) {
            queryParams.add((NameValuePair)new BasicNameValuePair("search", search));
        }
        return this.connectorCommon.executeGet(GROUPS_PART, queryParams, XMLAnswerParser.getInstance(GroupsXMLAnswer.class));
    }
}

