/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.filesharing.FilesharingConnector;
import br.com.anteros.nextcloud.api.filesharing.Share;
import br.com.anteros.nextcloud.api.filesharing.SharePermissions;
import br.com.anteros.nextcloud.api.filesharing.ShareType;
import br.com.anteros.nextcloud.api.filesharing.SharesXMLAnswer;
import br.com.anteros.nextcloud.api.filesharing.SingleShareXMLAnswer;
import br.com.anteros.nextcloud.api.provisioning.GroupsXMLAnswer;
import br.com.anteros.nextcloud.api.provisioning.ProvisionConnector;
import br.com.anteros.nextcloud.api.provisioning.ShareData;
import br.com.anteros.nextcloud.api.provisioning.User;
import br.com.anteros.nextcloud.api.provisioning.UserData;
import br.com.anteros.nextcloud.api.provisioning.UserXMLAnswer;
import br.com.anteros.nextcloud.api.provisioning.UsersXMLAnswer;
import br.com.anteros.nextcloud.api.utils.ListXMLAnswer;
import br.com.anteros.nextcloud.api.utils.XMLAnswer;
import br.com.anteros.nextcloud.api.webdav.Files;
import br.com.anteros.nextcloud.api.webdav.FolderItemDetail;
import br.com.anteros.nextcloud.api.webdav.Folders;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AnterosNextCloudConnector {
    private final ServerConfig _serverConfig;
    private final ProvisionConnector pc;
    private final FilesharingConnector fc;
    private final Folders fd;
    private final Files fl;

    public AnterosNextCloudConnector(String serverName, boolean useHTTPS, int port, String userName, String password) {
        this._serverConfig = new ServerConfig(serverName, useHTTPS, port, userName, password);
        this.pc = new ProvisionConnector(this._serverConfig);
        this.fc = new FilesharingConnector(this._serverConfig);
        this.fd = new Folders(this._serverConfig);
        this.fl = new Files(this._serverConfig);
    }

    public boolean createUser(String userId, String password) {
        return this.pc.createUser(userId, password);
    }

    public CompletableFuture<XMLAnswer> createUserAsync(String userId, String password) {
        return this.pc.createUserAsync(userId, password);
    }

    public boolean deleteUser(String userId) {
        return this.pc.deleteUser(userId);
    }

    public CompletableFuture<XMLAnswer> deleteUserAsync(String userId) {
        return this.pc.deleteUserAsync(userId);
    }

    public boolean enableUser(String userId) {
        return this.pc.enableUser(userId);
    }

    public CompletableFuture<XMLAnswer> enableUserAsync(String userId) {
        return this.pc.enableUserAsync(userId);
    }

    public boolean disableUser(String userId) {
        return this.pc.disableUser(userId);
    }

    public CompletableFuture<XMLAnswer> disableUserAsync(String userId) {
        return this.pc.disableUserAsync(userId);
    }

    public List<String> getGroupsOfUser(String userId) {
        return this.pc.getGroupsOfUser(userId);
    }

    public CompletableFuture<GroupsXMLAnswer> getGroupsOfUserAsync(String userId) {
        return this.pc.getGroupsOfUserAsync(userId);
    }

    public boolean addUserToGroup(String userId, String groupId) {
        return this.pc.addUserToGroup(userId, groupId);
    }

    public CompletableFuture<XMLAnswer> addUserToGroupAsync(String userId, String groupId) {
        return this.pc.addUserToGroupAsync(userId, groupId);
    }

    public boolean removeUserFromGroup(String userId, String groupId) {
        return this.pc.removeUserFromGroup(userId, groupId);
    }

    public CompletableFuture<XMLAnswer> removeUserFromGroupAsync(String userId, String groupId) {
        return this.pc.removeUserFromGroupAsync(userId, groupId);
    }

    public List<String> getSubadminGroupsOfUser(String userId) {
        return this.pc.getSubadminGroupsOfUser(userId);
    }

    public CompletableFuture<ListXMLAnswer> getSubadminGroupsOfUserAsync(String userId) {
        return this.pc.getSubadminGroupsOfUserAsync(userId);
    }

    public boolean promoteToSubadmin(String userId, String groupId) {
        return this.pc.promoteToSubadmin(userId, groupId);
    }

    public CompletableFuture<XMLAnswer> promoteToSubadminAsync(String userId, String groupId) {
        return this.pc.promoteToSubadminAsync(userId, groupId);
    }

    public boolean demoteSubadmin(String userId, String groupId) {
        return this.pc.demoteSubadmin(userId, groupId);
    }

    public CompletableFuture<XMLAnswer> demoteSubadminAsync(String userId, String groupId) {
        return this.pc.demoteSubadminAsync(userId, groupId);
    }

    public boolean sendWelcomeMail(String userId) {
        return this.pc.sendWelcomeMail(userId);
    }

    public CompletableFuture<XMLAnswer> sendWelcomeMailAsync(String userId) {
        return this.pc.sendWelcomeMailAsync(userId);
    }

    public List<String> getMembersOfGroup(String groupId) {
        return this.pc.getMembersOfGroup(groupId);
    }

    public CompletableFuture<UsersXMLAnswer> getMembersOfGroupAsync(String groupId) {
        return this.pc.getMembersOfGroupAsync(groupId);
    }

    public List<String> getSubadminsOfGroup(String groupId) {
        return this.pc.getSubadminsOfGroup(groupId);
    }

    public CompletableFuture<ListXMLAnswer> getSubadminsOfGroupAsync(String groupId) {
        return this.pc.getSubadminsOfGroupAsync(groupId);
    }

    public boolean createGroup(String groupId) {
        return this.pc.createGroup(groupId);
    }

    public CompletableFuture<XMLAnswer> createGroupAsync(String groupId) {
        return this.pc.createGroupAsync(groupId);
    }

    public List<String> getUsers() {
        return this.pc.getUsers();
    }

    public List<String> getUsers(String search, int limit, int offset) {
        return this.pc.getUsers(search, limit, offset);
    }

    public CompletableFuture<UsersXMLAnswer> getUsersAsync() {
        return this.pc.getUsersAsync();
    }

    public CompletableFuture<UsersXMLAnswer> getUsersAsync(String search, int limit, int offset) {
        return this.pc.getUsersAsync(search, limit, offset);
    }

    public User getUser(String userId) {
        return this.pc.getUser(userId);
    }

    public CompletableFuture<UserXMLAnswer> getUserAsync(String userId) {
        return this.pc.getUserAsync(userId);
    }

    public boolean editUser(String userId, UserData key, String value) {
        return this.pc.editUser(userId, key, value);
    }

    public CompletableFuture<XMLAnswer> editUserAsync(String userId, UserData key, String value) {
        return this.pc.editUserAsync(userId, key, value);
    }

    public boolean deleteGroup(String groupId) {
        return this.pc.deleteGroup(groupId);
    }

    public CompletableFuture<XMLAnswer> deleteGroupAsync(String groupId) {
        return this.pc.deleteGroupAsync(groupId);
    }

    public CompletableFuture<GroupsXMLAnswer> getGroupsAsync() {
        return this.pc.getGroupsAsync();
    }

    public List<String> getGroups() {
        return this.pc.getGroups();
    }

    public List<String> getGroups(String search, int limit, int offset) {
        return this.pc.getGroups(search, limit, offset);
    }

    public CompletableFuture<GroupsXMLAnswer> getGroupsAsync(String search, int limit, int offset) {
        return this.pc.getGroupsAsync(search, limit, offset);
    }

    @Deprecated
    public List<String> getFolders(String path) {
        return this.fd.getFolders(path);
    }

    public List<String> listFolderContent(String path) {
        return this.fd.listFolderContent(path);
    }

    public List<String> listFolderContent(String path, int depth) {
        return this.fd.listFolderContent(path, depth);
    }

    public List<String> listFolderContent(String path, int depth, boolean excludeFolderNames) {
        return this.fd.listFolderContent(path, depth, excludeFolderNames);
    }

    public List<FolderItemDetail> listDetailsFolderContent(String path, int depth, boolean excludeFolderNames) {
        return this.fd.listDetailsFolderContent(path, depth, excludeFolderNames);
    }

    public boolean folderExists(String path) {
        return this.fd.exists(path);
    }

    public void createFolder(String path) {
        this.fd.createFolder(path);
    }

    public void deleteFolder(String path) {
        this.fd.deleteFolder(path);
    }

    public Share doShare(String path, ShareType shareType, String shareWithUserOrGroupId, Boolean publicUpload, String password, SharePermissions permissions) {
        return this.fc.doShare(path, shareType, shareWithUserOrGroupId, publicUpload, password, permissions);
    }

    public CompletableFuture<SingleShareXMLAnswer> doShareAsync(String path, ShareType shareType, String shareWithUserOrGroupId, Boolean publicUpload, String password, SharePermissions permissions) {
        return this.fc.doShareAsync(path, shareType, shareWithUserOrGroupId, publicUpload, password, permissions);
    }

    public boolean deleteShare(int shareId) {
        return this.fc.deleteShare(shareId);
    }

    public CompletableFuture<XMLAnswer> deleteShareAsync(int shareId) {
        return this.fc.deleteShareAsync(shareId);
    }

    public List<Share> getShares() {
        return this.fc.getShares();
    }

    public CompletableFuture<SharesXMLAnswer> getSharesAsync() {
        return this.fc.getSharesAsync();
    }

    public void uploadFile(InputStream inputStream, String remotePath) {
        this.fl.uploadFile(inputStream, remotePath);
    }

    public void removeFile(String path) {
        this.fl.removeFile(path);
    }

    public boolean fileExists(String path) {
        return this.fl.fileExists(path);
    }

    public Collection<Share> getShares(String path, boolean reShares, boolean subShares) {
        return this.fc.getShares(path, reShares, subShares);
    }

    public CompletableFuture<SharesXMLAnswer> getSharesAsync(String path, boolean reShares, boolean subShares) {
        return this.fc.getSharesAsync(path, reShares, subShares);
    }

    public Share getShareInfo(int shareId) {
        return this.fc.getShareInfo(shareId);
    }

    public CompletableFuture<SharesXMLAnswer> getShareInfoAsync(int shareId) {
        return this.fc.getShareInfoAsync(shareId);
    }

    public boolean editShare(int shareId, ShareData key, String value) {
        return this.fc.editShare(shareId, key, value);
    }

    public CompletableFuture<XMLAnswer> editShareAsync(int shareId, ShareData key, String value) {
        return this.fc.editShareAsync(shareId, key, value);
    }

    public boolean editShare(int shareId, Map<ShareData, String> values) {
        return this.fc.editShare(shareId, values);
    }

    public CompletableFuture<XMLAnswer> editShareAsync(int shareId, Map<ShareData, String> values) {
        return this.fc.editShareAsync(shareId, values);
    }

    public boolean downloadFile(String remotepath, String downloadpath) throws IOException {
        return this.fl.downloadFile(remotepath, downloadpath);
    }

    public void downloadFolder(String remotepath, String downloadpath) throws IOException {
        this.fd.downloadFolder(remotepath, downloadpath);
    }
}

