/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.webdav;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.exception.NextCloudApiException;
import br.com.anteros.nextcloud.api.utils.AnterosSardineFactory;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class Folders {
    private final String WEB_DAV_BASE_PATH = "remote.php/webdav/";
    private final ServerConfig _serverConfig;

    public Folders(ServerConfig _serverConfig) {
        this._serverConfig = _serverConfig;
    }

    @Deprecated
    public List<String> getFolders(String rootPath) {
        return this.listFolderContent(rootPath);
    }

    public List<String> listFolderContent(String path) {
        return this.listFolderContent(path, 1);
    }

    public List<String> listFolderContent(String path, int depth) {
        List resources;
        String url = (this._serverConfig.isUseHTTPS() ? "https" : "http") + "://" + this._serverConfig.getServerName() + "/" + "remote.php/webdav/" + path;
        LinkedList<String> retVal = new LinkedList<String>();
        Sardine sardine = AnterosSardineFactory.begin();
        sardine.setCredentials(this._serverConfig.getUserName(), this._serverConfig.getPassword());
        try {
            resources = sardine.list(url, depth);
        }
        catch (IOException e) {
            throw new NextCloudApiException(e);
        }
        for (DavResource res : resources) {
            retVal.add(res.getName());
        }
        return retVal;
    }

    public boolean exists(String rootPath) {
        String path = (this._serverConfig.isUseHTTPS() ? "https" : "http") + "://" + this._serverConfig.getServerName() + "/" + "remote.php/webdav/" + rootPath;
        Sardine sardine = AnterosSardineFactory.begin();
        sardine.setCredentials(this._serverConfig.getUserName(), this._serverConfig.getPassword());
        try {
            return sardine.exists(path);
        }
        catch (IOException e) {
            throw new NextCloudApiException(e);
        }
    }

    public void createFolder(String rootPath) {
        String path = (this._serverConfig.isUseHTTPS() ? "https" : "http") + "://" + this._serverConfig.getServerName() + "/" + "remote.php/webdav/" + rootPath;
        Sardine sardine = AnterosSardineFactory.begin();
        sardine.setCredentials(this._serverConfig.getUserName(), this._serverConfig.getPassword());
        try {
            sardine.createDirectory(path);
        }
        catch (IOException e) {
            throw new NextCloudApiException(e);
        }
    }

    public void deleteFolder(String rootPath) {
        String path = (this._serverConfig.isUseHTTPS() ? "https" : "http") + "://" + this._serverConfig.getServerName() + "/" + "remote.php/webdav/" + rootPath;
        Sardine sardine = AnterosSardineFactory.begin();
        sardine.setCredentials(this._serverConfig.getUserName(), this._serverConfig.getPassword());
        try {
            sardine.delete(path);
        }
        catch (IOException e) {
            throw new NextCloudApiException(e);
        }
    }
}

