/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.webdav;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.exception.NextCloudApiException;
import br.com.anteros.nextcloud.api.utils.AnterosSardineFactory;
import com.github.sardine.Sardine;
import java.io.IOException;
import java.io.InputStream;

public class Files {
    private static final String WEB_DAV_BASE_PATH = "remote.php/webdav/";
    private final ServerConfig _serverConfig;

    public Files(ServerConfig _serverConfig) {
        this._serverConfig = _serverConfig;
    }

    public boolean fileExists(String rootPath) {
        String path = (this._serverConfig.isUseHTTPS() ? "https" : "http") + "://" + this._serverConfig.getServerName() + "/" + WEB_DAV_BASE_PATH + rootPath;
        Sardine sardine = AnterosSardineFactory.begin();
        sardine.setCredentials(this._serverConfig.getUserName(), this._serverConfig.getPassword());
        sardine.enablePreemptiveAuthentication(this._serverConfig.getServerName());
        try {
            return sardine.exists(path);
        }
        catch (IOException e) {
            throw new NextCloudApiException(e);
        }
    }

    public void uploadFile(InputStream inputStream, String remotePath) {
        String path = (this._serverConfig.isUseHTTPS() ? "https" : "http") + "://" + this._serverConfig.getServerName() + "/" + WEB_DAV_BASE_PATH + remotePath;
        Sardine sardine = AnterosSardineFactory.begin();
        sardine.setCredentials(this._serverConfig.getUserName(), this._serverConfig.getPassword());
        sardine.enablePreemptiveAuthentication(this._serverConfig.getServerName());
        try {
            sardine.exists(path);
            sardine.put(path, inputStream);
        }
        catch (IOException e) {
            throw new NextCloudApiException(e);
        }
    }

    public void removeFile(String rootPath) {
        String path = (this._serverConfig.isUseHTTPS() ? "https" : "http") + "://" + this._serverConfig.getServerName() + "/" + WEB_DAV_BASE_PATH + rootPath;
        Sardine sardine = AnterosSardineFactory.begin();
        sardine.setCredentials(this._serverConfig.getUserName(), this._serverConfig.getPassword());
        sardine.enablePreemptiveAuthentication(this._serverConfig.getServerName());
        try {
            sardine.delete(path);
        }
        catch (IOException e) {
            throw new NextCloudApiException(e);
        }
    }
}

