/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.utils;

import br.com.anteros.nextcloud.api.exception.NextCloudApiException;
import br.com.anteros.nextcloud.api.utils.ConnectorCommon;
import br.com.anteros.nextcloud.api.utils.XMLAnswer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class XMLAnswerParser<A extends XMLAnswer>
implements ConnectorCommon.ResponseParser<A> {
    private static final Map<String, XMLAnswerParser<? extends XMLAnswer>> PARSERS = new HashMap<String, XMLAnswerParser<? extends XMLAnswer>>();
    private final JAXBContext jAXBContext;

    public XMLAnswerParser(Class<A> answerClass) {
        try {
            this.jAXBContext = JAXBContext.newInstance((Class[])new Class[]{XMLAnswer.class, answerClass});
        }
        catch (JAXBException e) {
            throw new NextCloudApiException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends XMLAnswer> XMLAnswerParser<A> getInstance(Class<A> answerClass) {
        XMLAnswerParser<XMLAnswer> parser = PARSERS.get(answerClass.getName());
        if (parser == null) {
            Map<String, XMLAnswerParser<? extends XMLAnswer>> map = PARSERS;
            synchronized (map) {
                if (parser == null) {
                    parser = new XMLAnswerParser<A>(answerClass);
                    PARSERS.put(answerClass.getName(), parser);
                }
            }
        }
        return parser;
    }

    @Override
    public A parseResponse(Reader xmlStream) {
        A a;
        try {
            a = this.tryParseAnswer(xmlStream);
        }
        catch (Exception e) {
            throw new NextCloudApiException(e);
        }
        finally {
            try {
                xmlStream.close();
            }
            catch (IOException iOException) {}
        }
        return a;
    }

    private A tryParseAnswer(Reader xmlStream) throws JAXBException, IOException {
        Unmarshaller unmarshaller = this.jAXBContext.createUnmarshaller();
        Object result = unmarshaller.unmarshal(xmlStream);
        return (A)((XMLAnswer)result);
    }
}

