/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.utils;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.exception.NextCloudApiException;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public class ConnectorCommon {
    private final ServerConfig serverConfig;

    public ConnectorCommon(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public <R> R executeGet(String part, List<NameValuePair> queryParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part, queryParams);
            HttpResponse response = Unirest.get((String)url.toString()).header("content-type", "application/json").header("ocs-apirequest", "true").header("authorization", "Basic YW50ZXJvczo3MjcyMDQ=").header("cache-control", "no-cache").asString();
            System.out.println(response);
            R parseResponse = parser.parseResponse(new StringReader((String)response.getBody()));
            return parseResponse;
        }
        catch (Exception e) {
            throw new NextCloudApiException(e);
        }
    }

    public <R> R executePost(String part, List<NameValuePair> postParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part, postParams);
            HttpResponse response = Unirest.post((String)url.toString()).header("content-type", "application/json").header("ocs-apirequest", "true").header("authorization", "Basic YW50ZXJvczo3MjcyMDQ=").header("cache-control", "no-cache").asString();
            R parseResponse = parser.parseResponse(new StringReader((String)response.getBody()));
            return parseResponse;
        }
        catch (Exception e) {
            throw new NextCloudApiException(e);
        }
    }

    public <R> R executePut(String part1, String part2, List<NameValuePair> putParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part1 + "/" + part2, putParams);
            HttpResponse response = Unirest.put((String)url.toString()).header("content-type", "application/json").header("ocs-apirequest", "true").header("authorization", "Basic YWRtaW5AY3JtZ2F6aW4uY29tLmJyOkFudGVyb3NANzI3MjA0NTY3ODk=").header("cache-control", "no-cache").asString();
            R parseResponse = parser.parseResponse(new StringReader((String)response.getBody()));
            return parseResponse;
        }
        catch (Exception e) {
            throw new NextCloudApiException(e);
        }
    }

    public <R> R executeDelete(String part1, String part2, List<NameValuePair> deleteParams, ResponseParser<R> parser) {
        try {
            URI url = this.buildUrl(part1 + "/" + part2, deleteParams);
            HttpResponse response = Unirest.delete((String)url.toString()).header("content-type", "application/json").header("ocs-apirequest", "true").header("authorization", "Basic YWRtaW5AY3JtZ2F6aW4uY29tLmJyOkFudGVyb3NANzI3MjA0NTY3ODk=").header("cache-control", "no-cache").asString();
            R parseResponse = parser.parseResponse(new StringReader((String)response.getBody()));
            return parseResponse;
        }
        catch (Exception e) {
            throw new NextCloudApiException(e);
        }
    }

    private URI buildUrl(String subPath, List<NameValuePair> queryParams) {
        URIBuilder uB = new URIBuilder().setScheme(this.serverConfig.isUseHTTPS() ? "https" : "http").setHost(this.serverConfig.getServerName() + "/").setUserInfo(this.serverConfig.getUserName(), this.serverConfig.getPassword()).setPath(subPath);
        if (queryParams != null) {
            uB.addParameters(queryParams);
        }
        try {
            return uB.build();
        }
        catch (URISyntaxException e) {
            throw new NextCloudApiException(e);
        }
    }

    public static interface ResponseParser<R> {
        public R parseResponse(Reader var1);
    }
}

