/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.provisioning;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.provisioning.GroupsXMLAnswer;
import br.com.anteros.nextcloud.api.provisioning.User;
import br.com.anteros.nextcloud.api.provisioning.UserData;
import br.com.anteros.nextcloud.api.provisioning.UserXMLAnswer;
import br.com.anteros.nextcloud.api.provisioning.UsersXMLAnswer;
import br.com.anteros.nextcloud.api.utils.ConnectorCommon;
import br.com.anteros.nextcloud.api.utils.ListXMLAnswer;
import br.com.anteros.nextcloud.api.utils.NextCloudResponseHelper;
import br.com.anteros.nextcloud.api.utils.XMLAnswer;
import br.com.anteros.nextcloud.api.utils.XMLAnswerParser;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ProvisionConnector {
    private static final String ROOT_PART = "ocs/v1.php/cloud/";
    private static final String USERS_PART = "ocs/v1.php/cloud/users";
    private static final String GROUPS_PART = "ocs/v1.php/cloud/groups";
    private final ConnectorCommon connectorCommon;

    public ProvisionConnector(ServerConfig serverConfig) {
        this.connectorCommon = new ConnectorCommon(serverConfig);
    }

    public boolean createUser(String userId, String password) {
        LinkedList<NameValuePair> postParams = new LinkedList<NameValuePair>();
        postParams.add((NameValuePair)new BasicNameValuePair("userid", userId));
        postParams.add((NameValuePair)new BasicNameValuePair("password", password));
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executePost(USERS_PART, postParams, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public boolean deleteUser(String userId) {
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executeDelete(USERS_PART, userId, null, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public List<String> getUsers() {
        return this.getUsers(null, -1, -1);
    }

    public List<String> getUsers(String search, int limit, int offset) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        if (limit != -1) {
            queryParams.add((NameValuePair)new BasicNameValuePair("limit", Integer.toString(limit)));
        }
        if (offset != -1) {
            queryParams.add((NameValuePair)new BasicNameValuePair("offset", Integer.toString(offset)));
        }
        if (search != null) {
            queryParams.add((NameValuePair)new BasicNameValuePair("search", search));
        }
        return ((UsersXMLAnswer)NextCloudResponseHelper.getAndCheckStatus((XMLAnswer)this.connectorCommon.executeGet(USERS_PART, queryParams, XMLAnswerParser.getInstance(UsersXMLAnswer.class)))).getUsers();
    }

    public User getUser(String userId) {
        return this.connectorCommon.executeGet("ocs/v1.php/cloud/users/" + userId, Collections.emptyList(), XMLAnswerParser.getInstance(UserXMLAnswer.class)).getUser();
    }

    public boolean editUser(String userId, UserData key, String value) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        queryParams.add((NameValuePair)new BasicNameValuePair("key", key.name().toLowerCase()));
        queryParams.add((NameValuePair)new BasicNameValuePair("value", value));
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executePut(USERS_PART, userId, queryParams, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public boolean enableUser(String userId) {
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executePut(USERS_PART, userId + "/enable", null, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public boolean disableUser(String userId) {
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executePut(USERS_PART, userId + "/disable", null, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public List<String> getGroupsOfUser(String userId) {
        return ((GroupsXMLAnswer)NextCloudResponseHelper.getAndCheckStatus((XMLAnswer)this.connectorCommon.executeGet("ocs/v1.php/cloud/users/" + userId + "/groups", null, XMLAnswerParser.getInstance(GroupsXMLAnswer.class)))).getGroups();
    }

    public boolean addUserToGroup(String userId, String groupId) {
        List<BasicNameValuePair> queryParams = Collections.singletonList(new BasicNameValuePair("groupid", groupId));
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executePost("ocs/v1.php/cloud/users/" + userId + "/groups", queryParams, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public boolean removeUserFromGroup(String userId, String groupId) {
        List<BasicNameValuePair> queryParams = Collections.singletonList(new BasicNameValuePair("groupid", groupId));
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executeDelete(USERS_PART, userId + "/groups", queryParams, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public List<String> getSubadminGroupsOfUser(String userId) {
        return ((ListXMLAnswer)NextCloudResponseHelper.getAndCheckStatus((XMLAnswer)this.connectorCommon.executeGet("ocs/v1.php/cloud/users/" + userId + "/subadmins", null, XMLAnswerParser.getInstance(ListXMLAnswer.class)))).getResult();
    }

    public boolean promoteToSubadmin(String userId, String groupId) {
        List<BasicNameValuePair> queryParams = Collections.singletonList(new BasicNameValuePair("groupid", groupId));
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executePost("ocs/v1.php/cloud/users/" + userId + "/subadmins", queryParams, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public boolean demoteSubadmin(String userId, String groupId) {
        List<BasicNameValuePair> queryParams = Collections.singletonList(new BasicNameValuePair("groupid", groupId));
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executeDelete(USERS_PART, userId + "/subadmins", queryParams, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public boolean sendWelcomeMail(String userId) {
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executePost("ocs/v1.php/cloud/users/" + userId + "/welcome", null, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public List<String> getMembersOfGroup(String groupId) {
        return ((UsersXMLAnswer)NextCloudResponseHelper.getAndCheckStatus((XMLAnswer)this.connectorCommon.executeGet("ocs/v1.php/cloud/groups/" + groupId, null, XMLAnswerParser.getInstance(UsersXMLAnswer.class)))).getUsers();
    }

    public List<String> getSubadminsOfGroup(String groupId) {
        return ((ListXMLAnswer)NextCloudResponseHelper.getAndCheckStatus((XMLAnswer)this.connectorCommon.executeGet("ocs/v1.php/cloud/groups/" + groupId + "/subadmins", null, XMLAnswerParser.getInstance(ListXMLAnswer.class)))).getResult();
    }

    public boolean createGroup(String groupId) {
        LinkedList<NameValuePair> postParams = new LinkedList<NameValuePair>();
        postParams.add((NameValuePair)new BasicNameValuePair("groupid", groupId));
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executePost(GROUPS_PART, postParams, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public boolean deleteGroup(String groupId) {
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executeDelete(GROUPS_PART, groupId, null, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public List<String> getGroups() {
        return this.getGroups(null, -1, -1);
    }

    public List<String> getGroups(String search, int limit, int offset) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        if (limit != -1) {
            queryParams.add((NameValuePair)new BasicNameValuePair("limit", Integer.toString(limit)));
        }
        if (offset != -1) {
            queryParams.add((NameValuePair)new BasicNameValuePair("offset", Integer.toString(offset)));
        }
        if (search != null) {
            queryParams.add((NameValuePair)new BasicNameValuePair("search", search));
        }
        return this.connectorCommon.executeGet(GROUPS_PART, queryParams, XMLAnswerParser.getInstance(GroupsXMLAnswer.class)).getGroups();
    }
}

