/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api.filesharing;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.exception.MoreThanOneShareFoundException;
import br.com.anteros.nextcloud.api.filesharing.Share;
import br.com.anteros.nextcloud.api.filesharing.SharePermissions;
import br.com.anteros.nextcloud.api.filesharing.ShareType;
import br.com.anteros.nextcloud.api.filesharing.SharesXMLAnswer;
import br.com.anteros.nextcloud.api.filesharing.SingleShareXMLAnswer;
import br.com.anteros.nextcloud.api.provisioning.ShareData;
import br.com.anteros.nextcloud.api.utils.ConnectorCommon;
import br.com.anteros.nextcloud.api.utils.NextCloudResponseHelper;
import br.com.anteros.nextcloud.api.utils.XMLAnswer;
import br.com.anteros.nextcloud.api.utils.XMLAnswerParser;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class FilesharingConnector {
    private static final String ROOT_PART = "ocs/v1.php/apps/files_sharing/api/v1/";
    private static final String SHARES_PART = "ocs/v1.php/apps/files_sharing/api/v1/shares";
    private final ConnectorCommon connectorCommon;

    public FilesharingConnector(ServerConfig serverConfig) {
        this.connectorCommon = new ConnectorCommon(serverConfig);
    }

    public List<Share> getShares() {
        return this.getShares(null, false, false);
    }

    public List<Share> getShares(String path, boolean reShares, boolean subShares) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        if (path != null) {
            queryParams.add((NameValuePair)new BasicNameValuePair("path", path));
        }
        if (reShares) {
            queryParams.add((NameValuePair)new BasicNameValuePair("reshares", "true"));
        }
        if (subShares) {
            queryParams.add((NameValuePair)new BasicNameValuePair("subfiles", "true"));
        }
        return this.connectorCommon.executeGet(SHARES_PART, queryParams, XMLAnswerParser.getInstance(SharesXMLAnswer.class)).getShares();
    }

    public Share getShareInfo(int shareId) {
        SharesXMLAnswer xa = (SharesXMLAnswer)NextCloudResponseHelper.getAndCheckStatus((XMLAnswer)this.connectorCommon.executeGet("ocs/v1.php/apps/files_sharing/api/v1/shares/" + Integer.toString(shareId), null, XMLAnswerParser.getInstance(SharesXMLAnswer.class)));
        if (xa.getShares() == null) {
            return null;
        }
        if (xa.getShares().size() == 1) {
            return xa.getShares().get(0);
        }
        throw new MoreThanOneShareFoundException(shareId);
    }

    public Share doShare(String path, ShareType shareType, String shareWithUserOrGroupId, Boolean publicUpload, String password, SharePermissions permissions) {
        LinkedList<NameValuePair> postParams = new LinkedList<NameValuePair>();
        postParams.add((NameValuePair)new BasicNameValuePair("path", path));
        postParams.add((NameValuePair)new BasicNameValuePair("shareType", Integer.toString(shareType.getIntValue())));
        postParams.add((NameValuePair)new BasicNameValuePair("shareWith", shareWithUserOrGroupId));
        if (publicUpload != null) {
            postParams.add((NameValuePair)new BasicNameValuePair("publicUpload", publicUpload != false ? "true" : "false"));
        }
        if (password != null) {
            postParams.add((NameValuePair)new BasicNameValuePair("password", password));
        }
        if (permissions != null) {
            postParams.add((NameValuePair)new BasicNameValuePair("permissions", Integer.toString(permissions.getCurrentPermission())));
        }
        return this.connectorCommon.executePost(SHARES_PART, postParams, XMLAnswerParser.getInstance(SingleShareXMLAnswer.class)).getShare();
    }

    public boolean editShare(int shareId, ShareData key, String value) {
        List<BasicNameValuePair> queryParams = Collections.singletonList(new BasicNameValuePair(key.parameterName, value));
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executePut(SHARES_PART, Integer.toString(shareId), queryParams, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public boolean editShare(int shareId, Map<ShareData, String> values) {
        List<NameValuePair> queryParams = values.entrySet().stream().map(e -> new BasicNameValuePair(((ShareData)((Object)((Object)e.getKey()))).parameterName, (String)e.getValue())).collect(Collectors.toList());
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executePut(SHARES_PART, Integer.toString(shareId), queryParams, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }

    public boolean deleteShare(int shareId) {
        return NextCloudResponseHelper.isStatusCodeOkay(this.connectorCommon.executeDelete(SHARES_PART, Integer.toString(shareId), null, XMLAnswerParser.getInstance(XMLAnswer.class)));
    }
}

