/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.nextcloud.api;

import br.com.anteros.nextcloud.api.ServerConfig;
import br.com.anteros.nextcloud.api.filesharing.FilesharingConnector;
import br.com.anteros.nextcloud.api.filesharing.Share;
import br.com.anteros.nextcloud.api.filesharing.SharePermissions;
import br.com.anteros.nextcloud.api.filesharing.ShareType;
import br.com.anteros.nextcloud.api.provisioning.ProvisionConnector;
import br.com.anteros.nextcloud.api.provisioning.ShareData;
import br.com.anteros.nextcloud.api.provisioning.User;
import br.com.anteros.nextcloud.api.provisioning.UserData;
import br.com.anteros.nextcloud.api.webdav.Files;
import br.com.anteros.nextcloud.api.webdav.Folders;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AnterosNextCloudConnector {
    private final ServerConfig _serverConfig;
    private final ProvisionConnector pc;
    private final FilesharingConnector fc;
    private final Folders fd;
    private final Files fl;

    public AnterosNextCloudConnector(String serverName, boolean useHTTPS, int port, String userName, String password) {
        this._serverConfig = new ServerConfig(serverName, useHTTPS, port, userName, password);
        this.pc = new ProvisionConnector(this._serverConfig);
        this.fc = new FilesharingConnector(this._serverConfig);
        this.fd = new Folders(this._serverConfig);
        this.fl = new Files(this._serverConfig);
    }

    public boolean createUser(String userId, String password) {
        return this.pc.createUser(userId, password);
    }

    public boolean deleteUser(String userId) {
        return this.pc.deleteUser(userId);
    }

    public boolean enableUser(String userId) {
        return this.pc.enableUser(userId);
    }

    public boolean disableUser(String userId) {
        return this.pc.disableUser(userId);
    }

    public List<String> getGroupsOfUser(String userId) {
        return this.pc.getGroupsOfUser(userId);
    }

    public boolean addUserToGroup(String userId, String groupId) {
        return this.pc.addUserToGroup(userId, groupId);
    }

    public boolean removeUserFromGroup(String userId, String groupId) {
        return this.pc.removeUserFromGroup(userId, groupId);
    }

    public List<String> getSubadminGroupsOfUser(String userId) {
        return this.pc.getSubadminGroupsOfUser(userId);
    }

    public boolean promoteToSubadmin(String userId, String groupId) {
        return this.pc.promoteToSubadmin(userId, groupId);
    }

    public boolean demoteSubadmin(String userId, String groupId) {
        return this.pc.demoteSubadmin(userId, groupId);
    }

    public boolean sendWelcomeMail(String userId) {
        return this.pc.sendWelcomeMail(userId);
    }

    public List<String> getMembersOfGroup(String groupId) {
        return this.pc.getMembersOfGroup(groupId);
    }

    public List<String> getSubadminsOfGroup(String groupId) {
        return this.pc.getSubadminsOfGroup(groupId);
    }

    public boolean createGroup(String groupId) {
        return this.pc.createGroup(groupId);
    }

    public List<String> getUsers() {
        return this.pc.getUsers();
    }

    public List<String> getUsers(String search, int limit, int offset) {
        return this.pc.getUsers(search, limit, offset);
    }

    public User getUser(String userId) {
        return this.pc.getUser(userId);
    }

    public boolean editUser(String userId, UserData key, String value) {
        return this.pc.editUser(userId, key, value);
    }

    public boolean deleteGroup(String groupId) {
        return this.pc.deleteGroup(groupId);
    }

    public List<String> getGroups() {
        return this.pc.getGroups();
    }

    public List<String> getGroups(String search, int limit, int offset) {
        return this.pc.getGroups(search, limit, offset);
    }

    @Deprecated
    public List<String> getFolders(String path) {
        return this.fd.getFolders(path);
    }

    public List<String> listFolderContent(String path) {
        return this.fd.listFolderContent(path);
    }

    public List<String> listFolderContent(String path, int depth) {
        return this.fd.listFolderContent(path, depth);
    }

    public boolean folderExists(String path) {
        return this.fd.exists(path);
    }

    public void createFolder(String path) {
        this.fd.createFolder(path);
    }

    public void deleteFolder(String path) {
        this.fd.deleteFolder(path);
    }

    public Share doShare(String path, ShareType shareType, String shareWithUserOrGroupId, Boolean publicUpload, String password, SharePermissions permissions) {
        return this.fc.doShare(path, shareType, shareWithUserOrGroupId, publicUpload, password, permissions);
    }

    public boolean deleteShare(int shareId) {
        return this.fc.deleteShare(shareId);
    }

    public List<Share> getShares() {
        return this.fc.getShares();
    }

    public void uploadFile(InputStream inputStream, String remotePath) {
        this.fl.uploadFile(inputStream, remotePath);
    }

    public void removeFile(String path) {
        this.fl.removeFile(path);
    }

    public boolean fileExists(String path) {
        return this.fl.fileExists(path);
    }

    public Collection<Share> getShares(String path, boolean reShares, boolean subShares) {
        return this.fc.getShares(path, reShares, subShares);
    }

    public Share getShareInfo(int shareId) {
        return this.fc.getShareInfo(shareId);
    }

    public boolean editShare(int shareId, ShareData key, String value) {
        return this.fc.editShare(shareId, key, value);
    }

    public boolean editShare(int shareId, Map<ShareData, String> values) {
        return this.fc.editShare(shareId, values);
    }
}

