/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.mail;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class EmailCheck {
    private static final int TIMEOUT_SOCKET = 30000;

    private static int hear(BufferedReader in) throws Exception {
        String line = null;
        int res = 0;
        while ((line = in.readLine()) != null) {
            String pfx = line.substring(0, 3);
            try {
                res = Integer.parseInt(pfx);
            }
            catch (Exception ex) {
                throw new Exception(ex.getMessage());
            }
            if (line.charAt(3) != '-') break;
        }
        return res;
    }

    private static void say(BufferedWriter wr, String text) throws IOException {
        wr.write(String.valueOf(text) + "\r\n");
        wr.flush();
    }

    private static ArrayList getMX(String hostName) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext ictx = new InitialDirContext(env);
        Attributes attrs = ictx.getAttributes(hostName, new String[]{"MX"});
        Attribute attr = attrs.get("MX");
        if ((attr == null || attr.size() == 0) && (attr = (attrs = ictx.getAttributes(hostName, new String[]{"A"})).get("A")) == null) {
            throw new NamingException("No match for name '" + hostName + "'");
        }
        ArrayList<String> res = new ArrayList<String>();
        NamingEnumeration<?> en = attr.getAll();
        while (en.hasMore()) {
            String x = (String)en.next();
            String[] f = x.split(" ");
            if (f == null || f.length <= 1) continue;
            if (f[1].endsWith(".")) {
                f[1] = f[1].substring(0, f[1].length() - 1);
            }
            res.add(f[1]);
        }
        return res;
    }

    public static boolean isAddressValid(String address, String addressSender) throws Exception {
        int pos = address.indexOf(64);
        int posSender = addressSender.indexOf(64);
        if (pos == -1 || posSender == -1) {
            return false;
        }
        String domain = address.substring(++pos);
        String domainSender = addressSender.substring(++posSender);
        ArrayList mxList = null;
        try {
            mxList = EmailCheck.getMX(domain);
        }
        catch (NamingException ex) {
            return false;
        }
        if (mxList.size() == 0) {
            return false;
        }
        int mx = 0;
        while (mx < mxList.size()) {
            boolean valid = false;
            try {
                try {
                    Socket skt = new Socket((String)mxList.get(mx), 25);
                    skt.setSoTimeout(30000);
                    BufferedReader rdr = new BufferedReader(new InputStreamReader(skt.getInputStream()));
                    BufferedWriter wtr = new BufferedWriter(new OutputStreamWriter(skt.getOutputStream()));
                    int res = EmailCheck.hear(rdr);
                    if (res != 220) {
                        skt.close();
                        throw new Exception("Invalid header");
                    }
                    EmailCheck.say(wtr, "EHLO " + domainSender);
                    res = EmailCheck.hear(rdr);
                    if (res != 250) {
                        skt.close();
                        throw new Exception("Not ESMTP");
                    }
                    EmailCheck.say(wtr, "MAIL FROM: <" + addressSender + ">");
                    res = EmailCheck.hear(rdr);
                    if (res != 250) {
                        skt.close();
                        throw new Exception("Sender rejected");
                    }
                    EmailCheck.say(wtr, "RCPT TO: <" + address + ">");
                    res = EmailCheck.hear(rdr);
                    EmailCheck.say(wtr, "RSET");
                    EmailCheck.hear(rdr);
                    EmailCheck.say(wtr, "QUIT");
                    EmailCheck.hear(rdr);
                    if (res != 250) {
                        skt.close();
                        throw new Exception("Address is not valid!");
                    }
                    valid = true;
                    if (res == 550) {
                        valid = false;
                    } else {
                        if (res != 250) {
                            if (skt != null) {
                                skt.close();
                            }
                            throw new Exception(String.valueOf(res) + " - Error sending email! ");
                        }
                        if (res == 250) {
                            valid = true;
                        }
                    }
                    rdr.close();
                    wtr.close();
                    skt.close();
                }
                catch (Exception ex) {
                    throw new Exception(ex.getMessage());
                }
            }
            finally {
                if (valid) {
                    return true;
                }
            }
            ++mx;
        }
        return false;
    }

    public String call_this_to_validate(String email, String emailSender) throws Exception {
        String[] testData = new String[]{email};
        String return_string = "";
        int ctr = 0;
        while (ctr < testData.length) {
            return_string = String.valueOf(testData[ctr]) + " is valid? " + EmailCheck.isAddressValid(testData[ctr], emailSender);
            ++ctr;
        }
        return return_string;
    }
}

