/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.mail;

import br.com.anteros.mail.EmailAttachment;
import br.com.anteros.mail.EmailAuthenticator;
import br.com.anteros.mail.EmailMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class EmailManager {
    private Properties properties;
    private EmailAuthenticator authenticator;
    private EmailMessage emailMessage;
    private boolean confirmationReceipt = false;
    private boolean readingConfirmation = false;
    private boolean useTLS;
    private boolean debug;
    private int port;
    private String host;

    public EmailManager(Properties propriedades, EmailAuthenticator autenticadorEmail) {
        this.properties = propriedades;
        this.authenticator = autenticadorEmail;
    }

    public EmailManager(Properties propriedades, String host, EmailAuthenticator autenticadorEmail, boolean useTLS, int port, boolean debug) {
        this.properties = propriedades;
        this.authenticator = autenticadorEmail;
        this.useTLS = useTLS;
        this.port = port;
        this.host = host;
        this.debug = debug;
    }

    public EmailManager(Properties propriedades, EmailAuthenticator autenticadorEmail, boolean confirmationReceipt, boolean readingConfirmation) {
        this.properties = propriedades;
        this.authenticator = autenticadorEmail;
        this.confirmationReceipt = confirmationReceipt;
        this.readingConfirmation = readingConfirmation;
    }

    public void send(EmailMessage emailMessage) throws NoSuchProviderException, MessagingException, UnsupportedEncodingException {
        this.emailMessage = emailMessage;
        if (this.host.contains("gmail")) {
            this.properties.put("mail.smtp.host", "smtp.gmail.com");
            this.properties.put("mail.smtp.socketFactory.port", "465");
            this.properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            this.properties.put("mail.smtp.auth", "true");
            this.properties.put("mail.smtp.port", "465");
            this.properties.setProperty("mail.debug", this.debug ? "true" : "false");
        } else if (this.host.contains("amazon")) {
            this.properties.put("mail.transport.protocol", "smtp");
            this.properties.put("mail.smtp.host", this.host);
            this.properties.put("mail.smtp.port", (Object)587);
            this.properties.put("mail.smtp.starttls.enable", "true");
            this.properties.put("mail.smtp.auth", "true");
            this.properties.setProperty("mail.debug", this.debug ? "true" : "false");
        } else if (this.useTLS) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.setProperty("mail.smtp.host", this.host);
            this.properties.setProperty("mail.imap.ssl.enable", "true");
            this.properties.setProperty("mail.imap.ssl.socketFactory.class", "br.com.anteros.mail.AnterosSSLSocketFactory");
            this.properties.setProperty("mail.imap.ssl.socketFactory.fallback", "false");
            this.properties.setProperty("mail.smtp.port", "" + this.port);
            this.properties.setProperty("mail.smtp.auth", "true");
            this.properties.setProperty("mail.smtp.socketFactory.port", "" + this.port);
            this.properties.setProperty("mail.smtp.EnableSSL.enable", "true");
            this.properties.setProperty("mail.debug", this.debug ? "true" : "false");
            this.properties.setProperty("mail.smtp.starttls.required", "true");
            this.properties.setProperty("mail.smtp.ssl.trust", this.host);
        } else {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.setProperty("mail.smtp.host", this.host);
            this.properties.setProperty("mail.smtp.port", "" + this.port);
            this.properties.setProperty("mail.smtp.auth", "true");
            this.properties.setProperty("mail.debug", this.debug ? "true" : "false");
        }
        Session session = Session.getInstance((Properties)this.properties, (Authenticator)this.authenticator);
        MimeMessage message = new MimeMessage(session);
        if (this.getEmailMessage().getName() != null) {
            message.setFrom((Address)new InternetAddress(this.getEmailMessage().getEmailFrom(), this.getEmailMessage().getName()));
        } else {
            message.setFrom((Address)new InternetAddress(this.getEmailMessage().getEmailFrom()));
        }
        InternetAddress[] to = this.emailMessage.getEmailTO();
        InternetAddress[] cc = this.emailMessage.getEmailCC();
        if (this.readingConfirmation) {
            message.addHeader("Disposition-Notification-To", this.emailMessage.getEmailFrom());
        }
        if (this.confirmationReceipt) {
            message.addHeader("Return-Receipt-To", this.emailMessage.getEmailFrom());
        }
        message.setRecipients(Message.RecipientType.TO, (Address[])to);
        if (cc != null) {
            message.setRecipients(Message.RecipientType.CC, (Address[])cc);
        }
        message.setSubject(this.emailMessage.getSubject());
        message.setSentDate(new Date());
        MimeMultipart body = new MimeMultipart();
        MimeBodyPart bodyText = new MimeBodyPart();
        bodyText.setContent((Object)this.getEmailMessage().getTextMessage(), "text/html; charset=utf-8");
        body.addBodyPart((BodyPart)bodyText);
        if (this.emailMessage.getAttachments().size() > 0) {
            InternetHeaders headers = new InternetHeaders();
            for (EmailAttachment anexo : this.emailMessage.getAttachments()) {
                headers.addHeader("Content-Type", anexo.getContentType());
                MimeBodyPart attach = new MimeBodyPart();
                attach.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(anexo.getContent(), anexo.getContentType())));
                attach.setFileName(anexo.getName());
                body.addBodyPart((BodyPart)attach);
            }
        }
        message.setContent((Multipart)body);
        Transport.send((Message)message);
    }

    public void showMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("De: ");
        sb.append(this.emailMessage.getEmailFrom());
        sb.append("\n");
        sb.append("Para: ");
        sb.append(this.emailMessage.getEmailTo());
        sb.append("\n");
        sb.append("Assunto: ");
        sb.append("\n\n");
        sb.append("Conte\u00fado: <OK>");
        for (EmailAttachment anexo : this.emailMessage.getAttachments()) {
            sb.append("  Anexo-> " + anexo.toString());
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean isConfirmationReceipt() {
        return this.confirmationReceipt;
    }

    public void setConfirmationReceipt(boolean confirmationReceipt) {
        this.confirmationReceipt = confirmationReceipt;
    }

    public boolean isReadingConfirmation() {
        return this.readingConfirmation;
    }

    public void setReadingConfirmation(boolean readingConfirmation) {
        this.readingConfirmation = readingConfirmation;
    }

    public EmailAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(EmailAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public EmailMessage getEmailMessage() {
        return this.emailMessage;
    }

    public void setEmailMessage(EmailMessage emailMessage) {
        this.emailMessage = emailMessage;
    }
}

