/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.log4jwebtracker.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.jdbc.JDBCAppender;

public abstract class LoggingUtils {
    public static synchronized List<Appender> getAppenders() {
        ArrayList<Appender> list = new ArrayList<Appender>();
        Enumeration e = LogManager.getRootLogger().getAllAppenders();
        while (e.hasMoreElements()) {
            Appender a = (Appender)e.nextElement();
            if (!(a instanceof FileAppender) && !(a instanceof JDBCAppender)) continue;
            list.add(a);
        }
        return list;
    }

    public static synchronized Appender getAppender(String appenderName) {
        Enumeration e = LogManager.getRootLogger().getAllAppenders();
        while (e.hasMoreElements()) {
            Appender a = (Appender)e.nextElement();
            if (!(a instanceof FileAppender) && !(a instanceof JDBCAppender)) continue;
            return a;
        }
        return null;
    }

    public static boolean contains(List loggers, String loggerName) {
        for (int i = 0; i < loggers.size(); ++i) {
            if (!((Logger)loggers.get(i)).getName().equals(loggerName)) continue;
            return true;
        }
        return false;
    }

    public static List getLoggers() {
        Enumeration e = LogManager.getCurrentLoggers();
        LinkedList loggersList = new LinkedList();
        while (e.hasMoreElements()) {
            loggersList.add(e.nextElement());
        }
        Collections.sort(loggersList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Logger log0 = (Logger)arg0;
                Logger log1 = (Logger)arg1;
                return log0.getName().compareTo(log1.getName());
            }
        });
        loggersList.add(0, LogManager.getRootLogger());
        return loggersList;
    }
}

