/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.log4j.extension;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.jdbc.JDBCAppender;

public class AnterosJDBCAppender
extends JDBCAppender {
    private int maxTimeOnMinutesToKeepLog = 0;
    private String deleteStatement;

    public void flushBuffer() {
        if (this.maxTimeOnMinutesToKeepLog > 0 && this.deleteStatement != null) {
            Connection con;
            block5: {
                Date date = new Date();
                long millisecond = this.maxTimeOnMinutesToKeepLog * 60 * 1000;
                Date newDate = new Date(date.getTime() - millisecond);
                con = null;
                Statement stmt = null;
                try {
                    con = this.getConnection();
                    stmt = con.prepareStatement(this.deleteStatement);
                    stmt.setTimestamp(1, new Timestamp(newDate.getTime()));
                    stmt.executeUpdate();
                    stmt.close();
                }
                catch (SQLException e) {
                    if (stmt == null) break block5;
                    try {
                        stmt.close();
                        throw e;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            this.closeConnection(con);
        }
        super.flushBuffer();
    }

    public int getMaxTimeOnMinutesToKeepLog() {
        return this.maxTimeOnMinutesToKeepLog;
    }

    public void setMaxTimeOnMinutesToKeepLog(int maxTimeOnMinutesToKeepLog) {
        this.maxTimeOnMinutesToKeepLog = maxTimeOnMinutesToKeepLog;
    }

    public String getDeleteStatement() {
        return this.deleteStatement;
    }

    public void setDeleteStatement(String deleteStatement) {
        this.deleteStatement = deleteStatement;
    }
}

