/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.log4jwebtracker.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public abstract class StreamUtils {
    public static void readStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        int bytesRead = inputStream.read(buf);
        while (bytesRead != -1) {
            outputStream.write(buf, 0, bytesRead);
            bytesRead = inputStream.read(buf);
        }
    }

    public static void readFile(RandomAccessFile inputFile, OutputStream outputStream, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        int bytesRead = inputFile.read(buf);
        while (bytesRead != -1) {
            outputStream.write(buf, 0, bytesRead);
            bytesRead = inputFile.read(buf);
        }
    }

    private static void readLines(RandomAccessFile inputFile, OutputStream outputStream, long seek) throws IOException {
        inputFile.seek(seek);
        String line = inputFile.readLine();
        while (line != null) {
            outputStream.write((line + "\n").getBytes());
            line = inputFile.readLine();
        }
    }

    public static void tailFile(RandomAccessFile inputFile, OutputStream outputStream, int bufferSize, int numLines) throws IOException {
        int len;
        long seek;
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize < 1");
        }
        if (numLines < 1) {
            throw new IllegalArgumentException("numLines < 1");
        }
        byte[] buf = new byte[bufferSize];
        long fileSizeMark = inputFile.length();
        long offset = fileSizeMark;
        if (offset - (long)bufferSize >= 0L) {
            seek = offset - (long)bufferSize;
            len = bufferSize;
        } else {
            seek = 0L;
            len = (int)offset;
        }
        inputFile.seek(seek);
        int bytesRead = inputFile.read(buf, 0, len);
        while (bytesRead != -1 && bytesRead != 0) {
            int i;
            for (i = bytesRead - 1; i >= 0 && numLines > 0; --i) {
                if (buf[i] != 10) continue;
                if (offset == fileSizeMark && i == bytesRead - 1) {
                    fileSizeMark = -1L;
                    continue;
                }
                --numLines;
            }
            if (numLines == 0) {
                StreamUtils.readLines(inputFile, outputStream, offset - (long)bytesRead + (long)i + 2L);
                return;
            }
            if ((offset -= (long)bytesRead) - (long)bufferSize >= 0L) {
                seek = offset - (long)bufferSize;
                len = bufferSize;
            } else {
                seek = 0L;
                len = (int)offset;
            }
            inputFile.seek(seek);
            bytesRead = inputFile.read(buf, 0, len);
        }
        StreamUtils.readLines(inputFile, outputStream, 0L);
    }
}

