/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.log4jwebtracker.servlet;

import br.com.anteros.log4jwebtracker.io.StreamUtils;
import br.com.anteros.log4jwebtracker.logging.LoggingUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TrackerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(TrackerServlet.class);
    private static final int BUFFER_SIZE = 16384;
    private byte[] jqueryMin = null;
    private byte[] jqueryWordWrap = null;
    private byte[] css = null;
    private byte[] logo = null;
    private byte[] favicon = null;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getRequestURI();
        String baseAction = request.getContextPath() + request.getServletPath();
        if (request.getPathInfo() == null || request.getPathInfo().equals("") || request.getPathInfo().equals("/")) {
            response.sendRedirect(response.encodeRedirectURL(baseAction + "/config"));
        } else if (request.getPathInfo().startsWith("/js/")) {
            if (request.getPathInfo().equals("/js/jquery-1.6.4.min.js")) {
                this.doResource(request, response, this.getJQueryMin(), "application/javascript");
            } else if (request.getPathInfo().equals("/js/jquery.wordWrap.js")) {
                this.doResource(request, response, this.getJQueryWordWrap(), "application/javascript");
            } else {
                logger.warn((Object)("Request javascript resource " + action + " not found."));
                response.sendError(404);
            }
        } else if (request.getPathInfo().startsWith("/css/")) {
            if (request.getPathInfo().equals("/css/tracker.css")) {
                this.doResource(request, response, this.getCSS(), "text/css");
            } else {
                logger.warn((Object)("Request CSS resource " + action + " not found."));
                response.sendError(404);
            }
        } else if (request.getPathInfo().startsWith("/img/")) {
            if (request.getPathInfo().equals("/img/anteros_logo.png")) {
                this.doResource(request, response, this.getLogo(), "image/png");
            } else if (request.getPathInfo().equals("/img/favicon.ico")) {
                this.doResource(request, response, this.getFavicon(), "image/x-icon");
            } else {
                logger.warn((Object)("Request image resource " + action + " not found."));
                response.sendError(404);
            }
        } else if (request.getPathInfo().startsWith("/taillog")) {
            this.doTailLog(request, response, action, baseAction);
        } else if (request.getPathInfo().startsWith("/getlog")) {
            this.doGetLog(request, response, action, baseAction);
        } else {
            this.doPage(request, response, action, baseAction);
        }
    }

    private void doResource(HttpServletRequest request, HttpServletResponse response, byte[] buffer, String contentType) throws ServletException, IOException {
        ServletOutputStream output = response.getOutputStream();
        response.setContentType(contentType);
        response.setContentLength(buffer.length);
        output.write(buffer, 0, buffer.length);
        output.flush();
        output.close();
    }

    private void doPage(HttpServletRequest request, HttpServletResponse response, String action, String baseAction) throws ServletException, IOException {
        request.setAttribute("action", (Object)action);
        request.setAttribute("baseAction", (Object)baseAction);
        if (request.getPathInfo().equals("/log")) {
            this.doLog(request, response, action, baseAction);
        } else if (request.getPathInfo().equals("/config")) {
            this.doConfiguration(request, response, action, baseAction);
        } else {
            logger.warn((Object)("Request page " + action + " not found."));
            response.sendError(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConfiguration(HttpServletRequest request, HttpServletResponse response, String action, String baseAction) throws ServletException, IOException {
        List loggers = LoggingUtils.getLoggers();
        request.setAttribute("loggers", (Object)loggers);
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            Logger logger;
            Level level;
            String parameterName = (String)e.nextElement();
            if (parameterName.equals("root")) {
                Logger root;
                level = Level.toLevel((String)request.getParameter(parameterName));
                logger = root = LogManager.getRootLogger();
                synchronized (logger) {
                    root.setLevel(level);
                }
                if (!TrackerServlet.logger.isDebugEnabled()) continue;
                TrackerServlet.logger.debug((Object)(parameterName + '=' + level.toString()));
                continue;
            }
            if (LoggingUtils.contains(loggers, parameterName)) {
                Logger logg;
                level = Level.toLevel((String)request.getParameter(parameterName));
                logger = logg = LogManager.getLogger((String)parameterName);
                synchronized (logger) {
                    logg.setLevel(level);
                }
                if (!TrackerServlet.logger.isDebugEnabled()) continue;
                TrackerServlet.logger.debug((Object)(parameterName + '=' + level.toString()));
                continue;
            }
            TrackerServlet.logger.warn((Object)("Logger name " + parameterName + " not exist."));
        }
        this.doHTML(request, response);
    }

    private void doLog(HttpServletRequest request, HttpServletResponse response, String action, String baseAction) throws ServletException, IOException {
        request.setAttribute("fileAppenders", (Object)LoggingUtils.getFileAppenders());
        this.doHTML(request, response);
    }

    private void doTailLog(HttpServletRequest request, HttpServletResponse response, String action, String baseAction) throws ServletException, IOException {
        String appenderName = request.getParameter("appender");
        if (appenderName != null) {
            FileAppender fileAppender;
            int lines = 20;
            if (request.getParameter("lines") != null) {
                try {
                    lines = Integer.parseInt(request.getParameter("lines"));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("Number format 'lines' parameter invalid = " + request.getParameter("lines")));
                }
            }
            if ((fileAppender = LoggingUtils.getFileAppender(appenderName)) != null) {
                ServletOutputStream output = response.getOutputStream();
                try {
                    String contentType = "text/plain";
                    if (fileAppender.getEncoding() != null) {
                        contentType = contentType + "; charset=" + fileAppender.getEncoding();
                    }
                    response.setContentType(contentType);
                    response.setHeader("Cache-Control", "no-cache");
                    response.setHeader("Pragma", "no-cache");
                    response.setDateHeader("Expires", -1L);
                    RandomAccessFile inputFile = new RandomAccessFile(fileAppender.getFile(), "r");
                    StreamUtils.tailFile(inputFile, (OutputStream)output, 16384, lines);
                    inputFile.close();
                }
                catch (IOException e) {
                    logger.error((Object)("Error getting the file appender=" + fileAppender.getFile()), (Throwable)e);
                    output.write("TrackerError: Check the log manually.".getBytes());
                }
                output.flush();
                output.close();
            } else {
                logger.error((Object)("FileAppender with name=" + appenderName + " not exist."));
            }
        } else {
            logger.error((Object)"No appender name parameter specified.");
        }
    }

    private void doGetLog(HttpServletRequest request, HttpServletResponse response, String action, String baseAction) throws ServletException, IOException {
        String appenderName = request.getParameter("appender");
        if (appenderName != null) {
            FileAppender fileAppender = LoggingUtils.getFileAppender(appenderName);
            if (fileAppender != null) {
                File file = new File(fileAppender.getFile());
                ServletOutputStream output = response.getOutputStream();
                try {
                    String contentType = "text/plain";
                    if (fileAppender.getEncoding() != null) {
                        contentType = contentType + "; charset=" + fileAppender.getEncoding();
                    }
                    response.setContentType(contentType);
                    response.setContentLength((int)file.length());
                    response.setHeader("Cache-Control", "no-cache");
                    response.setHeader("Pragma", "no-cache");
                    response.setDateHeader("Expires", -1L);
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
                    FileInputStream fileStream = new FileInputStream(fileAppender.getFile());
                    StreamUtils.readStream(fileStream, (OutputStream)output, 16384);
                    ((InputStream)fileStream).close();
                }
                catch (IOException e) {
                    response.setHeader("Content-Disposition", "");
                    logger.error((Object)("Error getting the file appender=" + fileAppender.getFile()), (Throwable)e);
                    output.write("TrackerError: Check the log manually.".getBytes());
                    output.close();
                }
                output.flush();
                output.close();
            } else {
                logger.error((Object)("FileAppender with name=" + appenderName + " not exist."));
            }
        } else {
            logger.error((Object)"No appender name parameter specified.");
        }
    }

    public void doHTML(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int i;
        ServletOutputStream out = response.getOutputStream();
        response.setContentType("text/html; charset=ISO-8859-1");
        out.println("<!DOCTYPE html>");
        out.println("<html>");
        out.println("\t<head>");
        out.println("\t\t<title>Anteros Log4j Web Tracker</title>");
        out.println();
        out.println("\t\t<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
        out.print("\t\t<link rel=\"shortcut icon\" href=\"");
        out.print((String)request.getAttribute("baseAction"));
        out.println("/img/favicon.ico\" type=\"image/x-icon\">");
        out.print("\t\t<link rel=\"icon\" href=\"");
        out.print((String)request.getAttribute("baseAction"));
        out.println("/img/favicon.ico\" type=\"image/x-icon\">");
        out.print("\t\t<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        out.print((String)request.getAttribute("baseAction"));
        out.println("/css/tracker.css\" />");
        out.println();
        out.print("\t\t<script type=\"text/javascript\" src=\"");
        out.print((String)request.getAttribute("baseAction"));
        out.println("/js/jquery-1.6.4.min.js\"></script>");
        out.print("\t\t<script type=\"text/javascript\" src=\"");
        out.print((String)request.getAttribute("baseAction"));
        out.println("/js/jquery.wordWrap.js\"></script>");
        out.println("\t\t<script>");
        out.print("\t\t\t\t $(document).ready( function() {");
        if (request.getPathInfo().equals("/config")) {
            out.print("$('#filter').keyup(function() {var filterKey = this.value.toLowerCase();$('#loggers tbody tr').filter(function() {return $('select', this)[0].name.toLowerCase().indexOf(filterKey) == -1;}).hide();$('#loggers tbody tr').filter(function() {return $('select', this)[0].name.toLowerCase().indexOf(filterKey) != -1;}).show();});$('select').change(function() {$(this).parent().submit();});");
        }
        out.print("");
        if (request.getPathInfo().equals("/log")) {
            out.print("$('#wrapCheck').click(function() {var textarea = $('#logText').get();if( ! $(this).attr('checked') ) {$(textarea).wordWrap('on');} else {$(textarea).wordWrap('off');}});var refresh = function() {$('#loading-mask').text('Loading...');$('#loading-mask').removeClass('error');$('#loading-mask').show();var data = {appender: $('#appender').val()};if($('#lines').val()!='') {data.lines = $('#lines').val();}$.ajax({url: '");
            out.print((String)request.getAttribute("baseAction"));
            out.print("/taillog',data: data,dataType: 'text',cache: false,success: function(data) {if(data.indexOf('TrackerError')==-1) {$('#loading-mask').hide();$('#logText').val(data);$('#logText').get(0).scrollTop = $('#logText').get(0).scrollHeight;} else {$('#loading-mask').addClass('error');$('#loading-mask').text('Error: Check the log manually');}}});};$('#refresh').click(refresh);$('#lines').bind('keypress', function(e) { if(e.keyCode==13) { refresh(); return false; } });$('#download').click(function() {});");
            out.print("var interval = null; $('#refreshCheck').click(function(){if($(this).attr('checked')) {if (interval == null){ interval = setInterval(function(){ refresh(); }, 5000)};} else {clearInterval(interval)}});");
        }
        out.println("});");
        out.println("\t\t</script>");
        out.println("\t\t<!--[if !IE 7]><style type=\"text/css\">#wrap { display:table;height:100% }</style><![endif]-->");
        out.println("\t</head>");
        out.println("\t<body>");
        out.println("\t\t<div id=\"wrap\">");
        out.println("\t\t\t<div id=\"header\">");
        out.print("\t\t\t\t<a href=\"");
        out.print((String)request.getAttribute("baseAction"));
        out.println("\">");
        out.print("\t\t\t\t\t<img border=\"0\" alt=\"Anteros Log4j Web Tracker\" title=\"Anteros Log4j Web Tracker\" src=\"");
        out.print((String)request.getAttribute("baseAction"));
        out.println("/img/anteros_logo.png\" height=\"161\">");
        out.println("\t\t\t\t</a>");
        out.println("\t\t\t</div>");
        out.println("\t\t\t<div id=\"navcontainer\">");
        out.println("\t\t\t\t<ul id=\"navlist\">");
        out.print("\t\t\t\t\t<li><a href=\"");
        out.print((String)request.getAttribute("baseAction"));
        out.print("/config\"");
        if (request.getPathInfo().equals("/config")) {
            out.print(" class=\"active\"");
        }
        out.println(">Configura\u00e7\u00e3o</a></li>");
        out.print("\t\t\t\t\t<li><a href=\"");
        out.print((String)request.getAttribute("baseAction"));
        out.print("/log\"");
        if (request.getPathInfo().equals("/log")) {
            out.print(" class=\"active\"");
        }
        out.println(">Log</a></li>");
        out.println("\t\t\t\t</ul>");
        out.println("\t\t\t</div>");
        out.println("\t\t\t<div class=\"clear\"></div>");
        out.println("\t\t\t<div id=\"main\">");
        if (request.getPathInfo().equals("/config")) {
            List loggers = (List)request.getAttribute("loggers");
            out.println("\t\t\t\t<div id=\"configuration\">");
            out.println("\t\t\t\t\t<div id=\"filterContainer\">");
            out.println("\t\t\t\t\t\t<div id=\"filterTextContainer\">");
            out.println("\t\t\t\t\t\t\t<p>Filtro</p>");
            out.println("\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t\t<div id=\"filterInputContainer\">");
            out.println("\t\t\t\t\t\t\t<input type=\"text\" id=\"filter\" name=\"filter\" placeholder=\"Insira o nome do pacote ou parte dele\" spellcheck=\"false\"/>");
            out.println("\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t<div class=\"clear\"></div>");
            out.println("\t\t\t\t\t<div id=\"loggersContainer\">");
            out.println("\t\t\t\t\t\t<table id=\"loggers\">");
            out.println("\t\t\t\t\t\t\t<thead>");
            out.println("\t\t\t\t\t\t\t\t<tr>");
            out.println("\t\t\t\t\t\t\t\t\t<th>Logger</th>");
            out.println("\t\t\t\t\t\t\t\t\t<th>Level</th>");
            out.println("\t\t\t\t\t\t\t\t</tr>");
            out.println("\t\t\t\t\t\t\t</thead>");
            out.println("\t\t\t\t\t\t\t<tbody>");
            for (i = 0; i < loggers.size(); ++i) {
                Logger logger = (Logger)loggers.get(i);
                out.print("\t\t\t\t\t\t\t\t<tr class=\"logger-");
                out.print(i % 2 == 0 ? "pair" : "odd");
                out.println("\">");
                out.println("\t\t\t\t\t\t\t\t\t<td class=\"logger-name\">");
                out.print("\t\t\t\t\t\t\t\t\t\t<label for=\"");
                out.print(logger.getName());
                out.print("\">");
                out.print(logger.getName());
                out.println("</label>");
                out.println("\t\t\t\t\t\t\t\t\t</td>");
                out.println("\t\t\t\t\t\t\t\t\t<td class=\"logger-level\">");
                out.print("\t\t\t\t\t\t\t\t\t\t<form action=\"");
                out.print((String)request.getAttribute("baseAction"));
                out.println("/config\" method=\"post\">");
                out.print("\t\t\t\t\t\t\t\t\t\t\t<select class=\"select conf\" id=\"");
                out.print(logger.getName());
                out.print("\" name=\"");
                out.print(logger.getName());
                out.println("\">");
                out.print("\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"TRACE\"");
                if (logger.getEffectiveLevel().toString() == "TRACE") {
                    out.print(" selected=\"selected\" ");
                }
                out.println(">TRACE</option>");
                out.print("\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"DEBUG\"");
                if (logger.getEffectiveLevel().toString() == "DEBUG") {
                    out.print(" selected=\"selected\" ");
                }
                out.println(">DEBUG</option>");
                out.print("\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"INFO\"");
                if (logger.getEffectiveLevel().toString() == "INFO") {
                    out.print(" selected=\"selected\" ");
                }
                out.println(">INFO</option>");
                out.print("\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"WARN\"");
                if (logger.getEffectiveLevel().toString() == "WARN") {
                    out.print(" selected=\"selected\" ");
                }
                out.println(">WARN</option>");
                out.print("\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"ERROR\"");
                if (logger.getEffectiveLevel().toString() == "ERROR") {
                    out.print(" selected=\"selected\" ");
                }
                out.println(">ERROR</option>");
                out.print("\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"FATAL\"");
                if (logger.getEffectiveLevel().toString() == "FATAL") {
                    out.print(" selected=\"selected\" ");
                }
                out.println(">FATAL</option>");
                out.print("\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"OFF\"");
                if (logger.getEffectiveLevel().toString() == "OFF") {
                    out.print(" selected=\"selected\" ");
                }
                out.println(">OFF</option>");
                out.println("\t\t\t\t\t\t\t\t\t\t\t</select>");
                out.println("\t\t\t\t\t\t\t\t\t\t</form>");
                out.println("\t\t\t\t\t\t\t\t\t</td>");
                out.println("\t\t\t\t\t\t\t\t</tr>");
            }
            out.println("\t\t\t\t\t\t\t</tbody>");
            out.println("\t\t\t\t\t\t</table>");
            out.println("\t\t\t\t\t</div>");
            out.println("\t\t\t\t</div>");
        }
        out.print("");
        if (request.getPathInfo().equals("/log")) {
            out.println("\t\t\t\t<div id=\"log\">");
            out.println("\t\t\t\t\t<div id=\"options\">");
            out.println("\t\t\t\t\t\t<div style=\"float: left;\">");
            out.println("\t\t\t\t\t\t\t<div>");
            out.println("\t\t\t\t\t\t\t\t<input id=\"wrapCheck\" type=\"checkbox\">");
            out.println("\t\t\t\t\t\t\t\t<label id=\"wrapLabel\" for=\"wrapCheck\">N\u00e3o quebrar a linha do log</label>");
            out.println("\t\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t\t\t<div>");
            out.println("\t\t\t\t\t\t\t\t<input id=\"refreshCheck\" type=\"checkbox\">");
            out.println("\t\t\t\t\t\t\t\t<label id=\"refreshLabel\" for=\"refreshCheck\">Atualizar autom\u00e1tico</label>");
            out.println("\t\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t\t</div>");
            out.print("\t\t\t\t\t\t<form action=\"");
            out.print((String)request.getAttribute("baseAction"));
            out.println("/getlog\">");
            out.println("\t\t\t\t\t\t\t<div id=\"parent\" style=\"float: right;\">");
            out.println("\t\t\t\t\t\t\t\t<div class=\"childs\">");
            out.println("\t\t\t\t\t\t\t\t\t<div>");
            out.println("\t\t\t\t\t\t\t\t\t\t<label class=\"label\" for=\"appender\">Arquivo</label>");
            out.println("\t\t\t\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t\t\t\t\t<select class=\"select\" id=\"appender\" name=\"appender\">");
            List fileAppenders = (List)request.getAttribute("fileAppenders");
            for (i = 0; i < fileAppenders.size(); ++i) {
                FileAppender fap = (FileAppender)fileAppenders.get(i);
                out.print("\t\t\t\t\t\t\t\t\t\t<option value=\"");
                out.print(fap.getName());
                out.print("\">");
                out.print(fap.getName());
                out.println("</option>");
            }
            out.println("\t\t\t\t\t\t\t\t\t</select>");
            out.println("\t\t\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t\t\t\t<div class=\"childs\">");
            out.println("\t\t\t\t\t\t\t\t\t<div>");
            out.println("\t\t\t\t\t\t\t\t\t\t<label class=\"label\" for=\"lines\">Qtde. linhas</label>");
            out.println("\t\t\t\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t\t\t\t\t<input type=\"number\" id=\"lines\" name=\"lines\" value=\"20\" size=\"4\" style=\"margin-right: 5px;\" />");
            out.println("\t\t\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t\t\t\t<div class=\"childs\">");
            out.println("\t\t\t\t\t\t\t\t\t<button type=\"button\" class=\"btn\" id=\"refresh\">Atualizar</button>");
            out.println("\t\t\t\t\t\t\t\t\t<button type=\"submit\" class=\"btn green\" id=\"download\">Download</button>");
            out.println("\t\t\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t\t</form>");
            out.println("\t\t\t\t\t\t<div style=\"overflow: hidden;\">");
            out.println("\t\t\t\t\t\t\t<div id=\"loading-mask\" style=\"display: none;\"></div>");
            out.println("\t\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t</div>");
            out.println("\t\t\t\t\t<textarea id=\"logText\" rows=\"20\" spellcheck=\"false\"></textarea>");
            out.println("\t\t\t\t</div>");
        }
        out.println("\t\t\t</div>");
        out.println("\t\t</div>");
        out.println("\t\t<div id=\"footer\">");
        out.println("\t\t\t<div id=\"back-link\">");
        out.print("\t\t\t\t<span><a href=\"");
        out.print(request.getContextPath());
        out.println("/\">&uarr; Ir para aplica\u00e7\u00e3o</a></span>");
        out.println("\t\t\t</div>");
        out.println("\t\t\t<div id=\"copyright\">");
        out.println("\t\t\t\t<span>Copyright ");
        out.println("\t\t\t\t\t<script>document.write(new Date().getFullYear())</script>");
        out.println("\t\t\t\t\t&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;<i>Distribu\u00eddo por &nbsp;</i>");
        out.println("\t\t\t\t\t<a href=\"http://www.anteros.com.br\" target=\"_blank\">Anteros Tecnologia</a>");
        out.println("\t\t\t\t</span>");
        out.println("\t\t\t</div>");
        out.println("\t\t</div>");
        out.println("\t</body>");
        out.println("</html>");
    }

    private synchronized byte[] getJQueryMin() throws IOException {
        if (this.jqueryMin == null) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("js/jquery-1.6.4.min.js");
            this.jqueryMin = this.toByteArray(in);
            in.close();
        }
        return this.jqueryMin;
    }

    private synchronized byte[] getJQueryWordWrap() throws IOException {
        if (this.jqueryWordWrap == null) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("js/jquery.wordWrap.js");
            this.jqueryWordWrap = this.toByteArray(in);
            in.close();
        }
        return this.jqueryWordWrap;
    }

    private synchronized byte[] getCSS() throws IOException {
        if (this.css == null) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("css/tracker.css");
            this.css = this.toByteArray(in);
            in.close();
        }
        return this.css;
    }

    private synchronized byte[] getLogo() throws IOException {
        if (this.logo == null) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("img/anteros_logo.png");
            this.logo = this.toByteArray(in);
            in.close();
        }
        return this.logo;
    }

    private synchronized byte[] getFavicon() throws IOException {
        if (this.favicon == null) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("img/favicon.ico");
            this.favicon = this.toByteArray(in);
            in.close();
        }
        return this.favicon;
    }

    private byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StreamUtils.readStream(input, output, 16384);
        return output.toByteArray();
    }
}

