/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros;

import br.com.anteros.generator.AnterosGenerationLog;
import br.com.anteros.generator.AnterosGeneratorManager;
import br.com.anteros.generator.config.AnterosGenerationConfig;
import com.thoughtworks.qdox.model.JavaClass;
import freemarker.template.Configuration;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class AnterosMojo
extends AbstractMojo
implements AnterosGenerationConfig,
AnterosGenerationLog {
    public static final String ANTEROS_SECURITY_MODEL_SQL = "br.com.anteros.security.store.sql.domain*";
    public static final String ANTEROS_SECURITY_MODEL_NO_SQL = "br.com.anteros.security.store.mongo.domain*";
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.name}", required=true)
    private String projectDisplayName;
    @Parameter(defaultValue="${basedir}")
    private String baseDir;
    @Parameter(defaultValue="${basedir}/src/main/java", required=true)
    private String sourceDestination;
    @Parameter(required=true)
    private String packageDestination;
    @Parameter(defaultValue="true")
    private Boolean includeSecurity;
    @Parameter(defaultValue="false")
    private Boolean generateRepository;
    @Parameter(defaultValue="false")
    private Boolean generateService;
    @Parameter(defaultValue="false")
    private Boolean generateController;
    @Parameter(defaultValue="true")
    private boolean generateExceptionHandler;
    @Parameter(defaultValue="false", required=true)
    private Boolean generateJavaConfiguration;
    @Parameter(required=true)
    private List<String> packageScanComponentsList = new ArrayList<String>();
    @Parameter(required=true)
    private List<String> packageScanEntitiesList = new ArrayList<String>();
    @Parameter(defaultValue="")
    private String propertiesFile;
    @Parameter(defaultValue="false")
    private Boolean generateForAbstractClass;
    @Parameter(defaultValue="true")
    private Boolean enabled;
    @Parameter(defaultValue="${project.compileClasspathElements}")
    private List<String> classpathElements;
    @Parameter(defaultValue="sql")
    private String persistenceDatabase;
    @Parameter(defaultValue="sql")
    private String securityPersistenceDatabase;
    @Parameter
    private String remoteEndPointCheckToken;
    @Parameter
    private String securedPattern;
    @Parameter(defaultValue="v1")
    private String resourceVersion;
    @Parameter
    private String resourceID;
    @Parameter
    private Boolean useAnterosOAuth2Server;
    @Parameter(defaultValue="")
    private String clientID;
    @Parameter(defaultValue="")
    private String clientSecret;
    private Log logger;
    private JavaClass clazz;
    private Configuration configuration;

    public void execute() throws MojoExecutionException {
        if (this.enabled.booleanValue()) {
            this.logger = this.getLog();
            try {
                AnterosGeneratorManager.getInstance().generate((AnterosGenerationConfig)this, AnterosMojo.class);
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
    }

    protected List<URL> createClassPath() {
        ArrayList<URL> list = new ArrayList<URL>();
        if (this.classpathElements != null) {
            for (String cpel : this.classpathElements) {
                try {
                    list.add(new File(cpel).toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return list;
    }

    public String getPackageDirectory() {
        return this.sourceDestination + File.separatorChar + this.packageDestination.replace('.', File.separatorChar);
    }

    public JavaClass getClazz() {
        return this.clazz;
    }

    public void setClazz(JavaClass clazz) {
        this.clazz = clazz;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getPackageDestination() {
        return this.packageDestination;
    }

    public String getProjectDisplayName() {
        return this.projectDisplayName;
    }

    public boolean isGenerateForAbstractClass() {
        return this.generateForAbstractClass;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public String getPackageScanEntity() {
        StringBuilder result = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        if (this.packageScanEntitiesList.size() > 0) {
            boolean boAppendDelimiter = false;
            for (String packageScanEntity : this.packageScanEntitiesList) {
                if (boAppendDelimiter) {
                    sb.append(";");
                }
                sb.append(packageScanEntity);
            }
            result.append((CharSequence)sb);
            if (this.includeSecurity.booleanValue()) {
                if (result.toString().length() > 0) {
                    result.append(";");
                }
                if ("sql".equals(this.getSecurityPersistenceDatabase())) {
                    result.append(ANTEROS_SECURITY_MODEL_SQL);
                } else {
                    result.append(ANTEROS_SECURITY_MODEL_NO_SQL);
                }
            }
        }
        return result.toString();
    }

    public List<String> getPackageScanComponentsList() {
        return this.packageScanComponentsList;
    }

    public String getSourceDestination() {
        return this.sourceDestination;
    }

    public boolean isIncludeSecurity() {
        return this.includeSecurity;
    }

    public boolean isGenerateRepository() {
        return this.generateRepository;
    }

    public boolean isGenerateJavaConfiguration() {
        return this.generateJavaConfiguration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void log(String msg) {
        this.logger.info((CharSequence)msg);
    }

    public AnterosGenerationLog getGenerationLog() {
        return this;
    }

    public boolean isGenerateService() {
        return this.generateService;
    }

    public boolean isGenerateController() {
        return this.generateController;
    }

    public List<URL> getClassPathURLs() {
        return this.createClassPath();
    }

    public boolean isGenerateExceptionHandler() {
        return this.generateExceptionHandler;
    }

    public String getPersistenceDatabase() {
        return this.persistenceDatabase;
    }

    public String getSecurityPersistenceDatabase() {
        return this.securityPersistenceDatabase;
    }

    public String remoteEndPointCheckToken() {
        return this.remoteEndPointCheckToken;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public String getSecuredPattern() {
        return this.securedPattern;
    }

    public Boolean isUseAnterosOAuth2Server() {
        return this.useAnterosOAuth2Server;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }
}

