/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.maven.plugin;

import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.maven.plugin.AnterosTemplateLoader;
import br.com.anteros.persistence.metadata.annotation.Entity;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class AnterosMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${basedir}")
    private String baseDir;
    @Parameter(required=true)
    private List<String> sourcesToScanEntities;
    @Parameter(required=true)
    private List<String> packageBaseList;
    @Parameter(defaultValue="${basedir}/src/main/java", required=true)
    private String sourceDestination;
    @Parameter(required=true)
    private String packageDestination;
    @Parameter(defaultValue="true")
    private Boolean includeSecurity;
    @Parameter(defaultValue="false")
    private Boolean generateRepository;
    private Log logger;

    public void execute() throws MojoExecutionException {
        this.logger = this.getLog();
        JavaProjectBuilder builder = this.getBuilder();
        try {
            this.generate(builder);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }

    private void generate(JavaProjectBuilder builder) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, URISyntaxException, TemplateException {
        Configuration configuration = new Configuration();
        configuration.setTemplateLoader((TemplateLoader)new AnterosTemplateLoader(AnterosMojo.class, "templates"));
        String packageDirectory = this.sourceDestination + File.separatorChar + this.packageDestination.replace('.', File.separatorChar);
        FileUtils.forceMkdir((File)new File(packageDirectory));
        for (JavaSource j : builder.getSources()) {
            List classes = j.getClasses();
            for (JavaClass jc : classes) {
                if (!this.isGenerateForClass(jc) || !this.isContainsAnnotation(jc, Entity.class)) continue;
                if (this.includeSecurity.booleanValue()) {
                    this.generateSecurityService(configuration, packageDirectory, jc, this.packageDestination);
                    this.generateController(configuration, packageDirectory, jc, this.packageDestination);
                    if (!this.generateRepository.booleanValue()) continue;
                    this.generateRepository(configuration, packageDirectory, jc, this.packageDestination);
                    continue;
                }
                this.generateService(configuration, packageDirectory, jc, this.packageDestination);
            }
        }
    }

    private void generateService(Configuration configuration, String packageDirectory, JavaClass clazz, String packageName) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        this.logger.info((CharSequence)("Generating class service interface for " + clazz.getName()));
        FileUtils.forceMkdir((File)new File(packageDirectory, "service"));
        FileUtils.forceMkdir((File)new File(packageDirectory, "service" + File.separatorChar + "impl"));
        Template templateServiceInterface = configuration.getTemplate("serviceInterface.ftl");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        String serviceName = clazz.getName() + "Service";
        String entityType = clazz.getName();
        String fullEntityName = clazz.getCanonicalName();
        FileWriter out = null;
        HashMap<String, String> dataModel = new HashMap<String, String>();
        File fileService = new File(packageDirectory + "/service/" + clazz.getName() + "Service.java");
        if (!fileService.exists()) {
            out = new FileWriter(fileService);
            dataModel.put("packageName", this.packageDestination + ".service");
            dataModel.put("serviceName", serviceName);
            dataModel.put("entityType", entityType);
            dataModel.put("importEntity", fullEntityName);
            dataModel.put("time", sdf.format(new Date()));
            templateServiceInterface.process(dataModel, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        Template templateServiceImpl = configuration.getTemplate("serviceImplementation.ftl");
        dataModel = new HashMap();
        File fileServiceImpl = new File(packageDirectory + "/service/impl/" + clazz.getName() + "ServiceImpl.java");
        if (!fileServiceImpl.exists()) {
            out = new FileWriter(fileServiceImpl);
            dataModel.put("packageName", this.packageDestination + ".service.impl");
            dataModel.put("importEntity", fullEntityName);
            dataModel.put("importService", this.packageDestination + ".service." + clazz.getName() + "Service");
            dataModel.put("serviceNameImpl", serviceName + "Impl");
            dataModel.put("interfaceService", serviceName);
            dataModel.put("entityType", entityType);
            dataModel.put("time", sdf.format(new Date()));
            templateServiceImpl.process(dataModel, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
    }

    private void generateSecurityService(Configuration configuration, String packageDirectory, JavaClass clazz, String packageName) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        this.logger.info((CharSequence)("Generating class security service interface for " + clazz.getName()));
        FileUtils.forceMkdir((File)new File(packageDirectory, "service"));
        FileUtils.forceMkdir((File)new File(packageDirectory, "service" + File.separatorChar + "impl"));
        Template templateServiceInterface = configuration.getTemplate("securityServiceInterface.ftl");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        String serviceName = clazz.getName() + "Service";
        String entityType = clazz.getName();
        String fullEntityName = clazz.getCanonicalName();
        FileWriter out = null;
        HashMap<String, String> dataModel = new HashMap<String, String>();
        File fileService = new File(packageDirectory + "/service/" + clazz.getName() + "Service.java");
        if (!fileService.exists()) {
            out = new FileWriter(fileService);
            dataModel.put("packageName", this.packageDestination + ".service");
            dataModel.put("resourceName", clazz.getName());
            dataModel.put("resourceDescription", clazz.getName());
            dataModel.put("serviceName", serviceName);
            dataModel.put("entityType", entityType);
            dataModel.put("importEntity", fullEntityName);
            dataModel.put("time", sdf.format(new Date()));
            templateServiceInterface.process(dataModel, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        Template templateServiceImpl = configuration.getTemplate("securityServiceImplementation.ftl");
        dataModel = new HashMap();
        File fileServiceImpl = new File(packageDirectory + "/service/impl/" + clazz.getName() + "ServiceImpl.java");
        if (!fileServiceImpl.exists()) {
            out = new FileWriter(fileServiceImpl);
            dataModel.put("packageName", this.packageDestination + ".service.impl");
            dataModel.put("importEntity", fullEntityName);
            dataModel.put("importService", this.packageDestination + ".service." + clazz.getName() + "Service");
            dataModel.put("service", StringUtils.uncapitalize((String)serviceName));
            dataModel.put("serviceNameImpl", serviceName + "Impl");
            dataModel.put("interfaceService", serviceName);
            dataModel.put("entityType", entityType);
            dataModel.put("time", sdf.format(new Date()));
            templateServiceImpl.process(dataModel, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
    }

    private void generateController(Configuration configuration, String packageDirectory, JavaClass clazz, String packageName) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        this.logger.info((CharSequence)("Generating class controller for " + clazz.getName()));
        FileUtils.forceMkdir((File)new File(packageDirectory, "controller"));
        Template templateServiceInterface = configuration.getTemplate("restController.ftl");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        String serviceName = clazz.getName() + "Service";
        String entityType = clazz.getName();
        String fullEntityName = clazz.getCanonicalName();
        FileWriter out = null;
        HashMap<String, String> dataModel = new HashMap<String, String>();
        File fileService = new File(packageDirectory + "/controller/" + clazz.getName() + "Controller.java");
        if (!fileService.exists()) {
            out = new FileWriter(fileService);
            dataModel.put("packageName", this.packageDestination + ".controller");
            dataModel.put("serviceName", serviceName);
            dataModel.put("entityType", entityType);
            dataModel.put("importEntity", fullEntityName);
            dataModel.put("importService", this.packageDestination + ".service." + clazz.getName() + "Service");
            dataModel.put("time", sdf.format(new Date()));
            dataModel.put("requestMapping", "/" + StringUtils.uncapitalize((String)clazz.getName()));
            dataModel.put("controller", clazz.getName() + "Controller");
            dataModel.put("interfaceService", serviceName);
            dataModel.put("service", StringUtils.uncapitalize((String)serviceName));
            templateServiceInterface.process(dataModel, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
    }

    private void generateRepository(Configuration configuration, String packageDirectory, JavaClass clazz, String packageName) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        this.logger.info((CharSequence)("Generating class repository interface for " + clazz.getName()));
        FileUtils.forceMkdir((File)new File(packageDirectory, "repository"));
        FileUtils.forceMkdir((File)new File(packageDirectory, "repository" + File.separatorChar + "impl"));
        Template templateServiceInterface = configuration.getTemplate("repositoryInterface.ftl");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        String repositoryName = clazz.getName() + "Repository";
        String entityType = clazz.getName();
        String fullEntityName = clazz.getCanonicalName();
        FileWriter out = null;
        HashMap<String, String> dataModel = new HashMap<String, String>();
        File fileService = new File(packageDirectory + "/repository/" + clazz.getName() + "Repository.java");
        if (!fileService.exists()) {
            out = new FileWriter(fileService);
            dataModel.put("packageName", this.packageDestination + ".repository");
            dataModel.put("repositoryName", repositoryName);
            dataModel.put("entityType", entityType);
            dataModel.put("importEntity", fullEntityName);
            dataModel.put("time", sdf.format(new Date()));
            templateServiceInterface.process(dataModel, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        Template templateServiceImpl = configuration.getTemplate("repositoryImplementation.ftl");
        dataModel = new HashMap();
        File fileServiceImpl = new File(packageDirectory + "/repository/impl/" + clazz.getName() + "RepositoryImpl.java");
        if (!fileServiceImpl.exists()) {
            out = new FileWriter(fileServiceImpl);
            dataModel.put("packageName", this.packageDestination + ".repository.impl");
            dataModel.put("importEntity", fullEntityName);
            dataModel.put("importRepository", this.packageDestination + ".repository." + clazz.getName() + "Repository");
            dataModel.put("repository", StringUtils.uncapitalize((String)repositoryName));
            dataModel.put("repositoryNameImpl", repositoryName + "Impl");
            dataModel.put("repositoryName", repositoryName);
            dataModel.put("entityType", entityType);
            dataModel.put("time", sdf.format(new Date()));
            templateServiceImpl.process(dataModel, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
    }

    private boolean isContainsAnnotation(JavaClass jc, Class<?> ac) {
        for (JavaAnnotation ja : jc.getAnnotations()) {
            if (!ja.getType().toString().equals(ac.getName())) continue;
            return true;
        }
        return false;
    }

    private JavaProjectBuilder getBuilder() {
        JavaProjectBuilder docBuilder = new JavaProjectBuilder();
        for (String r : this.sourcesToScanEntities) {
            docBuilder.addSourceTree(new File(r));
        }
        return docBuilder;
    }

    private boolean isGenerateForClass(JavaClass sourceJavaClass) {
        String classPackage = sourceJavaClass.getPackageName();
        if (this.packageBaseList != null) {
            for (String source : this.packageBaseList) {
                if (!classPackage.startsWith(source)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

