/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.flatfile.type.component;

import br.com.anteros.core.utils.Assert;
import br.com.anteros.core.utils.ObjectUtils;
import br.com.anteros.flatfile.type.Filler;
import br.com.anteros.flatfile.type.component.Field;
import java.text.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedField<G>
extends Field<G>
implements br.com.anteros.flatfile.type.FixedField<G> {
    private Integer length;
    private Filler filler;
    private Integer instantLength;
    private boolean truncate;

    public FixedField() {
    }

    public FixedField(G value, Integer length) {
        super(value);
        this.setFixedLength(length);
    }

    public FixedField(G value, Integer length, Filler filler) {
        super(value);
        this.setFixedLength(length);
        this.setFiller(filler);
    }

    public FixedField(G value, Integer length, Format formatter) {
        super(value, formatter);
        this.setFixedLength(length);
    }

    public FixedField(G value, Integer length, Format formatter, Filler filler) {
        super(value, formatter);
        this.setFixedLength(length);
        this.setFiller(filler);
    }

    public FixedField(String name, G value, Integer length) {
        super(name, value);
        this.setFixedLength(length);
    }

    public FixedField(String name, G value, Integer length, Filler filler) {
        super(name, value);
        this.setFixedLength(length);
        this.setFiller(filler);
    }

    public FixedField(String name, G value, Integer length, Format formatter) {
        super(name, value, formatter);
        this.setFixedLength(length);
    }

    public FixedField(String name, G value, Integer length, Format formatter, Filler filler) {
        super(name, value, formatter);
        this.setFixedLength(length);
        this.setFiller(filler);
    }

    @Override
    public FixedField<G> clone() throws CloneNotSupportedException {
        return (FixedField)super.clone();
    }

    @Override
    public void read(String str) {
        Assert.notNull((Object)str, (String)"String inv\u00e1lida [null]!");
        if (str.length() != this.getFixedLength().intValue()) {
            throw new IllegalArgumentException(String.format("Tamanho da string [%s] diferente do especificado [%s]! %s", str.length(), this.getFixedLength(), this.toString()));
        }
        super.read(str);
    }

    @Override
    public String write() {
        String str = this.fill(super.write());
        this.instantLength = str.length();
        if (this.isTruncate() && this.instantLength > this.getFixedLength()) {
            str = str.substring(0, this.getFixedLength());
            this.instantLength = this.getFixedLength();
        }
        this.isFixedAsDefined();
        return str;
    }

    private String fill(String str) {
        if (ObjectUtils.isNotNull((Object)this.filler)) {
            str = this.filler.fill(str, (int)this.length);
        }
        return str;
    }

    @Override
    public boolean isFixedAsDefined() throws IllegalStateException {
        if (this.instantLength.equals(this.getFixedLength())) {
            return true;
        }
        throw new IllegalStateException(String.format("Tamanho da string [%s] diferente do especificado [%s]! %s", this.instantLength, this.getFixedLength(), this.toString()));
    }

    @Override
    public Integer getFixedLength() {
        return this.length;
    }

    public void setFixedLength(Integer length) {
        if (!ObjectUtils.isNotNull((Object)length) || length <= 0) {
            throw new IllegalArgumentException(String.format("Comprimento inv\u00e1lido [%s]!", length));
        }
        this.length = length;
    }

    @Override
    public Filler getFiller() {
        return this.filler;
    }

    @Override
    public void setFiller(Filler filler) {
        if (!ObjectUtils.isNotNull((Object)filler)) {
            throw new IllegalArgumentException(String.format("Preenchedor inv\u00e1lido [%s]!", filler));
        }
        this.filler = filler;
    }

    @Override
    public boolean isTruncate() {
        return this.truncate;
    }

    @Override
    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    @Override
    public String toString() {
        return String.format("%s FixedField [length=%s, instantLength=%s, filler=%s, truncate=%s]", super.toString(), ObjectUtils.whenNull((Object)this.length, (Object)""), ObjectUtils.whenNull((Object)this.instantLength, (Object)""), ObjectUtils.whenNull((Object)this.filler, (Object)""), ObjectUtils.whenNull((Object)this.truncate, (Object)""));
    }
}

