/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.flatfile.type.component;

import br.com.anteros.core.utils.Assert;
import br.com.anteros.core.utils.DateUtil;
import br.com.anteros.core.utils.ObjectUtils;
import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.flatfile.TextStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field<G>
implements br.com.anteros.flatfile.type.Field<G> {
    private String name;
    private G value;
    private Format formatter;
    private boolean blankAccepted;

    public Field() {
    }

    public Field(G value) {
        this.setValue(value);
    }

    public Field(G value, Format formatter) {
        this.setValue(value);
        this.setFormatter(formatter);
    }

    public Field(String name, G value) {
        this.setName(name);
        this.setValue(value);
    }

    public Field(String name, G value, Format formatter) {
        this.setName(name);
        this.setValue(value);
        this.setFormatter(formatter);
    }

    @Override
    public Field<G> clone() throws CloneNotSupportedException {
        return (Field)super.clone();
    }

    @Override
    public void read(String str) {
        Assert.notNull((Object)str, (String)"String inv\u00e1lida [null]!");
        try {
            if (this.value instanceof TextStream) {
                TextStream reader = (TextStream)this.value;
                reader.read(str);
            } else if (this.value instanceof BigDecimal) {
                this.readDecimalField(str);
            } else if (this.value instanceof Date) {
                this.readDateField(str);
            } else if (this.value instanceof Character) {
                this.readCharacter(str);
            } else {
                this.readStringOrNumericField(str);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Falha na leitura do campo! %s", this.toString()), e);
        }
    }

    private void readCharacter(String str) {
        if (str.length() != 1) {
            throw new IllegalArgumentException("String com mais de 1 character!");
        }
        this.value = new Character(str.charAt(0));
    }

    private void readDecimalField(String str) {
        DecimalFormat decimalFormat = (DecimalFormat)this.formatter;
        try {
            String number = this.parseNumber(str);
            Long parsedValue = (Long)this.formatter.parseObject(number);
            BigDecimal decimalValue = new BigDecimal(parsedValue);
            decimalValue = decimalValue.movePointLeft(decimalFormat.getMaximumFractionDigits());
            this.value = decimalValue;
        }
        catch (ParseException e) {
            this.throwReadError(e, str);
        }
    }

    private void readDateField(String str) {
        try {
            if (StringUtils.isBlank((CharSequence)str) || StringUtils.repeat((String)"0", (int)str.length()).equals(str)) {
                if (this.isBlankAccepted()) {
                    this.value = null;
                } else {
                    new IllegalArgumentException(String.format("Campo data vazio n\u00e3o permitido: [%s]!", str));
                }
            } else {
                this.value = this.formatter.parseObject(str);
            }
        }
        catch (ParseException e) {
            this.throwReadError(e, str);
        }
    }

    private void readStringOrNumericField(String str) {
        str = this.parseNumber(str.trim());
        Class<?> clazz = this.value.getClass();
        if (clazz.equals(String.class)) {
            this.value = str.trim();
        } else {
            this.readNumeric(clazz, str.trim());
        }
    }

    private void readNumeric(Class<?> clazz, String str) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> cons = constructorArray[n2];
            if (cons.getParameterTypes().length == 1 && cons.getParameterTypes()[0].equals(String.class)) {
                try {
                    this.value = cons.newInstance(str.trim());
                }
                catch (Exception e) {
                    this.throwReadError(e, str);
                }
            }
            ++n2;
        }
    }

    @Override
    public String write() {
        try {
            String str = null;
            if (this.value instanceof TextStream) {
                TextStream its = (TextStream)this.value;
                str = (String)its.write();
            } else {
                str = this.value instanceof Date ? this.writeDateField() : (this.value instanceof BigDecimal ? this.writeDecimalField() : this.value.toString());
            }
            return str;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Falha na escrita do campo escrita! %s", this.toString()), e);
        }
    }

    private String writeDecimalField() {
        BigDecimal decimalValue = (BigDecimal)this.value;
        decimalValue = decimalValue.movePointRight(((DecimalFormat)this.formatter).getMaximumFractionDigits());
        return decimalValue.toString();
    }

    private String writeDateField() {
        if (!this.getInvalidDate().equals((Date)this.value)) {
            return this.formatter.format(this.value);
        }
        return "";
    }

    private String parseNumber(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            if (this.isBlankAccepted()) {
                str = "0";
            } else {
                new IllegalArgumentException(String.format("Campo num\u00e9rico vazio n\u00e3o permitido: [%s]!", str));
            }
        } else if (!StringUtils.isNumber((String)str)) {
            new IllegalArgumentException(String.format("O campo deve ser num\u00e9rico e n\u00e3o: [%s]!", str));
        }
        return str;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!StringUtils.isNotEmpty((String)name)) {
            throw new IllegalArgumentException(String.format("Nome Inv\u00e1lido: [%s]!", name));
        }
        this.name = name;
    }

    @Override
    public boolean isBlankAccepted() {
        return this.blankAccepted;
    }

    @Override
    public void setBlankAccepted(boolean blankAccepted) {
        this.blankAccepted = blankAccepted;
    }

    @Override
    public G getValue() {
        return this.value;
    }

    @Override
    public void setValue(G value) {
        if (!ObjectUtils.isNotNull(value)) {
            throw new IllegalArgumentException(String.format("Valor Inv\u00e1lido: [%s]!", value));
        }
        this.value = value;
    }

    @Override
    public Format getFormatter() {
        return this.formatter;
    }

    @Override
    public void setFormatter(Format formatter) {
        if (!ObjectUtils.isNotNull((Object)formatter)) {
            throw new IllegalArgumentException(String.format("Formato inv\u00e1lido: [%s]!", formatter));
        }
        this.formatter = formatter;
    }

    private void throwReadError(Exception e, String value) {
        throw new IllegalArgumentException(String.format("Falha na leitura da string: [\"%s\"]! %s", value, this.toString()), e);
    }

    private Date getInvalidDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0, 1);
        calendar.setLenient(false);
        return DateUtil.truncate((Date)calendar.getTime(), (int)1);
    }

    public String toString() {
        return "Field [name=" + this.name + ", value=" + this.value + ", formatter=" + this.formatter + ", blankAccepted=" + this.blankAccepted + "]";
    }

    public void clearName() {
        this.name = "";
    }
}

