/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.flatfile.type.component;

import br.com.anteros.core.utils.Assert;
import br.com.anteros.core.utils.ObjectUtils;
import br.com.anteros.flatfile.type.AbstractStringOfFields;
import br.com.anteros.flatfile.type.FixedLength;
import br.com.anteros.flatfile.type.FixedSize;
import br.com.anteros.flatfile.type.component.FixedField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockOfFields
extends AbstractStringOfFields<FixedField<?>>
implements FixedSize,
FixedLength {
    private Integer length;
    private Integer size;
    private Integer instantLength;
    private boolean truncate;

    public BlockOfFields() {
    }

    public BlockOfFields(Integer length, Integer size) {
        super(size);
        Assert.notNull((Object)length, (String)"length");
        if (length <= 0) {
            throw new IllegalArgumentException(String.format("O comprimento do bloco [%s] deve ser um n\u00famero natural > 0!", length));
        }
        this.setLength(length);
        this.setSize(size);
    }

    @Override
    public BlockOfFields clone() throws CloneNotSupportedException {
        return (BlockOfFields)super.clone();
    }

    @Override
    public void read(String lineOfFields) {
        Assert.notNull((Object)lineOfFields, (String)"String de leitura nula!");
        Assert.notNull(this.getFields(), (String)"Fields == null");
        Assert.notEmpty(this.getFields(), (String)"Cole\u00e7\u00e3o de fields vazia!");
        if (this.isSizeAsDefined() && this.isLengthWithDefined(lineOfFields.length())) {
            StringBuilder builder = new StringBuilder(lineOfFields);
            for (FixedField field : this.getFields()) {
                try {
                    field.read(builder.substring(0, field.getFixedLength()));
                    builder.delete(0, field.getFixedLength());
                }
                catch (Exception e) {
                    throw new IllegalStateException(String.format("Erro ao tentar ler o campo \"%s\" na posi\u00e7\u00e3o [%s] no layout do registro.", field.getName(), this.getFields().indexOf(field) + 1), e);
                }
            }
            Object var2_2 = null;
        }
    }

    @Override
    public String write() {
        Assert.notNull(this.getFields(), (String)"Fields == null");
        Assert.notEmpty(this.getFields(), (String)"Cole\u00e7\u00e3o de fields vazia!");
        String str = null;
        this.isSizeAsDefined();
        str = super.write();
        this.instantLength = str.length();
        if (this.isTruncate() && this.instantLength > this.getFixedLength()) {
            str = str.substring(0, this.getFixedLength());
            this.instantLength = this.getFixedLength();
        }
        this.isFixedAsDefined();
        return str;
    }

    @Override
    public boolean isFixedAsDefined() throws IllegalStateException {
        return this.isSizeAsDefined() && this.isLengthWithDefined();
    }

    private boolean isLengthWithDefined() {
        return this.isLengthWithDefined(this.instantLength);
    }

    private boolean isLengthWithDefined(int length) {
        if (length == this.getFixedLength()) {
            return true;
        }
        throw new IllegalStateException(String.format("O comprimento da string [%s] \u00e9 incompat\u00edvel com o definido [%s] no layout do registro!", length, this.getFixedLength()));
    }

    private boolean isSizeAsDefined() {
        if (this.size() == this.getFixedSize().intValue()) {
            return true;
        }
        throw new IllegalStateException(String.format("O n\u00famero de fields [%s] \u00e9 incompat\u00edvel com o definido [%s]!", this.size(), this.getFixedSize()));
    }

    @Override
    public Integer getFixedLength() {
        return this.length;
    }

    protected void setLength(Integer length) {
        if (!ObjectUtils.isNotNull((Object)length)) {
            throw new IllegalArgumentException(String.format("Comprimento inv\u00e1lido [%s]!", length));
        }
        this.length = length;
    }

    @Override
    public Integer getFixedSize() {
        return this.size;
    }

    protected void setSize(Integer size) {
        if (!ObjectUtils.isNotNull((Object)size)) {
            throw new IllegalArgumentException(String.format("Tamanho inv\u00e1lido [%s]!", size));
        }
        this.size = size;
    }

    @Override
    public boolean isTruncate() {
        return this.truncate;
    }

    @Override
    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }
}

