/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.flatfile.type;

import br.com.anteros.core.utils.Assert;
import br.com.anteros.flatfile.TextStream;
import br.com.anteros.flatfile.type.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStringOfFields<G extends Field<?>>
implements TextStream,
List<G>,
Cloneable {
    private ArrayList<G> fields;

    public AbstractStringOfFields() {
        this.fields = new ArrayList();
    }

    public AbstractStringOfFields(Integer size) {
        Assert.notNull((Object)size, (String)"size");
        if (size > 0) {
            this.fields = new ArrayList(size);
            int i = 1;
            while (i <= size) {
                this.fields.add(null);
                ++i;
            }
        } else {
            throw new IllegalArgumentException(String.format("A quantidade de campos [%s] deve ser um n\u00famero natural > 0!", size));
        }
    }

    protected AbstractStringOfFields<G> clone() throws CloneNotSupportedException {
        AbstractStringOfFields sof = (AbstractStringOfFields)super.clone();
        sof.fields = new ArrayList();
        for (Field gf : this.fields) {
            sof.fields.add(gf.clone());
        }
        return sof;
    }

    @Override
    public abstract void read(String var1);

    @Override
    public String write() {
        StringBuilder lineOfFields = new StringBuilder("");
        Assert.notNull(this.fields, (String)"Fields == null");
        Assert.notEmpty(this.fields, (String)"Cole\u00e7\u00e3o de fields vazia!");
        for (Field field : this.fields) {
            try {
                lineOfFields.append((String)field.write());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Erro ao tentar escrever o campo \"%s\" com valor [%s] na posi\u00e7\u00e3o [%s] no layout do registro.", field.getName(), field.getValue(), this.fields.indexOf(field) + 1), e);
            }
        }
        return lineOfFields.toString();
    }

    public List<G> getFields() {
        return this.fields;
    }

    @Override
    public boolean add(G e) {
        return this.fields.add(e);
    }

    @Override
    public void add(int index, G element) {
        this.fields.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends G> c) {
        return this.fields.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends G> c) {
        return this.fields.addAll(index, c);
    }

    @Override
    public void clear() {
        this.fields.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.fields.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.fields.containsAll(c);
    }

    @Override
    public G get(int index) {
        return (G)((Field)this.fields.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.fields.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public Iterator<G> iterator() {
        return this.fields.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.fields.indexOf(o);
    }

    @Override
    public ListIterator<G> listIterator() {
        return this.fields.listIterator();
    }

    @Override
    public ListIterator<G> listIterator(int index) {
        return this.fields.listIterator(index);
    }

    @Override
    public G remove(int index) {
        return (G)((Field)this.fields.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        return this.fields.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.fields.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.fields.retainAll(c);
    }

    @Override
    public G set(int index, G element) {
        return (G)((Field)this.fields.set(index, element));
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public List<G> subList(int fromIndex, int toIndex) {
        return this.fields.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.fields.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.fields.toArray(a);
    }
}

