/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.flatfile.engine;

import br.com.anteros.core.utils.DateUtil;
import br.com.anteros.core.utils.ObjectUtils;
import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.flatfile.TexgitException;
import br.com.anteros.flatfile.language.EnumFormats;
import br.com.anteros.flatfile.language.EnumFormatsTypes;
import br.com.anteros.flatfile.language.MetaField;
import br.com.anteros.flatfile.type.component.Filler;
import br.com.anteros.flatfile.type.component.Fillers;
import br.com.anteros.flatfile.type.component.FixedField;
import br.com.anteros.flatfile.type.component.Side;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FixedFieldBuilder {
    private static final String BASE_DECIMAL_FORMAT = "0.";

    FixedFieldBuilder() {
    }

    static FixedField<?> build(MetaField metaField) {
        FixedField<?> fixedField = null;
        try {
            fixedField = FixedFieldBuilder.getInstance(metaField);
        }
        catch (ParseException e) {
            throw new TexgitException("Field: " + metaField.getName(), e);
        }
        return fixedField;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FixedField<?> getInstance(MetaField metaField) throws ParseException {
        FixedField<String> fField = null;
        Format formatter = FixedFieldBuilder.getFormater(metaField);
        switch (metaField.getType()) {
            case CHARACTER: {
                FixedField<Character> fCHR = new FixedField<Character>();
                if (StringUtils.isNotBlank((CharSequence)metaField.getValue())) {
                    if (metaField.getValue().length() != 1) throw new IllegalArgumentException("Tipo character deve ter apenas 1!");
                    fCHR.setValue(Character.valueOf(metaField.getValue().charAt(0)));
                } else {
                    fCHR.setValue(Character.valueOf(' '));
                }
                fField = fCHR;
                break;
            }
            case STRING: {
                FixedField<String> fSTR = new FixedField<String>();
                if (StringUtils.isNotBlank((CharSequence)metaField.getValue())) {
                    fSTR.setValue(metaField.getValue());
                } else {
                    fSTR.setValue("");
                }
                fField = fSTR;
                break;
            }
            case INTEGER: {
                FixedField<Integer> fINT = new FixedField<Integer>();
                if (StringUtils.isNotBlank((CharSequence)metaField.getValue())) {
                    fINT.setValue(Integer.parseInt(metaField.getValue()));
                } else {
                    fINT.setValue(0);
                }
                fField = fINT;
                break;
            }
            case LONG: {
                FixedField<Long> fLNG = new FixedField<Long>();
                if (StringUtils.isNotBlank((CharSequence)metaField.getValue())) {
                    fLNG.setValue(Long.parseLong(metaField.getValue()));
                } else {
                    fLNG.setValue(0L);
                }
                fField = fLNG;
                break;
            }
            case FLOAT: {
                FixedField<Float> fFLT = new FixedField<Float>();
                if (StringUtils.isNotBlank((CharSequence)metaField.getValue())) {
                    fFLT.setValue(Float.valueOf(Float.parseFloat(metaField.getValue())));
                } else {
                    fFLT.setValue(Float.valueOf(0.0f));
                }
                fField = fFLT;
                break;
            }
            case DOUBLE: {
                FixedField<Double> fDBE = new FixedField<Double>();
                if (StringUtils.isNotBlank((CharSequence)metaField.getValue())) {
                    fDBE.setValue(Double.parseDouble(metaField.getValue()));
                } else {
                    fDBE.setValue(0.0);
                }
                fField = fDBE;
                break;
            }
            case BIGDECIMAL: {
                FixedField<BigDecimal> fBDL = new FixedField<BigDecimal>();
                if (StringUtils.isNotBlank((CharSequence)metaField.getValue())) {
                    fBDL.setValue(new BigDecimal(((DecimalFormat)DecimalFormat.class.cast(formatter)).parse(metaField.getValue()).doubleValue()));
                } else {
                    fBDL.setValue(BigDecimal.ZERO);
                }
                fField = fBDL;
                break;
            }
            case DATE: {
                FixedField<Date> fDTE = new FixedField<Date>();
                if (StringUtils.isNotBlank((CharSequence)metaField.getValue())) {
                    fDTE.setValue(((DateFormat)DateFormat.class.cast(formatter)).parse(metaField.getValue()));
                } else {
                    fDTE.setValue(FixedFieldBuilder.getInvalidDate());
                }
                fField = fDTE;
            }
        }
        fField.setName(metaField.getName());
        fField.setFixedLength(metaField.getLength());
        fField.setFiller(FixedFieldBuilder.getFiller(metaField));
        fField.setBlankAccepted(metaField.isBlankAccepted());
        fField.setTruncate(metaField.isTruncate());
        if (!ObjectUtils.isNotNull((Object)formatter)) return fField;
        fField.setFormatter(formatter);
        return fField;
    }

    private static Date getInvalidDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0, 1);
        calendar.setLenient(false);
        return DateUtil.truncate((Date)calendar.getTime(), (int)1);
    }

    private static br.com.anteros.flatfile.type.Filler getFiller(MetaField metaField) {
        br.com.anteros.flatfile.type.Filler filler = null;
        if (ObjectUtils.isNotNull((Object)metaField.getFiller())) {
            Filler<String> filr = new Filler<String>();
            filr.setPadding(metaField.getFiller().getPadding());
            filr.setSideToFill(Side.valueOf(metaField.getFiller().getSideToFill().name()));
            filler = filr;
        } else {
            filler = Fillers.valueOf(metaField.getPadding().name());
        }
        return filler;
    }

    private static Format getFormater(MetaField metaField) {
        Format formatter = null;
        if (ObjectUtils.isNotNull((Object)metaField.getFormatter())) {
            formatter = FixedFieldBuilder.buildFormat(metaField.getFormatter().getFormat(), metaField.getFormatter().getType());
        } else if (ObjectUtils.isNotNull((Object)((Object)metaField.getFormat()))) {
            EnumFormats format = metaField.getFormat();
            EnumFormatsTypes type = EnumFormatsTypes.valueOf(format.name().split("_")[0]);
            formatter = FixedFieldBuilder.buildFormat(FixedFieldBuilder.buildFormat(format, type), type);
        }
        return formatter;
    }

    private static Format buildFormat(String strFormat, EnumFormatsTypes type) {
        Format format = null;
        switch (type) {
            case DATE: {
                format = new SimpleDateFormat(strFormat);
                break;
            }
            case DECIMAL: {
                format = new DecimalFormat(strFormat);
            }
        }
        return format;
    }

    private static String buildFormat(EnumFormats format, EnumFormatsTypes type) {
        String strFormat = "";
        String defFormat = format.name().split("_")[1];
        switch (type) {
            case DATE: {
                defFormat = defFormat.replaceAll("D", "d");
                strFormat = defFormat.replaceAll("Y", "y");
                break;
            }
            case DECIMAL: {
                int lengthToFill = BASE_DECIMAL_FORMAT.length() + StringUtils.countOccurrencesOf((String)defFormat, (String)"D");
                strFormat = Fillers.ZERO_RIGHT.fill(BASE_DECIMAL_FORMAT, lengthToFill);
            }
        }
        return strFormat;
    }
}

