/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.flatfile;

import br.com.anteros.core.utils.ObjectUtils;
import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.flatfile.FlatFile;
import br.com.anteros.flatfile.Record;
import br.com.anteros.flatfile.TexgitException;
import br.com.anteros.flatfile.engine.TexgitManager;
import br.com.anteros.flatfile.language.MetaTexgit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Texgit {
    public static final FlatFile<Record> createFlatFile(String xmlDefFilePath) throws TexgitException {
        try {
            if (StringUtils.isNotBlank((CharSequence)xmlDefFilePath)) {
                return Texgit.createFlatFile(new File(xmlDefFilePath));
            }
        }
        catch (Exception e) {
            throw new TexgitException(e);
        }
        return null;
    }

    public static final FlatFile<Record> createFlatFile(File xmlDefFile) throws TexgitException {
        try {
            if (ObjectUtils.isNotNull((Object)xmlDefFile)) {
                return Texgit.createFlatFile(new FileInputStream(xmlDefFile));
            }
        }
        catch (Exception e) {
            throw new TexgitException(e);
        }
        return null;
    }

    public static final FlatFile<Record> createFlatFile(URL xmlDefUrl) throws TexgitException {
        try {
            if (ObjectUtils.isNotNull((Object)xmlDefUrl)) {
                return TexgitManager.buildFlatFile(xmlDefUrl.openStream());
            }
        }
        catch (Exception e) {
            throw new TexgitException(e);
        }
        return null;
    }

    public static final FlatFile<Record> createFlatFile(byte[] xmlDefBytes) throws TexgitException {
        try {
            if (ObjectUtils.isNotNull((Object)xmlDefBytes)) {
                return TexgitManager.buildFlatFile(new ByteArrayInputStream(xmlDefBytes));
            }
        }
        catch (Exception e) {
            throw new TexgitException(e);
        }
        return null;
    }

    public static final FlatFile<Record> createFlatFile(MetaTexgit tgMeta) throws TexgitException {
        try {
            if (ObjectUtils.isNotNull((Object)tgMeta)) {
                return TexgitManager.buildFlatFile(tgMeta);
            }
        }
        catch (Exception e) {
            throw new TexgitException(e);
        }
        return null;
    }

    public static final FlatFile<Record> createFlatFile(InputStream xmlDefStream) throws TexgitException {
        if (ObjectUtils.isNotNull((Object)xmlDefStream)) {
            return TexgitManager.buildFlatFile(xmlDefStream);
        }
        return null;
    }
}

