/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.flatfile;

import br.com.anteros.core.utils.Assert;
import br.com.anteros.core.utils.IOUtils;
import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.flatfile.FlatFileManagerException;
import br.com.anteros.flatfile.Texgit;
import br.com.anteros.flatfile.annotation.Field;
import br.com.anteros.flatfile.annotation.FlatFile;
import br.com.anteros.flatfile.annotation.Formats;
import br.com.anteros.flatfile.annotation.IdType;
import br.com.anteros.flatfile.annotation.InnerRecord;
import br.com.anteros.flatfile.annotation.Record;
import br.com.anteros.flatfile.annotation.RecordData;
import br.com.anteros.flatfile.language.EnumTypes;
import br.com.anteros.flatfile.language.MetaField;
import br.com.anteros.flatfile.language.MetaFlatFile;
import br.com.anteros.flatfile.language.MetaGroupFields;
import br.com.anteros.flatfile.language.MetaGroupRecords;
import br.com.anteros.flatfile.language.MetaLayout;
import br.com.anteros.flatfile.language.MetaOrderedField;
import br.com.anteros.flatfile.language.MetaRecord;
import br.com.anteros.flatfile.language.MetaTexgit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatFileManager {
    private MetaTexgit metadata;

    private byte[] readAnnotations(Object model, String[] groups) throws FlatFileManagerException, JAXBException {
        this.metadata = new MetaTexgit();
        FlatFile flatFileAnnotation = model.getClass().getAnnotation(FlatFile.class);
        MetaLayout metaLayout = new MetaLayout();
        metaLayout.setName(flatFileAnnotation.name());
        metaLayout.setDescription(flatFileAnnotation.description());
        metaLayout.setVersion(flatFileAnnotation.version());
        MetaFlatFile metaFlatFile = new MetaFlatFile();
        metaFlatFile.setLayout(metaLayout);
        MetaGroupRecords metaGroupRecords = new MetaGroupRecords();
        metaFlatFile.setGroupOfRecords(metaGroupRecords);
        java.lang.reflect.Field[] fields = ReflectionUtils.getAllDeclaredFields(model.getClass());
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(model.getClass());
        LinkedHashSet<java.lang.reflect.Field> fieldsSet = new LinkedHashSet<java.lang.reflect.Field>();
        fieldsSet.addAll(Arrays.asList(fields));
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            java.lang.reflect.Field fieldByMethodSetter = ReflectionUtils.getFieldByMethodSetter((Method)method);
            if (fieldByMethodSetter != null) {
                fieldsSet.add(fieldByMethodSetter);
            }
            ++n2;
        }
        List<Record> records = this.readRecords(fieldsSet);
        for (Record annotation : records) {
            if (!this.isContainsGroups(groups, annotation.groups()) && groups.length != 0) continue;
            java.lang.reflect.Field field = this.getFieldByRecord(fieldsSet, annotation);
            MetaRecord metaRecord = new MetaRecord();
            metaRecord.setDescription(annotation.description());
            metaRecord.setName(annotation.name());
            metaRecord.setRepeatable(annotation.repeatable());
            metaRecord.setField(field);
            metaRecord.setGroups(annotation.groups());
            if (annotation.repeatable() && !ReflectionUtils.isImplementsInterface(field.getType(), RecordData.class)) {
                throw new FlatFileManagerException("A classe " + field.getType().getName() + " n\u00e3o implementa a interface RecordData.");
            }
            metaGroupRecords.getRecords().add(metaRecord);
            MetaGroupFields metaGroupFields = new MetaGroupFields();
            metaRecord.setGroupOfFields(metaGroupFields);
            this.readFields(metaGroupFields, field.getType());
            if (!metaGroupFields.getFields().isEmpty()) continue;
            throw new FlatFileManagerException("N\u00e3o foram encontrados campos para o registro " + annotation.name());
        }
        List<InnerRecord> innerRecords = this.readInnerRecords(fieldsSet);
        for (InnerRecord annotation : innerRecords) {
            if (!this.isContainsGroups(groups, annotation.groups()) && groups.length != 0) continue;
            java.lang.reflect.Field field = this.getFieldByInnerRecord(fieldsSet, annotation);
            MetaRecord recordOwner = this.findRecordOwner(metaFlatFile, annotation.recordOwner());
            MetaRecord innerRecord = new MetaRecord();
            if (recordOwner.getGroupOfInnerRecords() == null) {
                recordOwner.setGroupOfInnerRecords(new MetaGroupRecords());
            }
            recordOwner.getGroupOfInnerRecords().getRecords().add(innerRecord);
            innerRecord.setName(annotation.name());
            innerRecord.setDescription(annotation.description());
            innerRecord.setRepeatable(annotation.repeatable());
            innerRecord.setField(field);
            innerRecord.setGroups(annotation.groups());
            MetaGroupFields metaGroupFields = new MetaGroupFields();
            innerRecord.setGroupOfFields(metaGroupFields);
            this.readFields(metaGroupFields, field.getType());
            if (!metaGroupFields.getFields().isEmpty()) continue;
            throw new FlatFileManagerException("N\u00e3o foram encontrados campos para o registro filho " + annotation.name());
        }
        this.metadata.setFlatFile(metaFlatFile);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MetaTexgit.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jaxbMarshaller.marshal((Object)this.metadata, (OutputStream)baos);
        return baos.toByteArray();
    }

    private java.lang.reflect.Field getFieldByInnerRecord(Set<java.lang.reflect.Field> fieldsSet, InnerRecord annotation) {
        for (java.lang.reflect.Field field : fieldsSet) {
            Method setterAccessor = ReflectionUtils.getSetterAccessor(field.getType(), (java.lang.reflect.Field)field);
            if (field.isAnnotationPresent(InnerRecord.class) && field.getAnnotation(InnerRecord.class).name().equals(annotation.name())) {
                return field;
            }
            if (setterAccessor == null || !setterAccessor.isAnnotationPresent(InnerRecord.class) || !setterAccessor.getAnnotation(InnerRecord.class).name().equals(annotation.name())) continue;
            return field;
        }
        return null;
    }

    private java.lang.reflect.Field getFieldByRecord(Set<java.lang.reflect.Field> fieldsSet, Record annotation) {
        for (java.lang.reflect.Field field : fieldsSet) {
            Method setterAccessor = ReflectionUtils.getSetterAccessor(field.getType(), (java.lang.reflect.Field)field);
            if (field.isAnnotationPresent(Record.class) && field.getAnnotation(Record.class).name().equals(annotation.name())) {
                return field;
            }
            if (setterAccessor == null || !setterAccessor.isAnnotationPresent(Record.class) || !setterAccessor.getAnnotation(Record.class).name().equals(annotation.name())) continue;
            return field;
        }
        return null;
    }

    private List<Record> readRecords(Set<java.lang.reflect.Field> fieldsSet) {
        ArrayList<Record> result = new ArrayList<Record>();
        for (java.lang.reflect.Field field : fieldsSet) {
            if (!field.isAnnotationPresent(Record.class)) continue;
            Record annotation = field.getAnnotation(Record.class);
            result.add(annotation);
        }
        result.sort(new Comparator<Record>(){

            @Override
            public int compare(Record o1, Record o2) {
                return Integer.valueOf(o1.order()).compareTo(o2.order());
            }
        });
        return result;
    }

    private List<InnerRecord> readInnerRecords(Set<java.lang.reflect.Field> fieldsSet) {
        ArrayList<InnerRecord> result = new ArrayList<InnerRecord>();
        for (java.lang.reflect.Field field : fieldsSet) {
            if (!field.isAnnotationPresent(InnerRecord.class)) continue;
            InnerRecord annotation = field.getAnnotation(InnerRecord.class);
            result.add(annotation);
        }
        result.sort(new Comparator<InnerRecord>(){

            @Override
            public int compare(InnerRecord o1, InnerRecord o2) {
                return Integer.valueOf(o1.order()).compareTo(o2.order());
            }
        });
        return result;
    }

    private void readFields(MetaGroupFields metaGroupFields, Class<?> type) throws FlatFileManagerException {
        Method[] methodsRecord;
        java.lang.reflect.Field[] fieldsRecord = ReflectionUtils.getAllDeclaredFields(type);
        LinkedHashSet<java.lang.reflect.Field> fieldsRecordSet = new LinkedHashSet<java.lang.reflect.Field>();
        fieldsRecordSet.addAll(Arrays.asList(fieldsRecord));
        Method[] methodArray = methodsRecord = ReflectionUtils.getAllDeclaredMethods(type);
        int n = methodsRecord.length;
        int n2 = 0;
        while (n2 < n) {
            Method methodRecord = methodArray[n2];
            java.lang.reflect.Field fieldByMethodSetter = ReflectionUtils.getFieldByMethodSetter((Method)methodRecord);
            if (fieldByMethodSetter != null) {
                fieldsRecordSet.add(fieldByMethodSetter);
            }
            ++n2;
        }
        for (java.lang.reflect.Field fieldRecord : fieldsRecordSet) {
            if (fieldRecord.isAnnotationPresent(IdType.class)) {
                IdType annotationIdType = fieldRecord.getAnnotation(IdType.class);
                MetaOrderedField idType = new MetaOrderedField();
                idType.setBlankAccepted(annotationIdType.blankAccepted());
                idType.setLength(annotationIdType.length());
                idType.setName(annotationIdType.name());
                idType.setPosition(annotationIdType.positionField());
                idType.setType(EnumTypes.STRING);
                idType.setValue(annotationIdType.value());
                metaGroupFields.setIdType(idType);
            }
            if (!fieldRecord.isAnnotationPresent(Field.class)) continue;
            Field annotationField = fieldRecord.getAnnotation(Field.class);
            if (annotationField.type().equals((Object)EnumTypes.BIGDECIMAL) && annotationField.format() == Formats.NONE) {
                throw new FlatFileManagerException("Para campos do tipo BIGDECIMAL informe o format para o mesmo. Campo " + annotationField.name() + ".");
            }
            MetaField metaField = new MetaField();
            metaField.setBlankAccepted(annotationField.blankAccepted());
            metaField.setFormat(annotationField.format().convertToEnumFormats());
            metaField.setLength(annotationField.length());
            metaField.setPadding(annotationField.padding().convertToEnumPaddings());
            metaField.setTruncate(annotationField.truncate());
            metaField.setType(annotationField.type());
            metaField.setValue(annotationField.value());
            metaField.setName(annotationField.name());
            metaField.setField(fieldRecord);
            metaGroupFields.getFields().add(metaField);
        }
    }

    private MetaRecord findRecordOwner(MetaFlatFile metaFlatFile, String recordOwner) {
        for (MetaRecord record : metaFlatFile.getGroupOfRecords().getRecords()) {
            if (!record.getName().equals(recordOwner)) continue;
            return record;
        }
        return null;
    }

    public byte[] getXMLSchema(Object model) throws FlatFileManagerException, JAXBException {
        return this.readAnnotations(model, new String[0]);
    }

    public br.com.anteros.flatfile.FlatFile<br.com.anteros.flatfile.Record> read(Object model, InputStream dataInputStream) throws FlatFileManagerException, JAXBException, IllegalArgumentException, IllegalAccessException, IOException {
        Assert.notNull((Object)model, (String)"Informe um objeto que contenha o modelo de dados.");
        if (!model.getClass().isAnnotationPresent(FlatFile.class)) {
            throw new FlatFileManagerException("O objeto passado como modelo n\u00e3o \u00e9 um v\u00e1lido.");
        }
        this.readAnnotations(model, new String[]{"GLOBAL"});
        br.com.anteros.flatfile.FlatFile<br.com.anteros.flatfile.Record> flatFile = Texgit.createFlatFile(this.metadata);
        List lines = IOUtils.readLines((InputStream)dataInputStream);
        flatFile.read((br.com.anteros.flatfile.Record)((Object)lines));
        return flatFile;
    }

    public br.com.anteros.flatfile.FlatFile<br.com.anteros.flatfile.Record> read(Object model, String[] groups, InputStream dataInputStream) throws FlatFileManagerException, JAXBException, IllegalArgumentException, IllegalAccessException, IOException {
        Assert.notNull((Object)model, (String)"Informe um objeto que contenha o modelo de dados.");
        if (!model.getClass().isAnnotationPresent(FlatFile.class)) {
            throw new FlatFileManagerException("O objeto passado como modelo n\u00e3o \u00e9 um v\u00e1lido.");
        }
        this.readAnnotations(model, groups);
        br.com.anteros.flatfile.FlatFile<br.com.anteros.flatfile.Record> flatFile = Texgit.createFlatFile(this.metadata);
        List lines = IOUtils.readLines((InputStream)dataInputStream);
        flatFile.read((br.com.anteros.flatfile.Record)((Object)lines));
        return flatFile;
    }

    public byte[] generate(Object model) throws FlatFileManagerException, JAXBException, IllegalArgumentException, IllegalAccessException, IOException {
        return this.generate(model, new String[]{"GLOBAL"});
    }

    public byte[] generate(Object model, String[] groups) throws FlatFileManagerException, JAXBException, IllegalArgumentException, IllegalAccessException, IOException {
        Assert.notNull((Object)model, (String)"Informe um objeto que contenha o modelo de dados.");
        if (!model.getClass().isAnnotationPresent(FlatFile.class)) {
            throw new FlatFileManagerException("O objeto passado como modelo n\u00e3o \u00e9 um v\u00e1lido.");
        }
        this.readAnnotations(model, groups);
        br.com.anteros.flatfile.FlatFile<br.com.anteros.flatfile.Record> flatFile = Texgit.createFlatFile(this.metadata);
        for (MetaRecord metaRecord : this.metadata.getFlatFile().getGroupOfRecords().getRecords()) {
            if (!this.isContainsGroups(groups, metaRecord.getGroups())) continue;
            if (metaRecord.isRepeatable()) {
                RecordData recordData = (RecordData)metaRecord.getField().get(model);
                int i = 0;
                while (i < recordData.getNumberOfRecords()) {
                    recordData.readRowData(i);
                    br.com.anteros.flatfile.Record record = this.getRecordByModel(flatFile, metaRecord, recordData);
                    flatFile.addRecord(record);
                    if (metaRecord.getGroupOfInnerRecords() != null && metaRecord.getGroupOfInnerRecords().getRecords().size() > 0) {
                        for (MetaRecord innerRecord : metaRecord.getGroupOfInnerRecords().getRecords()) {
                            RecordData innerRecordData = (RecordData)innerRecord.getField().get(model);
                            record.addInnerRecord(this.getRecordByModel(flatFile, innerRecord, innerRecordData));
                        }
                    }
                    ++i;
                }
                continue;
            }
            flatFile.addRecord(this.getRecordByModel(flatFile, metaRecord, metaRecord.getField().get(model)));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.writeLines((Collection)((Collection)flatFile.write()), (String)IOUtils.LINE_SEPARATOR, (OutputStream)baos);
        return baos.toByteArray();
    }

    protected boolean isContainsGroups(String[] filter, String[] groups) {
        List<String> groupList = Arrays.asList(groups);
        String[] stringArray = filter;
        int n = filter.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            if (groupList.contains(group)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private br.com.anteros.flatfile.Record getRecordByModel(br.com.anteros.flatfile.FlatFile<br.com.anteros.flatfile.Record> flatFile, MetaRecord metaRecord, Object objectRecord) throws IllegalArgumentException, IllegalAccessException {
        br.com.anteros.flatfile.Record result = flatFile.createRecord(metaRecord.getName());
        for (MetaField field : metaRecord.getGroupOfFields().getFields()) {
            Object value = field.getField().get(objectRecord);
            if (value == null) continue;
            result.setValue(field.getName(), value);
        }
        return result;
    }
}

