/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.dbcp.hibernate;

import br.com.anteros.dbcp.AnterosDBCPConfig;
import java.util.Map;
import java.util.Properties;

public class AnterosDBCPConfigurationUtil {
    public static final String CONFIG_PREFIX = "hibernate.hikari.";
    public static final String CONFIG_PREFIX_DATASOURCE = "hibernate.hikari.dataSource.";

    public static AnterosDBCPConfig loadConfiguration(Map props) {
        Properties hikariProps = new Properties();
        AnterosDBCPConfigurationUtil.copyProperty("hibernate.connection.isolation", props, "transactionIsolation", hikariProps);
        AnterosDBCPConfigurationUtil.copyProperty("hibernate.connection.autocommit", props, "autoCommit", hikariProps);
        AnterosDBCPConfigurationUtil.copyProperty("hibernate.connection.driver_class", props, "driverClassName", hikariProps);
        AnterosDBCPConfigurationUtil.copyProperty("hibernate.connection.url", props, "jdbcUrl", hikariProps);
        AnterosDBCPConfigurationUtil.copyProperty("hibernate.connection.username", props, "username", hikariProps);
        AnterosDBCPConfigurationUtil.copyProperty("hibernate.connection.password", props, "password", hikariProps);
        for (Object keyo : props.keySet()) {
            String key = (String)keyo;
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            hikariProps.setProperty(key.substring(CONFIG_PREFIX.length()), (String)props.get(key));
        }
        return new AnterosDBCPConfig(hikariProps);
    }

    private static void copyProperty(String srcKey, Map src, String dstKey, Properties dst) {
        if (src.containsKey(srcKey)) {
            dst.setProperty(dstKey, (String)src.get(srcKey));
        }
    }
}

