/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.dbcp;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.dbcp.AnterosDBCPConfig;
import br.com.anteros.dbcp.AnterosDBCPConfigMXBean;
import br.com.anteros.dbcp.AnterosDBCPPoolMXBean;
import br.com.anteros.dbcp.metrics.MetricsTrackerFactory;
import br.com.anteros.dbcp.pool.AnterosDBCPPool;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;

public class AnterosDBCPDataSource
extends AnterosDBCPConfig
implements DataSource,
Closeable {
    private static final Logger LOGGER = LoggerProvider.getInstance().getLogger(AnterosDBCPDataSource.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final AnterosDBCPPool fastPathPool;
    private volatile AnterosDBCPPool pool;

    public AnterosDBCPDataSource() {
        this.fastPathPool = null;
    }

    public AnterosDBCPDataSource(AnterosDBCPConfig configuration) {
        configuration.validate();
        configuration.copyStateTo(this);
        LOGGER.info((Object)"{} - Starting...", (Object)configuration.getPoolName());
        this.pool = this.fastPathPool = new AnterosDBCPPool(this);
        LOGGER.info((Object)"{} - Start completed.", (Object)configuration.getPoolName());
        this.seal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("AnterosDBCPDataSource " + this + " has been closed.");
        }
        if (this.fastPathPool != null) {
            return this.fastPathPool.getConnection();
        }
        AnterosDBCPPool result = this.pool;
        if (result == null) {
            AnterosDBCPDataSource anterosDBCPDataSource = this;
            synchronized (anterosDBCPDataSource) {
                result = this.pool;
                if (result == null) {
                    this.validate();
                    LOGGER.info((Object)"{} - Starting...", (Object)this.getPoolName());
                    try {
                        this.pool = result = new AnterosDBCPPool(this);
                        this.seal();
                    }
                    catch (AnterosDBCPPool.PoolInitializationException pie) {
                        if (pie.getCause() instanceof SQLException) {
                            throw (SQLException)pie.getCause();
                        }
                        throw pie;
                    }
                    LOGGER.info((Object)"{} - Start completed.", (Object)this.getPoolName());
                }
            }
        }
        return result.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        AnterosDBCPPool p = this.pool;
        return p != null ? p.getUnwrappedDataSource().getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        AnterosDBCPPool p = this.pool;
        if (p != null) {
            p.getUnwrappedDataSource().setLogWriter(out);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        AnterosDBCPPool p = this.pool;
        if (p != null) {
            p.getUnwrappedDataSource().setLoginTimeout(seconds);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        AnterosDBCPPool p = this.pool;
        return p != null ? p.getUnwrappedDataSource().getLoginTimeout() : 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        AnterosDBCPPool p = this.pool;
        if (p != null) {
            DataSource unwrappedDataSource = p.getUnwrappedDataSource();
            if (iface.isInstance(unwrappedDataSource)) {
                return (T)unwrappedDataSource;
            }
            if (unwrappedDataSource != null) {
                return unwrappedDataSource.unwrap(iface);
            }
        }
        throw new SQLException("Wrapped DataSource is not an instance of " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return true;
        }
        AnterosDBCPPool p = this.pool;
        if (p != null) {
            DataSource unwrappedDataSource = p.getUnwrappedDataSource();
            if (iface.isInstance(unwrappedDataSource)) {
                return true;
            }
            if (unwrappedDataSource != null) {
                return unwrappedDataSource.isWrapperFor(iface);
            }
        }
        return false;
    }

    @Override
    public void setMetricRegistry(Object metricRegistry) {
        boolean isAlreadySet = this.getMetricRegistry() != null;
        super.setMetricRegistry(metricRegistry);
        AnterosDBCPPool p = this.pool;
        if (p != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("MetricRegistry can only be set one time");
            }
            p.setMetricRegistry(super.getMetricRegistry());
        }
    }

    @Override
    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        boolean isAlreadySet = this.getMetricsTrackerFactory() != null;
        super.setMetricsTrackerFactory(metricsTrackerFactory);
        AnterosDBCPPool p = this.pool;
        if (p != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("MetricsTrackerFactory can only be set one time");
            }
            p.setMetricsTrackerFactory(super.getMetricsTrackerFactory());
        }
    }

    @Override
    public void setHealthCheckRegistry(Object healthCheckRegistry) {
        boolean isAlreadySet = this.getHealthCheckRegistry() != null;
        super.setHealthCheckRegistry(healthCheckRegistry);
        AnterosDBCPPool p = this.pool;
        if (p != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("HealthCheckRegistry can only be set one time");
            }
            p.setHealthCheckRegistry(super.getHealthCheckRegistry());
        }
    }

    public boolean isRunning() {
        return this.pool != null && this.pool.poolState == 0;
    }

    public AnterosDBCPPoolMXBean getAnterosDBCPPoolMXBean() {
        return this.pool;
    }

    public AnterosDBCPConfigMXBean getAnterosDBCPConfigMXBean() {
        return this;
    }

    public void evictConnection(Connection connection) {
        AnterosDBCPPool p;
        if (!this.isClosed() && (p = this.pool) != null && connection.getClass().getName().startsWith("br.com.anteros.dbcp")) {
            p.evictConnection(connection);
        }
    }

    @Override
    public void close() {
        if (this.isShutdown.getAndSet(true)) {
            return;
        }
        AnterosDBCPPool p = this.pool;
        if (p != null) {
            try {
                LOGGER.info((Object)"{} - Shutdown initiated...", (Object)this.getPoolName());
                p.shutdown();
                LOGGER.info((Object)"{} - Shutdown completed.", (Object)this.getPoolName());
            }
            catch (InterruptedException e) {
                LOGGER.warn((Object)"{} - Interrupted during closing", (Object)this.getPoolName(), (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isClosed() {
        return this.isShutdown.get();
    }

    public String toString() {
        return "AnterosDBCPDataSource (" + this.pool + ")";
    }
}

